/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, MediumTests.class})
public class TestHFileBlockIndex {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileBlockIndex.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileBlockIndex.class);
    private static final Random RNG = new Random();
    private static final int NUM_DATA_BLOCKS = 1000;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int SMALL_BLOCK_SIZE = 4096;
    private static final int NUM_KV = 10000;
    private static FileSystem fs;
    private Path path;
    private long rootIndexOffset;
    private int numRootEntries;
    private int numLevels;
    private static final List<byte[]> keys;
    private final Compression.Algorithm compr;
    private byte[] firstKeyInFile;
    private Configuration conf;
    private static final int[] INDEX_CHUNK_SIZES;
    private static final int[] EXPECTED_NUM_LEVELS;
    private static final int[] UNCOMPRESSED_INDEX_SIZES;
    private static final boolean includesMemstoreTS = true;

    @Parameterized.Parameters
    public static Collection<Object[]> compressionAlgorithms() {
        return HBaseCommonTestingUtility.COMPRESSION_ALGORITHMS_PARAMETERIZED;
    }

    public TestHFileBlockIndex(Compression.Algorithm compr) {
        this.compr = compr;
    }

    @Before
    public void setUp() throws IOException {
        keys.clear();
        this.firstKeyInFile = null;
        this.conf = TEST_UTIL.getConfiguration();
        RNG.setSeed(2389757L);
        this.conf.setInt("hfile.format.version", 3);
        fs = HFileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testBlockIndex() throws IOException {
        this.testBlockIndexInternals(false);
        this.clear();
        this.testBlockIndexInternals(true);
    }

    private void clear() throws IOException {
        keys.clear();
        this.firstKeyInFile = null;
        this.conf = TEST_UTIL.getConfiguration();
        RNG.setSeed(2389757L);
        this.conf.setInt("hfile.format.version", 3);
        fs = HFileSystem.get((Configuration)this.conf);
    }

    private void testBlockIndexInternals(boolean useTags) throws IOException {
        this.path = new Path(TEST_UTIL.getDataTestDir(), "block_index_" + this.compr + useTags);
        this.writeWholeIndex(useTags);
        this.readIndex(useTags);
    }

    private void readIndex(boolean useTags) throws IOException {
        long fileSize = fs.getFileStatus(this.path).getLen();
        LOG.info("Size of {}: {} compression={}", new Object[]{this.path, fileSize, this.compr.toString()});
        FSDataInputStream istream = fs.open(this.path);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(true).withIncludesTags(useTags).withCompression(this.compr).build();
        ReaderContext context = new ReaderContextBuilder().withFileSystemAndPath(fs, this.path).build();
        HFileBlock.FSReaderImpl blockReader = new HFileBlock.FSReaderImpl(context, meta, ByteBuffAllocator.HEAP, this.conf);
        BlockReaderWrapper brw = new BlockReaderWrapper((HFileBlock.FSReader)blockReader);
        HFileBlockIndex.CellBasedKeyBlockIndexReader indexReader = new HFileBlockIndex.CellBasedKeyBlockIndexReader((CellComparator)CellComparatorImpl.COMPARATOR, this.numLevels);
        indexReader.readRootIndex(blockReader.blockRange(this.rootIndexOffset, fileSize).nextBlockWithBlockType(BlockType.ROOT_INDEX), this.numRootEntries);
        long prevOffset = -1L;
        int i = 0;
        int expectedHitCount = 0;
        int expectedMissCount = 0;
        LOG.info("Total number of keys: " + keys.size());
        for (byte[] key : keys) {
            Assert.assertTrue((key != null ? 1 : 0) != 0);
            Assert.assertTrue((indexReader != null ? 1 : 0) != 0);
            KeyValue.KeyOnlyKeyValue keyOnlyKey = new KeyValue.KeyOnlyKeyValue(key, 0, key.length);
            HFileBlock b = indexReader.seekToDataBlock((Cell)keyOnlyKey, null, true, true, false, null, (HFile.CachingBlockReader)brw);
            if (PrivateCellUtil.compare((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)keyOnlyKey, (byte[])this.firstKeyInFile, (int)0, (int)this.firstKeyInFile.length) < 0) {
                Assert.assertTrue((b == null ? 1 : 0) != 0);
                ++i;
                continue;
            }
            String keyStr = "key #" + i + ", " + Bytes.toStringBinary((byte[])key);
            Assert.assertTrue((String)("seekToDataBlock failed for " + keyStr), (b != null ? 1 : 0) != 0);
            if (prevOffset == b.getOffset()) {
                Assert.assertEquals((long)(++expectedHitCount), (long)brw.hitCount);
            } else {
                LOG.info("First key in a new block: " + keyStr + ", block offset: " + b.getOffset() + ")");
                Assert.assertTrue((b.getOffset() > prevOffset ? 1 : 0) != 0);
                Assert.assertEquals((long)(++expectedMissCount), (long)brw.missCount);
                prevOffset = b.getOffset();
            }
            ++i;
        }
        istream.close();
    }

    private void writeWholeIndex(boolean useTags) throws IOException {
        Assert.assertEquals((long)0L, (long)keys.size());
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(true).withIncludesTags(useTags).withCompression(this.compr).withBytesPerCheckSum(16384).build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(TEST_UTIL.getConfiguration(), null, meta);
        FSDataOutputStream outputStream = fs.create(this.path);
        HFileBlockIndex.BlockIndexWriter biw = new HFileBlockIndex.BlockIndexWriter(hbw, null, null);
        for (int i = 0; i < 1000; ++i) {
            hbw.startWriting(BlockType.DATA).write(Bytes.toBytes((String)String.valueOf(RNG.nextInt(1000))));
            long blockOffset = outputStream.getPos();
            hbw.writeHeaderAndData(outputStream);
            byte[] firstKey = null;
            byte[] family = Bytes.toBytes((String)"f");
            byte[] qualifier = Bytes.toBytes((String)"q");
            for (int j = 0; j < 16; ++j) {
                byte[] k = new KeyValue(RandomKeyValueUtil.randomOrderedKey(RNG, i * 16 + j), family, qualifier, EnvironmentEdgeManager.currentTime(), KeyValue.Type.Put).getKey();
                keys.add(k);
                if (j != 8) continue;
                firstKey = k;
            }
            Assert.assertTrue((firstKey != null ? 1 : 0) != 0);
            if (this.firstKeyInFile == null) {
                this.firstKeyInFile = firstKey;
            }
            biw.addEntry(firstKey, blockOffset, hbw.getOnDiskSizeWithHeader());
            this.writeInlineBlocks(hbw, outputStream, biw, false);
        }
        this.writeInlineBlocks(hbw, outputStream, biw, true);
        this.rootIndexOffset = biw.writeIndexBlocks(outputStream);
        outputStream.close();
        this.numLevels = biw.getNumLevels();
        this.numRootEntries = biw.getNumRootEntries();
        LOG.info("Index written: numLevels=" + this.numLevels + ", numRootEntries=" + this.numRootEntries + ", rootIndexOffset=" + this.rootIndexOffset);
    }

    private void writeInlineBlocks(HFileBlock.Writer hbw, FSDataOutputStream outputStream, HFileBlockIndex.BlockIndexWriter biw, boolean isClosing) throws IOException {
        while (biw.shouldWriteBlock(isClosing)) {
            long offset = outputStream.getPos();
            biw.writeInlineBlock((DataOutput)hbw.startWriting(biw.getInlineBlockType()));
            hbw.writeHeaderAndData(outputStream);
            biw.blockWritten(offset, hbw.getOnDiskSizeWithHeader(), hbw.getUncompressedSizeWithoutHeader());
            LOG.info("Wrote an inline index block at " + offset + ", size " + hbw.getOnDiskSizeWithHeader());
        }
    }

    private static final long getDummyFileOffset(int i) {
        return i * 185 + 379;
    }

    private static final int getDummyOnDiskSize(int i) {
        return i * i * 37 + i * 19 + 13;
    }

    @Test
    public void testSecondaryIndexBinarySearch() throws IOException {
        int i;
        int numTotalKeys = 99;
        Assert.assertTrue((numTotalKeys % 2 == 1 ? 1 : 0) != 0);
        int numSearchedKeys = (numTotalKeys - 1) / 2;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(numSearchedKeys);
        int curAllEntriesSize = 0;
        int numEntriesAdded = 0;
        int[] secondaryIndexEntries = new int[numTotalKeys];
        for (i = 0; i < numTotalKeys; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(RNG, i * 2);
            KeyValue cell = new KeyValue(k, Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"val"));
            keys.add(cell.getKey());
            String msgPrefix = "Key #" + i + " (" + Bytes.toStringBinary((byte[])k) + "): ";
            StringBuilder padding = new StringBuilder();
            while (msgPrefix.length() + padding.length() < 70) {
                padding.append(' ');
            }
            msgPrefix = msgPrefix + padding;
            if (i % 2 == 1) {
                dos.writeInt(curAllEntriesSize);
                secondaryIndexEntries[i] = curAllEntriesSize;
                LOG.info(msgPrefix + "secondary index entry #" + (i - 1) / 2 + ", offset " + curAllEntriesSize);
                curAllEntriesSize += cell.getKey().length + 12;
                ++numEntriesAdded;
                continue;
            }
            secondaryIndexEntries[i] = -1;
            LOG.info(msgPrefix + "not in the searched array");
        }
        for (i = 0; i < keys.size() - 1; ++i) {
            Assert.assertTrue((CellComparatorImpl.COMPARATOR.compare((Cell)new KeyValue.KeyOnlyKeyValue(keys.get(i), 0, keys.get(i).length), (Cell)new KeyValue.KeyOnlyKeyValue(keys.get(i + 1), 0, keys.get(i + 1).length)) < 0 ? 1 : 0) != 0);
        }
        dos.writeInt(curAllEntriesSize);
        Assert.assertEquals((long)numSearchedKeys, (long)numEntriesAdded);
        int secondaryIndexOffset = dos.size();
        Assert.assertEquals((long)(4 * (numSearchedKeys + 2)), (long)secondaryIndexOffset);
        for (int i2 = 1; i2 <= numTotalKeys - 1; i2 += 2) {
            Assert.assertEquals((long)dos.size(), (long)(secondaryIndexOffset + secondaryIndexEntries[i2]));
            long dummyFileOffset = TestHFileBlockIndex.getDummyFileOffset(i2);
            int dummyOnDiskSize = TestHFileBlockIndex.getDummyOnDiskSize(i2);
            LOG.debug("Storing file offset=" + dummyFileOffset + " and onDiskSize=" + dummyOnDiskSize + " at offset " + dos.size());
            dos.writeLong(dummyFileOffset);
            dos.writeInt(dummyOnDiskSize);
            LOG.debug("Stored key " + (i2 - 1) / 2 + " at offset " + dos.size());
            dos.write(keys.get(i2));
        }
        dos.writeInt(curAllEntriesSize);
        ByteBuffer nonRootIndex = ByteBuffer.wrap(baos.toByteArray());
        for (int i3 = 0; i3 < numTotalKeys; ++i3) {
            boolean locateBlockResult;
            int referenceItem;
            int expectedResult;
            byte[] searchKey = keys.get(i3);
            byte[] arrayHoldingKey = new byte[searchKey.length + searchKey.length / 2];
            System.arraycopy(searchKey, 0, arrayHoldingKey, searchKey.length / 2, searchKey.length);
            KeyValue.KeyOnlyKeyValue cell = new KeyValue.KeyOnlyKeyValue(arrayHoldingKey, searchKey.length / 2, searchKey.length);
            int searchResult = HFileBlockIndex.BlockIndexReader.binarySearchNonRootIndex((Cell)cell, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{nonRootIndex}), (CellComparator)CellComparatorImpl.COMPARATOR);
            String lookupFailureMsg = "Failed to look up key #" + i3 + " (" + Bytes.toStringBinary((byte[])searchKey) + ")";
            if (i3 % 2 == 1) {
                expectedResult = (i3 - 1) / 2;
                referenceItem = i3;
            } else {
                expectedResult = i3 / 2 - 1;
                referenceItem = i3 - 1;
            }
            Assert.assertEquals((String)lookupFailureMsg, (long)expectedResult, (long)searchResult);
            boolean bl = locateBlockResult = HFileBlockIndex.BlockIndexReader.locateNonRootIndexEntry((ByteBuff)new MultiByteBuff(new ByteBuffer[]{nonRootIndex}), (Cell)cell, (CellComparator)CellComparatorImpl.COMPARATOR) != -1;
            if (i3 == 0) {
                Assert.assertFalse((boolean)locateBlockResult);
                continue;
            }
            Assert.assertTrue((boolean)locateBlockResult);
            String errorMsg = "i=" + i3 + ", position=" + nonRootIndex.position();
            Assert.assertEquals((String)errorMsg, (long)TestHFileBlockIndex.getDummyFileOffset(referenceItem), (long)nonRootIndex.getLong());
            Assert.assertEquals((String)errorMsg, (long)TestHFileBlockIndex.getDummyOnDiskSize(referenceItem), (long)nonRootIndex.getInt());
        }
    }

    @Test
    public void testBlockIndexChunk() throws IOException {
        int i;
        HFileBlockIndex.BlockIndexChunk c = new HFileBlockIndex.BlockIndexChunk();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int N = 1000;
        int[] numSubEntriesAt = new int[N];
        int numSubEntries = 0;
        for (i = 0; i < N; ++i) {
            baos.reset();
            DataOutputStream dos = new DataOutputStream(baos);
            c.writeNonRoot((DataOutput)dos);
            Assert.assertEquals((long)c.getNonRootSize(), (long)dos.size());
            baos.reset();
            dos = new DataOutputStream(baos);
            c.writeRoot((DataOutput)dos);
            Assert.assertEquals((long)c.getRootSize(), (long)dos.size());
            byte[] k = RandomKeyValueUtil.randomOrderedKey(RNG, i);
            keys.add(k);
            c.add(k, TestHFileBlockIndex.getDummyFileOffset(i), TestHFileBlockIndex.getDummyOnDiskSize(i), (long)(numSubEntries += RNG.nextInt(5) + 1));
        }
        for (i = 0; i < N; ++i) {
            int j;
            int n = j = i == 0 ? 0 : numSubEntriesAt[i - 1];
            while (j < numSubEntriesAt[i]) {
                Assert.assertEquals((long)i, (long)c.getEntryBySubEntry((long)j));
                ++j;
            }
        }
    }

    @Test
    public void testHeapSizeForBlockIndex() throws IOException {
        Class<HFileBlockIndex.BlockIndexReader> cl = HFileBlockIndex.BlockIndexReader.class;
        long expected = ClassSize.estimateBase(cl, (boolean)false);
        HFileBlockIndex.ByteArrayKeyBlockIndexReader bi = new HFileBlockIndex.ByteArrayKeyBlockIndexReader(1);
        long actual = bi.heapSize();
        if ((expected -= (long)ClassSize.align((int)(2 * ClassSize.ARRAY))) != actual) {
            expected = ClassSize.estimateBase(cl, (boolean)true);
            Assert.assertEquals((long)expected, (long)actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKeyOnLeafIndexBlockBoundary() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "hfile_for_midkey");
        int maxChunkSize = 512;
        this.conf.setInt("hfile.index.block.max.size", maxChunkSize);
        this.conf.setBoolean("hfile.block.index.cacheonwrite", true);
        CacheConfig cacheConf = new CacheConfig(this.conf, BlockCacheFactory.createBlockCache((Configuration)this.conf));
        BlockCache blockCache = (BlockCache)cacheConf.getBlockCache().get();
        blockCache.evictBlocksByHfileName(hfilePath.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(4096).withCompression(Compression.Algorithm.NONE).withDataBlockEncoding(DataBlockEncoding.NONE).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withPath(fs, hfilePath).withFileContext(meta).create();
        Random rand = new Random(19231737L);
        byte[] family = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        int kvNumberToBeWritten = 16;
        for (int i = 0; i < kvNumberToBeWritten; ++i) {
            byte[] row = RandomKeyValueUtil.randomOrderedFixedLengthKey(rand, i, 30);
            KeyValue kv = new KeyValue(row, family, qualifier, EnvironmentEdgeManager.currentTime(), RandomKeyValueUtil.randomFixedLengthValue(rand, 4096));
            writer.append((Cell)kv);
        }
        writer.close();
        this.conf.setBoolean("hfile.block.index.cacheonwrite", false);
        boolean hasArrayIndexOutOfBoundsException = false;
        try (HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)hfilePath, (CacheConfig)cacheConf, (boolean)true, (Configuration)this.conf);){
            reader.midKey();
        }
        Assert.assertFalse((boolean)hasArrayIndexOutOfBoundsException);
    }

    @Test
    public void testHFileWriterAndReader() throws IOException {
        Path hfilePath = new Path(TEST_UTIL.getDataTestDir(), "hfile_for_block_index");
        CacheConfig cacheConf = new CacheConfig(this.conf, BlockCacheFactory.createBlockCache((Configuration)this.conf));
        BlockCache blockCache = (BlockCache)cacheConf.getBlockCache().get();
        for (int testI = 0; testI < INDEX_CHUNK_SIZES.length; ++testI) {
            HFileBlock block;
            int indexBlockSize = INDEX_CHUNK_SIZES[testI];
            int expectedNumLevels = EXPECTED_NUM_LEVELS[testI];
            LOG.info("Index block size: " + indexBlockSize + ", compression: " + this.compr);
            blockCache.evictBlocksByHfileName(hfilePath.getName());
            this.conf.setInt("hfile.index.block.max.size", indexBlockSize);
            HashSet<String> keyStrSet = new HashSet<String>();
            byte[][] keys = new byte[10000][];
            byte[][] values = new byte[10000][];
            HFileContext meta = new HFileContextBuilder().withBlockSize(4096).withCompression(this.compr).build();
            HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withPath(fs, hfilePath).withFileContext(meta).create();
            Random rand = new Random(19231737L);
            byte[] family = Bytes.toBytes((String)"f");
            byte[] qualifier = Bytes.toBytes((String)"q");
            for (int i = 0; i < 10000; ++i) {
                byte[] row = RandomKeyValueUtil.randomOrderedKey(rand, i);
                KeyValue kv = new KeyValue(row, family, qualifier, EnvironmentEdgeManager.currentTime(), RandomKeyValueUtil.randomValue(rand));
                byte[] k = kv.getKey();
                writer.append((Cell)kv);
                keys[i] = k;
                values[i] = CellUtil.cloneValue((Cell)kv);
                keyStrSet.add(Bytes.toStringBinary((byte[])k));
                if (i <= 0) continue;
                Assert.assertTrue((PrivateCellUtil.compare((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)kv, (byte[])keys[i - 1], (int)0, (int)keys[i - 1].length) > 0 ? 1 : 0) != 0);
            }
            writer.close();
            HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)hfilePath, (CacheConfig)cacheConf, (boolean)true, (Configuration)this.conf);
            Assert.assertEquals((long)expectedNumLevels, (long)reader.getTrailer().getNumDataIndexLevels());
            Assert.assertTrue((boolean)Bytes.equals((byte[])keys[0], (byte[])((KeyValue)reader.getFirstKey().get()).getKey()));
            Assert.assertTrue((boolean)Bytes.equals((byte[])keys[9999], (byte[])((KeyValue)reader.getLastKey().get()).getKey()));
            LOG.info("Last key: " + Bytes.toStringBinary((byte[])keys[9999]));
            for (boolean pread : new boolean[]{false, true}) {
                int i;
                HFileScanner scanner = reader.getScanner(this.conf, true, pread);
                for (i = 0; i < 10000; ++i) {
                    this.checkSeekTo(keys, scanner, i);
                    this.checkKeyValue("i=" + i, keys[i], values[i], ByteBuffer.wrap(((KeyValue)scanner.getKey()).getKey()), scanner.getValue());
                }
                Assert.assertTrue((boolean)scanner.seekTo());
                for (i = 9999; i >= 0; --i) {
                    this.checkSeekTo(keys, scanner, i);
                    this.checkKeyValue("i=" + i, keys[i], values[i], ByteBuffer.wrap(((KeyValue)scanner.getKey()).getKey()), scanner.getValue());
                }
            }
            HFile.Reader reader2 = reader;
            HFileBlock.FSReader fsReader = reader2.getUncachedBlockReader();
            HFileBlock.BlockIterator iter = fsReader.blockRange(0L, reader.getTrailer().getLoadOnOpenDataOffset());
            ArrayList<byte[]> blockKeys = new ArrayList<byte[]>();
            while ((block = iter.nextBlock()) != null) {
                if (block.getBlockType() != BlockType.LEAF_INDEX) {
                    return;
                }
                ByteBuff b = block.getBufferReadOnly();
                int n = b.getIntAfterPosition(0);
                int entriesOffset = 4 * (n + 2);
                for (int i = 0; i < n; ++i) {
                    int keyRelOffset = b.getIntAfterPosition(4 * (i + 1));
                    int nextKeyRelOffset = b.getIntAfterPosition(4 * (i + 2));
                    int keyLen = nextKeyRelOffset - keyRelOffset;
                    int keyOffset = b.arrayOffset() + entriesOffset + keyRelOffset + 12;
                    byte[] blockKey = Arrays.copyOfRange(b.array(), keyOffset, keyOffset + keyLen);
                    String blockKeyStr = Bytes.toString((byte[])blockKey);
                    blockKeys.add(blockKey);
                    Assert.assertTrue((String)("Invalid block key from leaf-level block: " + blockKeyStr), (boolean)keyStrSet.contains(blockKeyStr));
                }
            }
            Assert.assertEquals((Object)Bytes.toStringBinary((byte[])((byte[])blockKeys.get((blockKeys.size() - 1) / 2))), (Object)reader.midKey());
            Assert.assertEquals((long)UNCOMPRESSED_INDEX_SIZES[testI], (long)reader.getTrailer().getUncompressedDataIndexSize());
            reader.close();
            reader2.close();
        }
    }

    private void checkSeekTo(byte[][] keys, HFileScanner scanner, int i) throws IOException {
        Assert.assertEquals((String)("Failed to seek to key #" + i + " (" + Bytes.toStringBinary((byte[])keys[i]) + ")"), (long)0L, (long)scanner.seekTo((Cell)KeyValueUtil.createKeyValueFromKey((byte[])keys[i])));
    }

    private void assertArrayEqualsBuffer(String msgPrefix, byte[] arr, ByteBuffer buf) {
        Assert.assertEquals((String)(msgPrefix + ": expected " + Bytes.toStringBinary((byte[])arr) + ", actual " + Bytes.toStringBinary((ByteBuffer)buf)), (long)0L, (long)Bytes.compareTo((byte[])arr, (int)0, (int)arr.length, (byte[])buf.array(), (int)buf.arrayOffset(), (int)buf.limit()));
    }

    private void checkKeyValue(String msgPrefix, byte[] expectedKey, byte[] expectedValue, ByteBuffer keyRead, ByteBuffer valueRead) {
        if (!msgPrefix.isEmpty()) {
            msgPrefix = msgPrefix + ". ";
        }
        this.assertArrayEqualsBuffer(msgPrefix + "Invalid key", expectedKey, keyRead);
        this.assertArrayEqualsBuffer(msgPrefix + "Invalid value", expectedValue, valueRead);
    }

    @Test
    public void testIntermediateLevelIndicesWithLargeKeys() throws IOException {
        this.testIntermediateLevelIndicesWithLargeKeys(16);
    }

    @Test
    public void testIntermediateLevelIndicesWithLargeKeysWithMinNumEntries() throws IOException {
        this.testIntermediateLevelIndicesWithLargeKeys(2);
    }

    public void testIntermediateLevelIndicesWithLargeKeys(int minNumEntries) throws IOException {
        Path hfPath = new Path(TEST_UTIL.getDataTestDir(), "testIntermediateLevelIndicesWithLargeKeys.hfile");
        int maxChunkSize = 1024;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        CacheConfig cacheConf = new CacheConfig(this.conf);
        this.conf.setInt("hfile.index.block.max.size", maxChunkSize);
        this.conf.setInt("hfile.index.block.min.entries", minNumEntries);
        HFileContext context = new HFileContextBuilder().withBlockSize(16).build();
        HFile.Writer hfw = new HFile.WriterFactory(this.conf, cacheConf).withFileContext(context).withPath(fs, hfPath).create();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (int i = 0; i < 100; ++i) {
            byte[] rowkey = new byte[maxChunkSize + 1];
            byte[] b = Bytes.toBytes((int)i);
            System.arraycopy(b, 0, rowkey, rowkey.length - b.length, b.length);
            keys.add(rowkey);
            hfw.append(CellUtil.createCell((byte[])rowkey));
        }
        hfw.close();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)hfPath, (CacheConfig)cacheConf, (boolean)true, (Configuration)this.conf);
        HFileScanner scanner = reader.getScanner(this.conf, true, true);
        for (int i = 0; i < keys.size(); ++i) {
            scanner.seekTo(CellUtil.createCell((byte[])((byte[])keys.get(i))));
        }
        reader.close();
    }

    static {
        keys = new ArrayList<byte[]>();
        INDEX_CHUNK_SIZES = new int[]{4096, 512, 384};
        EXPECTED_NUM_LEVELS = new int[]{2, 3, 4};
        UNCOMPRESSED_INDEX_SIZES = new int[]{19187, 21813, 23086};
        assert (INDEX_CHUNK_SIZES.length == EXPECTED_NUM_LEVELS.length);
        assert (INDEX_CHUNK_SIZES.length == UNCOMPRESSED_INDEX_SIZES.length);
    }

    private static class BlockReaderWrapper
    implements HFile.CachingBlockReader {
        private HFileBlock.FSReader realReader;
        private long prevOffset;
        private long prevOnDiskSize;
        private boolean prevPread;
        private HFileBlock prevBlock;
        public int hitCount = 0;
        public int missCount = 0;

        public BlockReaderWrapper(HFileBlock.FSReader realReader) {
            this.realReader = realReader;
        }

        public HFileBlock readBlock(long offset, long onDiskSize, boolean cacheBlock, boolean pread, boolean isCompaction, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
            if (offset == this.prevOffset && onDiskSize == this.prevOnDiskSize && pread == this.prevPread) {
                ++this.hitCount;
                return this.prevBlock;
            }
            ++this.missCount;
            this.prevBlock = this.realReader.readBlockData(offset, onDiskSize, pread, false, true);
            this.prevOffset = offset;
            this.prevOnDiskSize = onDiskSize;
            this.prevPread = pread;
            return this.prevBlock;
        }
    }
}

