/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegionReplicaTestHelper;
import org.apache.hadoop.hbase.client.RpcConnectionRegistry;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRpcConnectionRegistry {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcConnectionRegistry.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private RpcConnectionRegistry registry;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.initial_refresh_delay_secs", 1L);
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.refresh_interval_secs", 1L);
        UTIL.getConfiguration().setLong("hbase.client.bootstrap.min_secs_between_refreshes", 0L);
        UTIL.startMiniCluster(3);
        HBaseTestingUtility.setReplicas(UTIL.getAdmin(), TableName.META_TABLE_NAME, 3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException {
        this.registry = new RpcConnectionRegistry(UTIL.getConfiguration());
    }

    @After
    public void tearDown() throws IOException {
        Closeables.close((Closeable)this.registry, (boolean)true);
    }

    private void setMaxNodeCount(int count) {
        UTIL.getMiniHBaseCluster().getMasterThreads().stream().map(t -> t.getMaster().getConfiguration()).forEach(conf -> conf.setInt("hbase.client.bootstrap.node.limit", count));
        UTIL.getMiniHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getConfiguration()).forEach(conf -> conf.setInt("hbase.client.bootstrap.node.limit", count));
    }

    @Test
    public void testRegistryRPCs() throws Exception {
        HMaster activeMaster = UTIL.getHBaseCluster().getMaster();
        Thread.sleep(3000L);
        MatcherAssert.assertThat((Object)this.registry.getParsedServers(), (Matcher)CoreMatchers.hasItems((Object[])activeMaster.getServerManager().getOnlineServersList().toArray(new ServerName[0])));
        RegionReplicaTestHelper.waitUntilAllMetaReplicasAreReady(UTIL, (ConnectionRegistry)this.registry);
        Assert.assertEquals(this.registry.getClusterId().get(), (Object)activeMaster.getClusterId());
        Assert.assertEquals(this.registry.getActiveMaster().get(), (Object)activeMaster.getServerName());
        List<HRegionLocation> metaLocations = Arrays.asList(((RegionLocations)this.registry.getMetaRegionLocations().get()).getRegionLocations());
        List actualMetaLocations = (List)activeMaster.getMetaRegionLocationCache().getMetaRegionLocations().get();
        Collections.sort(metaLocations);
        Collections.sort(actualMetaLocations);
        Assert.assertEquals((Object)actualMetaLocations, metaLocations);
        this.setMaxNodeCount(1);
        UTIL.waitFor(10000L, () -> this.registry.getParsedServers().size() == 1);
    }
}

