/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.hadoop.hbase.client.TracedAdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestRawAsyncTableScan
extends AbstractTestAsyncTableScan {
    private static final Logger logger = LoggerFactory.getLogger(TestRawAsyncTableScan.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRawAsyncTableScan.class);
    @Parameterized.Parameter(value=0)
    public String scanType;
    @Parameterized.Parameter(value=1)
    public Supplier<Scan> scanCreater;

    @Parameterized.Parameters(name="{index}: type={0}")
    public static List<Object[]> params() {
        return TestRawAsyncTableScan.getScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreater.get();
    }

    @Override
    protected List<Result> doScan(Scan scan, int closeAfter) throws Exception {
        Result result;
        TracedAdvancedScanResultConsumer scanConsumer = new TracedAdvancedScanResultConsumer();
        connectionRule.getAsyncConnection().getTable(TABLE_NAME).scan(scan, (ScanResultConsumerBase)scanConsumer);
        List<Result> results = new ArrayList<Result>();
        if (closeAfter > 0 && scan.getBatch() > 0) {
            closeAfter *= 2;
        }
        while ((result = scanConsumer.take()) != null) {
            results.add(result);
            if (closeAfter <= 0 || results.size() < closeAfter) continue;
        }
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }

    @Override
    protected void assertTraceContinuity() {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestRawAsyncTableScan.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
        String scanOperationSpanId = spans.stream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher onScanMetricsCreatedMatcher = SpanDataMatchers.hasName((String)"TracedAdvancedScanResultConsumer#onScanMetricsCreated");
        MatcherAssert.assertThat(spans, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)onScanMetricsCreatedMatcher)));
        Matcher onNextMatcher = SpanDataMatchers.hasName((String)"TracedAdvancedScanResultConsumer#onNext");
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)onNextMatcher));
        spans.stream().filter(arg_0 -> ((Matcher)onNextMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId)));
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)onNextMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
        Matcher onCompleteMatcher = SpanDataMatchers.hasName((String)"TracedAdvancedScanResultConsumer#onComplete");
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)onCompleteMatcher));
        spans.stream().filter(arg_0 -> ((Matcher)onCompleteMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf((Matcher)onCompleteMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
    }

    @Override
    protected void assertTraceError(Matcher<Attributes> exceptionMatcher) {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasEnded());
        TestRawAsyncTableScan.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.ERROR), (Matcher)SpanDataMatchers.hasException(exceptionMatcher), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
        String scanOperationSpanId = spans.stream().filter(arg_0 -> ((Matcher)scanOperationSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher onCompleteMatcher = SpanDataMatchers.hasName((String)"TracedAdvancedScanResultConsumer#onError");
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)onCompleteMatcher));
        spans.stream().filter(arg_0 -> ((Matcher)onCompleteMatcher).matches(arg_0)).forEach(span -> MatcherAssert.assertThat((Object)span, (Matcher)Matchers.allOf((Matcher)onCompleteMatcher, (Matcher)SpanDataMatchers.hasParentSpanId((String)scanOperationSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded())));
    }
}

