/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableScanAll
extends AbstractTestAsyncTableScan {
    private static final Logger logger = LoggerFactory.getLogger(TestAsyncTableScanAll.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanAll.class);
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Supplier<AsyncTable<?>> getTable;
    @Parameterized.Parameter(value=2)
    public String scanType;
    @Parameterized.Parameter(value=3)
    public Supplier<Scan> scanCreator;

    @Parameterized.Parameters(name="{index}: table={0}, scan={2}")
    public static List<Object[]> params() {
        return TestAsyncTableScanAll.getTableAndScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreator.get();
    }

    @Override
    protected List<Result> doScan(Scan scan, int closeAfter) throws Exception {
        List<Result> results = (List<Result>)this.getTable.get().scanAll(scan).get();
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        if (closeAfter > 0 && closeAfter < results.size()) {
            results = results.subList(0, closeAfter);
        }
        return results;
    }

    @Override
    protected void assertTraceContinuity() {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScanAll.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.OK), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
    }

    @Override
    protected void assertTraceError(Matcher<Attributes> exceptionMatcher) {
        String parentSpanName = this.testName.getMethodName();
        Matcher parentSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)parentSpanName), (Matcher)SpanDataMatchers.hasEnded());
        TestAsyncTableScanAll.waitForSpan((Matcher<SpanData>)parentSpanMatcher);
        List spans = otelClassRule.getSpans().stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            StringTraceRenderer stringTraceRenderer = new StringTraceRenderer(spans);
            stringTraceRenderer.render(arg_0 -> ((Logger)logger).debug(arg_0));
        }
        String parentSpanId = spans.stream().filter(arg_0 -> ((Matcher)parentSpanMatcher).matches(arg_0)).map(SpanData::getSpanId).findAny().orElseThrow(AssertionError::new);
        Matcher scanOperationSpanMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)("SCAN " + TABLE_NAME.getNameWithNamespaceInclAsString()))), (Matcher)SpanDataMatchers.hasParentSpanId((String)parentSpanId), (Matcher)SpanDataMatchers.hasStatusWithCode((StatusCode)StatusCode.ERROR), (Matcher)SpanDataMatchers.hasException(exceptionMatcher), (Matcher)SpanDataMatchers.hasEnded());
        MatcherAssert.assertThat(spans, (Matcher)Matchers.hasItem((Matcher)scanOperationSpanMatcher));
    }
}

