/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.trace.StringTraceRenderer;
import org.apache.hadoop.hbase.client.trace.hamcrest.SpanDataMatchers;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.trace.OpenTelemetryClassRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestServerInternalsTracing {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerInternalsTracing.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerInternalsTracing.class);
    private static final String NO_PARENT_ID = "0000000000000000";
    private static List<SpanData> spans;
    @ClassRule
    public static TestRule classRule;

    @Test
    public void testHMasterConstructor() {
        Matcher masterConstructorMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HMaster.cxtor"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HMaster constructor.", spans, (Matcher)Matchers.hasItem((Matcher)masterConstructorMatcher));
        SpanData masterConstructorSpan = spans.stream().filter(arg_0 -> ((Matcher)masterConstructorMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HMaster constructor span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterConstructorSpan))));
    }

    @Test
    public void testHMasterBecomeActiveMaster() {
        Matcher masterBecomeActiveMasterMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HMaster.becomeActiveMaster"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HMaster.becomeActiveMaster.", spans, (Matcher)Matchers.hasItem((Matcher)masterBecomeActiveMasterMatcher));
        SpanData masterBecomeActiveMasterSpan = spans.stream().filter(arg_0 -> ((Matcher)masterBecomeActiveMasterMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HMaster.becomeActiveMaster span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterBecomeActiveMasterSpan))));
        MatcherAssert.assertThat((String)"the HMaster.becomeActiveMaster span should show Region interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"Region.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterBecomeActiveMasterSpan))));
        MatcherAssert.assertThat((String)"the HMaster.becomeActiveMaster span should show RegionScanner interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RegionScanner.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterBecomeActiveMasterSpan))));
        MatcherAssert.assertThat((String)"the HMaster.becomeActiveMaster span should show hbase:meta interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.containsString((String)"hbase:meta")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterBecomeActiveMasterSpan))));
        MatcherAssert.assertThat((String)"the HMaster.becomeActiveMaster span should show WAL interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"WAL.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterBecomeActiveMasterSpan))));
    }

    @Test
    public void testZKWatcherHMaster() {
        Matcher mZKWatcherMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"ZKWatcher-master")), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the ZKWatcher running in the HMaster.", spans, (Matcher)Matchers.hasItem((Matcher)mZKWatcherMatcher));
        SpanData mZKWatcherSpan = spans.stream().filter(arg_0 -> ((Matcher)mZKWatcherMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the ZKWatcher running in the HMaster span should invoke processEvent.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.containsString((String)"processEvent")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)mZKWatcherSpan))));
    }

    @Test
    public void testHMasterShutdown() {
        Matcher masterShutdownMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HMaster.shutdown"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HMaster.shutdown.", spans, (Matcher)Matchers.hasItem((Matcher)masterShutdownMatcher));
        SpanData masterShutdownSpan = spans.stream().filter(arg_0 -> ((Matcher)masterShutdownMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HMaster.shutdown span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterShutdownSpan))));
        MatcherAssert.assertThat((String)"the HMaster.shutdown span should show ShortCircuitingClusterConnection interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"ShortCircuitingClusterConnection.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterShutdownSpan))));
    }

    @Test
    public void testHMasterExitingMainLoop() {
        Matcher masterExitingMainLoopMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HMaster exiting main loop"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HMaster exiting main loop.", spans, (Matcher)Matchers.hasItem((Matcher)masterExitingMainLoopMatcher));
        SpanData masterExitingMainLoopSpan = spans.stream().filter(arg_0 -> ((Matcher)masterExitingMainLoopMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HMaster exiting main loop span should show HTable interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"HTable.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)masterExitingMainLoopSpan))));
    }

    @Test
    public void testTryRegionServerReport() {
        Matcher tryRegionServerReportMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer.tryRegionServerReport"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span for the region server sending a report.", spans, (Matcher)Matchers.hasItem((Matcher)tryRegionServerReportMatcher));
        SpanData tryRegionServerReportSpan = spans.stream().filter(arg_0 -> ((Matcher)tryRegionServerReportMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the region server report span should have an invocation of the RegionServerReport RPC.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.endsWith((String)"RegionServerStatusService/RegionServerReport")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)tryRegionServerReportSpan))));
    }

    @Test
    public void testHRegionServerStartup() {
        Matcher regionServerStartupMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer.startup"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HRegionServer startup procedure.", spans, (Matcher)Matchers.hasItem((Matcher)regionServerStartupMatcher));
        SpanData regionServerStartupSpan = spans.stream().filter(arg_0 -> ((Matcher)regionServerStartupMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HRegionServer startup procedure span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)regionServerStartupSpan))));
    }

    @Test
    public void testHRegionServerConstructor() {
        Matcher rsConstructorMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer.cxtor"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HRegionServer constructor.", spans, (Matcher)Matchers.hasItem((Matcher)rsConstructorMatcher));
        SpanData rsConstructorSpan = spans.stream().filter(arg_0 -> ((Matcher)rsConstructorMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HRegionServer constructor span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsConstructorSpan))));
        MatcherAssert.assertThat((String)"the HRegionServer constructor span should invoke the MasterAddressTracker.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"MasterAddressTracker.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsConstructorSpan))));
    }

    @Test
    public void testHRegionServerPreRegistrationInitialization() {
        Matcher rsPreRegistrationInitializationMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer.preRegistrationInitialization"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HRegionServer preRegistrationInitialization.", spans, (Matcher)Matchers.hasItem((Matcher)rsPreRegistrationInitializationMatcher));
        SpanData rsPreRegistrationInitializationSpan = spans.stream().filter(arg_0 -> ((Matcher)rsPreRegistrationInitializationMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HRegionServer preRegistrationInitialization span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsPreRegistrationInitializationSpan))));
    }

    @Test
    public void testHRegionServerRegisterWithMaster() {
        Matcher rsRegisterWithMasterMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer.registerWithMaster"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HRegionServer registerWithMaster.", spans, (Matcher)Matchers.hasItem((Matcher)rsRegisterWithMasterMatcher));
        SpanData rsRegisterWithMasterSpan = spans.stream().filter(arg_0 -> ((Matcher)rsRegisterWithMasterMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HRegionServer registerWithMaster span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsRegisterWithMasterSpan))));
        MatcherAssert.assertThat((String)"the HRegionServer registerWithMaster span should have an invocation of the RegionServerStartup RPC.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.endsWith((String)"RegionServerStatusService/RegionServerStartup")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsRegisterWithMasterSpan))));
    }

    @Test
    public void testZKWatcherRegionServer() {
        Matcher rsZKWatcherMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"ZKWatcher-regionserver")), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the ZKWatcher running in the HRegionServer.", spans, (Matcher)Matchers.hasItem((Matcher)rsZKWatcherMatcher));
        SpanData rsZKWatcherSpan = spans.stream().filter(arg_0 -> ((Matcher)rsZKWatcherMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the ZKWatcher running in the HRegionServer span should invoke processEvent.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.containsString((String)"processEvent")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsZKWatcherSpan))));
    }

    @Test
    public void testHRegionServerExitingMainLoop() {
        Matcher rsExitingMainLoopMatcher = Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"HRegionServer exiting main loop"), (Matcher)SpanDataMatchers.hasParentSpanId((String)NO_PARENT_ID), (Matcher)SpanDataMatchers.hasStatusWithCode((Matcher)Matchers.isOneOf((Object[])new StatusCode[]{StatusCode.OK, StatusCode.ERROR})));
        MatcherAssert.assertThat((String)"there should be a span from the HRegionServer exiting main loop.", spans, (Matcher)Matchers.hasItem((Matcher)rsExitingMainLoopMatcher));
        SpanData rsExitingMainLoopSpan = spans.stream().filter(arg_0 -> ((Matcher)rsExitingMainLoopMatcher).matches(arg_0)).findAny().orElseThrow(AssertionError::new);
        MatcherAssert.assertThat((String)"the HRegionServer exiting main loop span should show zookeeper interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"RecoverableZookeeper.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsExitingMainLoopSpan))));
        MatcherAssert.assertThat((String)"the HRegionServer exiting main loop span should show ShortCircuitingClusterConnection interaction.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((Matcher)Matchers.startsWith((String)"ShortCircuitingClusterConnection.")), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsExitingMainLoopSpan))));
        MatcherAssert.assertThat((String)"the HRegionServer exiting main loop span should invoke CloseMetaHandler.", spans, (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)SpanDataMatchers.hasName((String)"CloseMetaHandler"), (Matcher)SpanDataMatchers.hasParentSpanId((SpanData)rsExitingMainLoopSpan))));
    }

    static {
        classRule = (base, description) -> new Statement(){

            public void evaluate() throws Throwable {
                OpenTelemetryClassRule otelClassRule = OpenTelemetryClassRule.create();
                MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().build();
                Setup setup = new Setup(miniClusterRule::getTestingUtility);
                RuleChain clusterRule = RuleChain.outerRule((TestRule)otelClassRule).around((TestRule)miniClusterRule).around((TestRule)setup);
                clusterRule.apply((Statement)new Noop(), description).evaluate();
                spans = otelClassRule.getSpans();
                if (LOG.isDebugEnabled()) {
                    StringTraceRenderer renderer = new StringTraceRenderer((Collection)spans);
                    renderer.render(arg_0 -> ((Logger)LOG).debug(arg_0));
                }
                base.evaluate();
            }
        };
    }

    private static class Noop
    extends Statement {
        private Noop() {
        }

        public void evaluate() throws Throwable {
        }
    }

    private static class Setup
    extends ExternalResource {
        private final Supplier<HBaseTestingUtility> testingUtilSupplier;

        public Setup(Supplier<HBaseTestingUtility> testingUtilSupplier) {
            this.testingUtilSupplier = testingUtilSupplier;
        }

        protected void before() throws Throwable {
            HBaseTestingUtility testingUtil = this.testingUtilSupplier.get();
            testingUtil.waitTableAvailable(TableName.META_TABLE_NAME);
        }
    }
}

