/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationChangingPeerRegionservers
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationChangingPeerRegionservers.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationChangingPeerRegionservers.class);
    @Parameterized.Parameter
    public boolean serialPeer;

    @Override
    protected boolean isSerialPeer() {
        return this.serialPeer;
    }

    @Parameterized.Parameters(name="{index}: serialPeer={0}")
    public static List<Boolean> parameters() {
        return ImmutableList.of((Object)true, (Object)false);
    }

    @Before
    public void setUp() throws Exception {
        for (JVMClusterUtil.RegionServerThread r : UTIL1.getHBaseCluster().getRegionServerThreads()) {
            UTIL1.getAdmin().rollWALWriter(r.getRegionServer().getServerName());
        }
        UTIL1.deleteTableData(tableName);
        Scan scan = new Scan();
        int lastCount = 0;
        for (int i = 0; i < 50; ++i) {
            if (i == 49) {
                Assert.fail((String)"Waited too much time for truncate");
            }
            ResultScanner scanner = htable2.getScanner(scan);
            Result[] res = scanner.next(1000);
            scanner.close();
            if (res.length == 0) break;
            if (res.length < lastCount) {
                --i;
            }
            lastCount = res.length;
            LOG.info("Still got " + res.length + " rows");
            Thread.sleep(500L);
        }
    }

    @Test
    public void testChangingNumberOfPeerRegionServers() throws IOException, InterruptedException {
        LOG.info("testSimplePutDelete");
        final MiniHBaseCluster peerCluster = UTIL2.getMiniHBaseCluster();
        peerCluster.startRegionServer();
        Waiter.waitFor((Configuration)peerCluster.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return peerCluster.getLiveRegionServerThreads().size() > 1;
            }
        });
        int numRS = peerCluster.getRegionServerThreads().size();
        this.doPutTest(Bytes.toBytes((int)1));
        int rsToStop = peerCluster.getServerWithMeta() == 0 ? 1 : 0;
        peerCluster.stopRegionServer(rsToStop);
        peerCluster.waitOnRegionServer(rsToStop);
        Assert.assertEquals((long)(numRS - 1), (long)peerCluster.getRegionServerThreads().size());
        this.doPutTest(Bytes.toBytes((int)2));
        peerCluster.startRegionServer();
        Assert.assertEquals((long)numRS, (long)peerCluster.getRegionServerThreads().size());
        this.doPutTest(Bytes.toBytes((int)3));
    }

    private void doPutTest(byte[] row) throws IOException, InterruptedException {
        Put put = new Put(row);
        put.addColumn(famName, row, row);
        if (htable1 == null) {
            htable1 = UTIL1.getConnection().getTable(tableName);
        }
        htable1.put(put);
        Get get = new Get(row);
        for (int i = 0; i < 50; ++i) {
            Result res;
            if (i == 49) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
    }
}

