/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcementFactory;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DisableTableViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoInsertsViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoWritesCompactionsViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoWritesViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionServerSpaceQuotaManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerSpaceQuotaManager.class);
    private RegionServerSpaceQuotaManager quotaManager;
    private RegionServerServices rss;

    @Before
    public void setup() throws Exception {
        this.quotaManager = (RegionServerSpaceQuotaManager)Mockito.mock(RegionServerSpaceQuotaManager.class);
        this.rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
    }

    @Test
    public void testSpacePoliciesFromEnforcements() {
        HashMap<TableName, Object> enforcements = new HashMap<TableName, Object>();
        HashMap<TableName, SpaceQuotaSnapshot> expectedPolicies = new HashMap<TableName, SpaceQuotaSnapshot>();
        Mockito.when((Object)this.quotaManager.copyActiveEnforcements()).thenReturn(enforcements);
        Mockito.when((Object)this.quotaManager.getActivePoliciesAsMap()).thenCallRealMethod();
        NoInsertsViolationPolicyEnforcement noInsertsPolicy = new NoInsertsViolationPolicyEnforcement();
        SpaceQuotaSnapshot noInsertsSnapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_INSERTS), 256L, 1024L);
        noInsertsPolicy.initialize(this.rss, TableName.valueOf((String)"no_inserts"), noInsertsSnapshot);
        enforcements.put(noInsertsPolicy.getTableName(), noInsertsPolicy);
        expectedPolicies.put(noInsertsPolicy.getTableName(), noInsertsSnapshot);
        NoWritesViolationPolicyEnforcement noWritesPolicy = new NoWritesViolationPolicyEnforcement();
        SpaceQuotaSnapshot noWritesSnapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES), 512L, 2048L);
        noWritesPolicy.initialize(this.rss, TableName.valueOf((String)"no_writes"), noWritesSnapshot);
        enforcements.put(noWritesPolicy.getTableName(), noWritesPolicy);
        expectedPolicies.put(noWritesPolicy.getTableName(), noWritesSnapshot);
        NoWritesCompactionsViolationPolicyEnforcement noWritesCompactionsPolicy = new NoWritesCompactionsViolationPolicyEnforcement();
        SpaceQuotaSnapshot noWritesCompactionsSnapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.NO_WRITES_COMPACTIONS), 1024L, 4096L);
        noWritesCompactionsPolicy.initialize(this.rss, TableName.valueOf((String)"no_writes_compactions"), noWritesCompactionsSnapshot);
        enforcements.put(noWritesCompactionsPolicy.getTableName(), noWritesCompactionsPolicy);
        expectedPolicies.put(noWritesCompactionsPolicy.getTableName(), noWritesCompactionsSnapshot);
        DisableTableViolationPolicyEnforcement disablePolicy = new DisableTableViolationPolicyEnforcement();
        SpaceQuotaSnapshot disableSnapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 2048L, 8192L);
        disablePolicy.initialize(this.rss, TableName.valueOf((String)"disable"), disableSnapshot);
        enforcements.put(disablePolicy.getTableName(), disablePolicy);
        expectedPolicies.put(disablePolicy.getTableName(), disableSnapshot);
        enforcements.put(TableName.valueOf((String)"no_policy"), new DefaultViolationPolicyEnforcement());
        Map actualPolicies = this.quotaManager.getActivePoliciesAsMap();
        Assert.assertEquals(expectedPolicies, (Object)actualPolicies);
    }

    @Test
    public void testExceptionOnPolicyEnforcementEnable() throws Exception {
        TableName tableName = TableName.valueOf((String)"foo");
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 1024L, 2048L);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        SpaceViolationPolicyEnforcementFactory factory = (SpaceViolationPolicyEnforcementFactory)Mockito.mock(SpaceViolationPolicyEnforcementFactory.class);
        SpaceViolationPolicyEnforcement enforcement = (SpaceViolationPolicyEnforcement)Mockito.mock(SpaceViolationPolicyEnforcement.class);
        RegionServerSpaceQuotaManager realManager = new RegionServerSpaceQuotaManager(rss, factory);
        Mockito.when((Object)factory.create(rss, tableName, snapshot)).thenReturn((Object)enforcement);
        ((SpaceViolationPolicyEnforcement)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Failed for test!")}).when((Object)enforcement)).enable();
        realManager.enforceViolationPolicy(tableName, snapshot);
        Map enforcements = realManager.copyActiveEnforcements();
        Assert.assertTrue((String)("Expected active enforcements to be empty, but were " + enforcements), (boolean)enforcements.isEmpty());
    }

    @Test
    public void testExceptionOnPolicyEnforcementDisable() throws Exception {
        TableName tableName = TableName.valueOf((String)"foo");
        SpaceQuotaSnapshot snapshot = new SpaceQuotaSnapshot(new SpaceQuotaSnapshot.SpaceQuotaStatus(SpaceViolationPolicy.DISABLE), 1024L, 2048L);
        RegionServerServices rss = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        SpaceViolationPolicyEnforcementFactory factory = (SpaceViolationPolicyEnforcementFactory)Mockito.mock(SpaceViolationPolicyEnforcementFactory.class);
        SpaceViolationPolicyEnforcement enforcement = (SpaceViolationPolicyEnforcement)Mockito.mock(SpaceViolationPolicyEnforcement.class);
        RegionServerSpaceQuotaManager realManager = new RegionServerSpaceQuotaManager(rss, factory);
        Mockito.when((Object)factory.create(rss, tableName, snapshot)).thenReturn((Object)enforcement);
        ((SpaceViolationPolicyEnforcement)Mockito.doNothing().when((Object)enforcement)).enable();
        ((SpaceViolationPolicyEnforcement)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Failed for test!")}).when((Object)enforcement)).disable();
        realManager.enforceViolationPolicy(tableName, snapshot);
        Map enforcements = realManager.copyActiveEnforcements();
        Assert.assertEquals((long)1L, (long)enforcements.size());
        realManager.disableViolationPolicyEnforcement(tableName);
        enforcements = realManager.copyActiveEnforcements();
        Assert.assertEquals((long)1L, (long)enforcements.size());
    }
}

