/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SecureBulkLoadClient;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SpaceQuotaHelperForTests {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceQuotaHelperForTests.class);
    public static final int SIZE_PER_VALUE = 256;
    public static final String F1 = "f1";
    public static final long ONE_KILOBYTE = 1024L;
    public static final long ONE_MEGABYTE = 0x100000L;
    public static final long ONE_GIGABYTE = 0x40000000L;
    private final HBaseTestingUtility testUtil;
    private final TestName testName;
    private final AtomicLong counter;
    private static final int NUM_RETRIES = 10;

    public SpaceQuotaHelperForTests(HBaseTestingUtility testUtil, TestName testName, AtomicLong counter) {
        this.testUtil = Objects.requireNonNull(testUtil);
        this.testName = Objects.requireNonNull(testName);
        this.counter = Objects.requireNonNull(counter);
    }

    static void updateConfigForQuotas(Configuration conf) {
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.delay", 1000);
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.period", 1000);
        conf.setInt("hbase.master.quotas.observer.chore.delay", 1000);
        conf.setInt("hbase.master.quotas.observer.chore.period", 1000);
        conf.setInt("hbase.regionserver.quotas.policy.refresher.chore.delay", 1000);
        conf.setInt("hbase.regionserver.quotas.policy.refresher.chore.period", 1000);
        conf.setInt("hbase.master.quotas.snapshot.chore.delay", 1000);
        conf.setInt("hbase.master.quotas.snapshot.chore.period", 1000);
        conf.setInt("hbase.regionserver.quotas.region.size.reporting.chore.period", 1000);
        conf.setInt("hbase.regionserver.quotas.region.size.reporting.chore.delay", 1000);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 5000);
        conf.setBoolean("hbase.quota.enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long listNumDefinedQuotas(Connection conn) throws IOException {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration());){
            long l = Iterables.size((Iterable)scanner);
            return l;
        }
    }

    TableName writeUntilViolationAndVerifyViolation(SpaceViolationPolicy policyToViolate, Mutation m) throws Exception {
        TableName tn = this.writeUntilViolation(policyToViolate);
        this.verifyViolation(policyToViolate, tn, m);
        return tn;
    }

    TableName writeUntilViolation(SpaceViolationPolicy policyToViolate) throws Exception {
        TableName tn = this.createTableWithRegions(10);
        this.setQuotaLimit(tn, policyToViolate, 2L);
        this.writeData(tn, 0x300000L);
        Thread.sleep(5000L);
        return tn;
    }

    TableName writeUntilViolationAndVerifyViolationInNamespace(String ns, SpaceViolationPolicy policyToViolate, Mutation m) throws Exception {
        TableName tn = this.writeUntilViolationInNamespace(ns, policyToViolate);
        this.verifyViolation(policyToViolate, tn, m);
        return tn;
    }

    TableName writeUntilViolationInNamespace(String ns, SpaceViolationPolicy policyToViolate) throws Exception {
        TableName tn = this.createTableWithRegions(ns, 10);
        this.setQuotaLimit(ns, policyToViolate, 4L);
        this.writeData(tn, 0x500000L);
        Thread.sleep(5000L);
        return tn;
    }

    void verifyViolation(SpaceViolationPolicy policyToViolate, TableName tn, Mutation m) throws Exception {
        boolean sawError = false;
        String msg = "";
        for (int i = 0; i < 10 && !sawError; ++i) {
            try (Table table = this.testUtil.getConnection().getTable(tn);){
                if (m instanceof Put) {
                    table.put((Put)m);
                } else if (m instanceof Delete) {
                    table.delete((Delete)m);
                } else if (m instanceof Append) {
                    table.append((Append)m);
                } else if (m instanceof Increment) {
                    table.increment((Increment)m);
                } else {
                    Assert.fail((String)("Failed to apply " + m.getClass().getSimpleName() + " to the table. Programming error"));
                }
                LOG.info("Did not reject the " + m.getClass().getSimpleName() + ", will sleep and retry");
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                msg = StringUtils.stringifyException((Throwable)e);
                if (policyToViolate.equals((Object)SpaceViolationPolicy.DISABLE) && e instanceof TableNotEnabledException || msg.contains(policyToViolate.name())) {
                    LOG.info("Got the expected exception={}", (Object)msg);
                    sawError = true;
                    break;
                }
                LOG.warn("Did not get the expected exception, will sleep and retry", (Throwable)e);
                Thread.sleep(2000L);
            }
        }
        if (!sawError) {
            try (Table quotaTable = this.testUtil.getConnection().getTable(QuotaUtil.QUOTA_TABLE_NAME);){
                ResultScanner scanner = quotaTable.getScanner(new Scan());
                Result result = null;
                LOG.info("Dumping contents of hbase:quota table");
                while ((result = scanner.next()) != null) {
                    LOG.info(Bytes.toString((byte[])result.getRow()) + " => " + result.toString());
                }
                scanner.close();
            }
        } else if (policyToViolate.equals((Object)SpaceViolationPolicy.DISABLE)) {
            Assert.assertTrue((msg.contains("TableNotEnabledException") || msg.contains(policyToViolate.name()) ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Expected exception message to contain the word '" + policyToViolate.name() + "', but was " + msg), (boolean)msg.contains(policyToViolate.name()));
        }
        Assert.assertTrue((String)"Expected to see an exception writing data to a table exceeding its quota", (boolean)sawError);
    }

    void verifyNoViolation(TableName tn, Mutation m) throws Exception {
        boolean sawSuccess = false;
        for (int i = 0; i < 10 && !sawSuccess; ++i) {
            try (Table table = this.testUtil.getConnection().getTable(tn);){
                if (m instanceof Put) {
                    table.put((Put)m);
                } else if (m instanceof Delete) {
                    table.delete((Delete)m);
                } else if (m instanceof Append) {
                    table.append((Append)m);
                } else if (m instanceof Increment) {
                    table.increment((Increment)m);
                } else {
                    Assert.fail((String)("Failed to apply " + m.getClass().getSimpleName() + " to the table. Programming error"));
                }
                sawSuccess = true;
                continue;
            }
            catch (Exception e) {
                LOG.info("Rejected the " + m.getClass().getSimpleName() + ", will sleep and retry");
                Thread.sleep(2000L);
            }
        }
        if (!sawSuccess) {
            try (Table quotaTable = this.testUtil.getConnection().getTable(QuotaUtil.QUOTA_TABLE_NAME);){
                ResultScanner scanner = quotaTable.getScanner(new Scan());
                Result result = null;
                LOG.info("Dumping contents of hbase:quota table");
                while ((result = scanner.next()) != null) {
                    LOG.info(Bytes.toString((byte[])result.getRow()) + " => " + result.toString());
                }
                scanner.close();
            }
        }
        Assert.assertTrue((String)"Expected to succeed in writing data to a table not having quota ", (boolean)sawSuccess);
    }

    void verifyTableUsageSnapshotForSpaceQuotaExist(TableName tn) throws Exception {
        boolean sawUsageSnapshot = false;
        try (Table quotaTable = this.testUtil.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            Scan s = QuotaTableUtil.makeQuotaSnapshotScanForTable((TableName)tn);
            ResultScanner rs = quotaTable.getScanner(s);
            sawUsageSnapshot = rs.next() != null;
        }
        Assert.assertTrue((String)"Expected to succeed in getting table usage snapshots for space quota", (boolean)sawUsageSnapshot);
    }

    void setQuotaLimit(TableName tn, SpaceViolationPolicy policy, long sizeInMBs) throws Exception {
        long sizeLimit = sizeInMBs * 0x100000L;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)sizeLimit, (SpaceViolationPolicy)policy);
        this.testUtil.getAdmin().setQuota(settings);
        LOG.debug("Quota limit set for table = {}, limit = {}", (Object)tn, (Object)sizeLimit);
    }

    void setQuotaLimit(String ns, SpaceViolationPolicy policy, long sizeInMBs) throws Exception {
        long sizeLimit = sizeInMBs * 0x100000L;
        QuotaSettings settings = QuotaSettingsFactory.limitNamespaceSpace((String)ns, (long)sizeLimit, (SpaceViolationPolicy)policy);
        this.testUtil.getAdmin().setQuota(settings);
        LOG.debug("Quota limit set for namespace = {}, limit = {}", (Object)ns, (Object)sizeLimit);
    }

    void removeQuotaFromtable(TableName tn) throws Exception {
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        this.testUtil.getAdmin().setQuota(removeQuota);
        LOG.debug("Space quota settings removed from the table ", (Object)tn);
    }

    ClientServiceCallable<Void> generateFileToLoad(TableName tn, int numFiles, int numRowsPerFile) throws Exception {
        final Connection conn = this.testUtil.getConnection();
        FileSystem fs = this.testUtil.getTestFileSystem();
        final Configuration conf = this.testUtil.getConfiguration();
        Path baseDir = new Path(fs.getHomeDirectory(), this.testName.getMethodName() + "_files");
        fs.mkdirs(baseDir);
        final ArrayList<Pair> famPaths = new ArrayList<Pair>();
        for (int i = 1; i <= numFiles; ++i) {
            Path hfile = new Path(baseDir, "file" + i);
            TestHRegionServerBulkLoad.createHFile(fs, hfile, Bytes.toBytes((String)F1), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"), numRowsPerFile);
            famPaths.add(new Pair((Object)Bytes.toBytes((String)F1), (Object)hfile.toString()));
        }
        Table table = conn.getTable(tn);
        final String bulkToken = new SecureBulkLoadClient(conf, table).prepareBulkLoad(conn);
        return new ClientServiceCallable<Void>(conn, tn, Bytes.toBytes((String)"row"), (RpcController)new RpcControllerFactory(conf).newController(), -1){

            public Void rpcCall() throws Exception {
                SecureBulkLoadClient secureClient = null;
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                try (Table table = conn.getTable(this.getTableName());){
                    secureClient = new SecureBulkLoadClient(conf, table);
                    secureClient.secureBulkLoadHFiles((ClientProtos.ClientService.BlockingInterface)this.getStub(), famPaths, regionName, true, null, bulkToken);
                }
                return null;
            }
        };
    }

    void removeQuotaFromNamespace(String ns) throws Exception {
        QuotaSettings removeQuota = QuotaSettingsFactory.removeNamespaceSpaceLimit((String)ns);
        Admin admin = this.testUtil.getAdmin();
        admin.setQuota(removeQuota);
        LOG.debug("Space quota settings removed from the namespace ", (Object)ns);
    }

    void removeAllQuotas() throws Exception {
        Connection conn = this.testUtil.getConnection();
        this.removeAllQuotas(conn);
        Assert.assertEquals((long)0L, (long)this.listNumDefinedQuotas(conn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllQuotas(Connection conn) throws IOException {
        if (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            this.waitForQuotaTable(conn);
        } else {
            try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration());){
                for (QuotaSettings quotaSettings : scanner) {
                    String namespace = quotaSettings.getNamespace();
                    TableName tableName = quotaSettings.getTableName();
                    String userName = quotaSettings.getUserName();
                    if (namespace != null) {
                        LOG.debug("Deleting quota for namespace: " + namespace);
                        QuotaUtil.deleteNamespaceQuota((Connection)conn, (String)namespace);
                        continue;
                    }
                    if (tableName != null) {
                        LOG.debug("Deleting quota for table: " + tableName);
                        QuotaUtil.deleteTableQuota((Connection)conn, (TableName)tableName);
                        continue;
                    }
                    if (userName == null) continue;
                    LOG.debug("Deleting quota for user: " + userName);
                    QuotaUtil.deleteUserQuota((Connection)conn, (String)userName);
                }
            }
        }
    }

    QuotaSettings getTableSpaceQuota(Connection conn, TableName tn) throws IOException {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration(), (QuotaFilter)new QuotaFilter().setTableFilter(tn.getNameAsString()));){
            for (QuotaSettings setting : scanner) {
                if (!setting.getTableName().equals((Object)tn) || setting.getQuotaType() != QuotaType.SPACE) continue;
                QuotaSettings quotaSettings = setting;
                return quotaSettings;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    public void waitForQuotaTable(Connection conn) throws IOException {
        this.waitForQuotaTable(conn, 30000L);
    }

    public void waitForQuotaTable(final Connection conn, long timeout) throws IOException {
        this.testUtil.waitFor(timeout, 1000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME);
            }
        });
    }

    void writeData(TableName tn, long sizeInBytes) throws IOException {
        this.writeData(this.testUtil.getConnection(), tn, sizeInBytes);
    }

    void writeData(Connection conn, TableName tn, long sizeInBytes) throws IOException {
        this.writeData(tn, sizeInBytes, Bytes.toBytes((String)"q1"));
    }

    void writeData(TableName tn, long sizeInBytes, String qual) throws IOException {
        this.writeData(tn, sizeInBytes, Bytes.toBytes((String)qual));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeData(TableName tn, long sizeInBytes, byte[] qual) throws IOException {
        Connection conn = this.testUtil.getConnection();
        try (Table table = conn.getTable(tn);){
            ArrayList<Put> updates = new ArrayList<Put>();
            long bytesToWrite = sizeInBytes;
            long rowKeyId = 0L;
            StringBuilder sb = new StringBuilder();
            Random r = new Random();
            while (bytesToWrite > 0L) {
                sb.setLength(0);
                sb.append(Long.toString(rowKeyId));
                Put p = new Put(Bytes.toBytes((String)sb.reverse().toString()));
                byte[] value = new byte[256];
                r.nextBytes(value);
                p.addColumn(Bytes.toBytes((String)F1), qual, value);
                updates.add(p);
                if (updates.size() > 50) {
                    table.put(updates);
                    updates.clear();
                }
                bytesToWrite -= 256L;
                ++rowKeyId;
            }
            if (!updates.isEmpty()) {
                table.put(updates);
            }
            LOG.debug("Data was written to HBase");
            this.testUtil.getAdmin().flush(tn);
            LOG.debug("Data flushed to disk");
        }
    }

    NamespaceDescriptor createNamespace() throws Exception {
        return this.createNamespace(null);
    }

    NamespaceDescriptor createNamespace(String namespace) throws Exception {
        if (namespace == null || namespace.trim().isEmpty()) {
            namespace = "ns" + this.counter.getAndIncrement();
        }
        NamespaceDescriptor nd = NamespaceDescriptor.create((String)namespace).build();
        this.testUtil.getAdmin().createNamespace(nd);
        return nd;
    }

    Multimap<TableName, QuotaSettings> createTablesWithSpaceQuotas() throws Exception {
        Admin admin = this.testUtil.getAdmin();
        HashMultimap tablesWithQuotas = HashMultimap.create();
        TableName tn1 = this.createTable();
        TableName tn2 = this.createTable();
        NamespaceDescriptor nd = this.createNamespace();
        TableName tn3 = this.createTableInNamespace(nd);
        TableName tn4 = this.createTableInNamespace(nd);
        TableName tn5 = this.createTableInNamespace(nd);
        long sizeLimit1 = 0x50000000000L;
        SpaceViolationPolicy violationPolicy1 = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings qs1 = QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy1);
        tablesWithQuotas.put((Object)tn1, (Object)qs1);
        admin.setQuota(qs1);
        long sizeLimit2 = 0x3200000000L;
        SpaceViolationPolicy violationPolicy2 = SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
        QuotaSettings qs2 = QuotaSettingsFactory.limitTableSpace((TableName)tn2, (long)0x3200000000L, (SpaceViolationPolicy)violationPolicy2);
        tablesWithQuotas.put((Object)tn2, (Object)qs2);
        admin.setQuota(qs2);
        long sizeLimit3 = 0x640000000000L;
        SpaceViolationPolicy violationPolicy3 = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings qs3 = QuotaSettingsFactory.limitNamespaceSpace((String)nd.getName(), (long)0x640000000000L, (SpaceViolationPolicy)violationPolicy3);
        tablesWithQuotas.put((Object)tn3, (Object)qs3);
        tablesWithQuotas.put((Object)tn4, (Object)qs3);
        tablesWithQuotas.put((Object)tn5, (Object)qs3);
        admin.setQuota(qs3);
        long sizeLimit4 = 0x140000000L;
        SpaceViolationPolicy violationPolicy4 = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings qs4 = QuotaSettingsFactory.limitTableSpace((TableName)tn5, (long)0x140000000L, (SpaceViolationPolicy)violationPolicy4);
        tablesWithQuotas.put((Object)tn5, (Object)qs4);
        admin.setQuota(qs4);
        return tablesWithQuotas;
    }

    TableName getNextTableName() {
        return this.getNextTableName(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
    }

    TableName getNextTableName(String namespace) {
        return TableName.valueOf((String)namespace, (String)(this.testName.getMethodName() + this.counter.getAndIncrement()));
    }

    TableName createTable() throws Exception {
        return this.createTableWithRegions(1);
    }

    TableName createTableWithRegions(int numRegions) throws Exception {
        return this.createTableWithRegions(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR, numRegions);
    }

    TableName createTableWithRegions(Admin admin, int numRegions) throws Exception {
        return this.createTableWithRegions(admin, NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR, numRegions, 0);
    }

    TableName createTableWithRegions(String namespace, int numRegions) throws Exception {
        return this.createTableWithRegions(this.testUtil.getAdmin(), namespace, numRegions, 0);
    }

    TableName createTableWithRegions(Admin admin, String namespace, int numRegions, int numberOfReplicas) throws Exception {
        TableName tn = this.getNextTableName(namespace);
        if (admin.tableExists(tn)) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        TableDescriptor tableDesc = numberOfReplicas > 0 ? TableDescriptorBuilder.newBuilder((TableName)tn).setRegionReplication(numberOfReplicas).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)F1)).build() : TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)F1)).build();
        if (numRegions == 1) {
            admin.createTable(tableDesc);
        } else {
            admin.createTable(tableDesc, Bytes.toBytes((String)"0"), Bytes.toBytes((String)"9"), numRegions);
        }
        return tn;
    }

    TableName createTableInNamespace(NamespaceDescriptor nd) throws Exception {
        TableName tn;
        Admin admin = this.testUtil.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)nd.getName(), (String)(this.testName.getMethodName() + this.counter.getAndIncrement())))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tn).addColumnFamily(ColumnFamilyDescriptorBuilder.of((String)F1)).build();
        admin.createTable(tableDesc);
        return tn;
    }

    void partitionTablesByQuotaTarget(Multimap<TableName, QuotaSettings> quotas, Set<TableName> tablesWithTableQuota, Set<TableName> tablesWithNamespaceQuota) {
        for (Map.Entry entry : quotas.entries()) {
            SpaceLimitSettings settings = (SpaceLimitSettings)entry.getValue();
            TableName tn = (TableName)entry.getKey();
            if (settings.getTableName() != null) {
                tablesWithTableQuota.add(tn);
            }
            if (settings.getNamespace() != null) {
                tablesWithNamespaceQuota.add(tn);
            }
            if (settings.getTableName() != null || settings.getNamespace() != null) continue;
            Assert.fail((String)("Unexpected table name with null tableName and namespace: " + tn));
        }
    }

    static class NoFilesToDischarge
    implements Waiter.Predicate<Exception> {
        private final MiniHBaseCluster cluster;
        private final TableName tn;

        NoFilesToDischarge(MiniHBaseCluster cluster, TableName tn) {
            this.cluster = cluster;
            this.tn = tn;
        }

        public boolean evaluate() throws Exception {
            for (HRegion region : this.cluster.getRegions(this.tn)) {
                for (HStore store : region.getStores()) {
                    Collection files = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
                    if (null == files || files.isEmpty()) continue;
                    LOG.debug(region.getRegionInfo().getEncodedName() + " still has compacted files");
                    return false;
                }
            }
            return true;
        }
    }

    static abstract class SpaceQuotaSnapshotPredicate
    implements Waiter.Predicate<Exception> {
        private final Connection conn;
        private final TableName tn;
        private final String ns;

        SpaceQuotaSnapshotPredicate(Connection conn, TableName tn) {
            this(Objects.requireNonNull(conn), Objects.requireNonNull(tn), null);
        }

        SpaceQuotaSnapshotPredicate(Connection conn, String ns) {
            this(Objects.requireNonNull(conn), null, Objects.requireNonNull(ns));
        }

        SpaceQuotaSnapshotPredicate(Connection conn, TableName tn, String ns) {
            if (null != tn && null != ns || null == tn && null == ns) {
                throw new IllegalArgumentException("One of TableName and Namespace must be non-null, and the other null");
            }
            this.conn = conn;
            this.tn = tn;
            this.ns = ns;
        }

        public boolean evaluate() throws Exception {
            SpaceQuotaSnapshot snapshot = null == this.ns ? (SpaceQuotaSnapshot)this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(this.tn) : (SpaceQuotaSnapshot)this.conn.getAdmin().getCurrentSpaceQuotaSnapshot(this.ns);
            LOG.debug("Saw quota snapshot for " + (null == this.tn ? this.ns : this.tn) + ": " + snapshot);
            if (null == snapshot) {
                return false;
            }
            return this.evaluate(snapshot);
        }

        abstract boolean evaluate(SpaceQuotaSnapshot var1) throws Exception;
    }
}

