/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.namespace.TestNamespaceAuditor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSimpleRegionNormalizerOnCluster {
    private static final Logger LOG = LoggerFactory.getLogger(TestSimpleRegionNormalizerOnCluster.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSimpleRegionNormalizerOnCluster.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"fam");
    private static Admin admin;
    private static HMaster master;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.normalizer.merge.min_region_age.days", 0);
        TEST_UTIL.startMiniCluster(1);
        TestNamespaceAuditor.waitForQuotaInitialize(TEST_UTIL);
        admin = TEST_UTIL.getAdmin();
        master = TEST_UTIL.getHBaseCluster().getMaster();
        Assert.assertNotNull((Object)master);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        admin.normalizerSwitch(false);
    }

    @Test
    public void testHonorsNormalizerSwitch() throws IOException {
        Assert.assertFalse((boolean)admin.isNormalizerEnabled());
        Assert.assertFalse((boolean)admin.normalize());
        Assert.assertFalse((boolean)admin.normalizerSwitch(true));
        Assert.assertTrue((boolean)admin.normalize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHonorsNormalizerTableSetting() throws Exception {
        TableName tn1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tn2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        TableName tn3 = TableName.valueOf((String)(this.name.getMethodName() + "3"));
        try {
            int tn1RegionCount = TestSimpleRegionNormalizerOnCluster.createTableBegsSplit(tn1, true, false);
            int tn2RegionCount = TestSimpleRegionNormalizerOnCluster.createTableBegsSplit(tn2, false, false);
            int tn3RegionCount = TestSimpleRegionNormalizerOnCluster.createTableBegsSplit(tn3, true, true);
            Assert.assertFalse((boolean)admin.normalizerSwitch(true));
            Assert.assertTrue((boolean)admin.normalize());
            TestSimpleRegionNormalizerOnCluster.waitForTableSplit(tn1, tn1RegionCount + 1);
            Assert.assertEquals((String)(tn1 + " should have split."), (long)(tn1RegionCount + 1), (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tn1));
            Assert.assertEquals((String)(tn2 + " should not have split."), (long)tn2RegionCount, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tn2));
            TestSimpleRegionNormalizerOnCluster.waitForTableRegionCount(tn3, tn3RegionCount);
        }
        finally {
            TestSimpleRegionNormalizerOnCluster.dropIfExists(tn1);
            TestSimpleRegionNormalizerOnCluster.dropIfExists(tn2);
            TestSimpleRegionNormalizerOnCluster.dropIfExists(tn3);
        }
    }

    @Test
    public void testRegionNormalizationSplitWithoutQuotaLimit() throws Exception {
        this.testRegionNormalizationSplit(false);
    }

    @Test
    public void testRegionNormalizationSplitWithQuotaLimit() throws Exception {
        this.testRegionNormalizationSplit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testRegionNormalizationSplit(boolean limitedByQuota) throws Exception {
        TableName tableName;
        block3: {
            tableName = null;
            try {
                tableName = limitedByQuota ? TestSimpleRegionNormalizerOnCluster.buildTableNameForQuotaTest(this.name.getMethodName()) : TableName.valueOf((String)this.name.getMethodName());
                int currentRegionCount = TestSimpleRegionNormalizerOnCluster.createTableBegsSplit(tableName, true, false);
                long existingSkippedSplitCount = master.getRegionNormalizer().getSkippedCount(NormalizationPlan.PlanType.SPLIT);
                Assert.assertFalse((boolean)admin.normalizerSwitch(true));
                Assert.assertTrue((boolean)admin.normalize());
                if (limitedByQuota) {
                    TestSimpleRegionNormalizerOnCluster.waitForSkippedSplits(master, existingSkippedSplitCount);
                    Assert.assertEquals((String)(tableName + " should not have split."), (long)currentRegionCount, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
                    break block3;
                }
                TestSimpleRegionNormalizerOnCluster.waitForTableSplit(tableName, currentRegionCount + 1);
                Assert.assertEquals((String)(tableName + " should have split."), (long)(currentRegionCount + 1), (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
            }
            catch (Throwable throwable) {
                TestSimpleRegionNormalizerOnCluster.dropIfExists(tableName);
                throw throwable;
            }
        }
        TestSimpleRegionNormalizerOnCluster.dropIfExists(tableName);
    }

    @Test
    public void testRegionNormalizationMerge() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            int currentRegionCount = TestSimpleRegionNormalizerOnCluster.createTableBegsMerge(tableName);
            Assert.assertFalse((boolean)admin.normalizerSwitch(true));
            Assert.assertTrue((boolean)admin.normalize());
            TestSimpleRegionNormalizerOnCluster.waitForTableMerge(tableName, currentRegionCount - 1);
            Assert.assertEquals((String)(tableName + " should have merged."), (long)(currentRegionCount - 1), (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
        }
        finally {
            TestSimpleRegionNormalizerOnCluster.dropIfExists(tableName);
        }
    }

    private static TableName buildTableNameForQuotaTest(String methodName) throws IOException {
        String nsp = "np2";
        NamespaceDescriptor nspDesc = NamespaceDescriptor.create((String)nsp).addConfiguration("hbase.namespace.quota.maxregions", "5").addConfiguration("hbase.namespace.quota.maxtables", "2").build();
        admin.createNamespace(nspDesc);
        return TableName.valueOf((String)(nsp + ':' + methodName));
    }

    private static void waitForSkippedSplits(final HMaster master, final long existingSkippedSplitCount) throws Exception {
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(5L), (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public String explainFailure() {
                return "waiting to observe split attempt and skipped.";
            }

            public boolean evaluate() {
                long skippedSplitCount = master.getRegionNormalizer().getSkippedCount(NormalizationPlan.PlanType.SPLIT);
                return skippedSplitCount > existingSkippedSplitCount;
            }
        });
    }

    private static void waitForTableRegionCount(final TableName tableName, final int targetRegionCount) throws IOException {
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(5L), (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected " + targetRegionCount + " number of regions for table " + tableName;
            }

            public boolean evaluate() throws IOException {
                int currentRegionCount = MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
                return currentRegionCount == targetRegionCount;
            }
        });
    }

    private static void waitForTableSplit(final TableName tableName, final int targetRegionCount) throws IOException {
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(5L), (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected normalizer to split region.";
            }

            public boolean evaluate() throws IOException {
                int currentRegionCount = MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
                return currentRegionCount >= targetRegionCount;
            }
        });
    }

    private static void waitForTableMerge(final TableName tableName, final int targetRegionCount) throws IOException {
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(5L), (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected normalizer to merge regions.";
            }

            public boolean evaluate() throws IOException {
                int currentRegionCount = MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName);
                return currentRegionCount <= targetRegionCount;
            }
        });
    }

    private static List<HRegion> generateTestData(TableName tableName, int ... regionSizesMb) throws IOException {
        List<HRegion> generatedRegions;
        int numRegions = regionSizesMb.length;
        try (Table ignored = TEST_UTIL.createMultiRegionTable(tableName, FAMILY_NAME, numRegions);){
            generatedRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
            generatedRegions.sort(Comparator.comparing(HRegion::getRegionInfo, RegionInfo.COMPARATOR));
            Assert.assertEquals((long)numRegions, (long)generatedRegions.size());
            for (int i = 0; i < numRegions; ++i) {
                HRegion region = generatedRegions.get(i);
                TestSimpleRegionNormalizerOnCluster.generateTestData((Region)region, regionSizesMb[i]);
                region.flush(true);
            }
        }
        return generatedRegions;
    }

    private static void generateTestData(Region region, int numRows) throws IOException {
        LoadTestKVGenerator dataGenerator = new LoadTestKVGenerator(0x100000, 0x100000);
        for (int i = 0; i < numRows; ++i) {
            byte[] key = Bytes.add((byte[])region.getRegionInfo().getStartKey(), (byte[])Bytes.toBytes((int)i));
            for (int j = 0; j < 1; ++j) {
                Put put = new Put(key);
                byte[] col = Bytes.toBytes((String)String.valueOf(j));
                byte[] value = dataGenerator.generateRandomSizeValue((byte[][])new byte[][]{key, col});
                put.addColumn(FAMILY_NAME, col, value);
                region.put(put);
            }
        }
    }

    private static double getRegionSizeMB(MasterServices masterServices, RegionInfo regionInfo) {
        ServerName sn = masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion(regionInfo);
        RegionMetrics regionLoad = (RegionMetrics)masterServices.getServerManager().getLoad(sn).getRegionMetrics().get(regionInfo.getRegionName());
        if (regionLoad == null) {
            LOG.debug("{} was not found in RegionsLoad", (Object)regionInfo.getRegionNameAsString());
            return -1.0;
        }
        return regionLoad.getStoreFileSize().get(Size.Unit.MEGABYTE);
    }

    private static int createTableBegsSplit(TableName tableName, boolean normalizerEnabled, boolean isMergeEnabled) throws IOException {
        final List<HRegion> generatedRegions = TestSimpleRegionNormalizerOnCluster.generateTestData(tableName, 1, 1, 2, 3, 5);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
        admin.flush(tableName);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(tableName)).setNormalizationEnabled(normalizerEnabled).setMergeEnabled(isMergeEnabled).build();
        admin.modifyTable(td);
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected largest region to be >= 4mb.";
            }

            public boolean evaluate() {
                return generatedRegions.stream().mapToDouble(val -> TestSimpleRegionNormalizerOnCluster.getRegionSizeMB((MasterServices)master, val.getRegionInfo())).allMatch(val -> val > 0.0) && TestSimpleRegionNormalizerOnCluster.getRegionSizeMB((MasterServices)master, ((HRegion)generatedRegions.get(4)).getRegionInfo()) >= 4.0;
            }
        });
        return 5;
    }

    private static int createTableBegsMerge(TableName tableName) throws IOException {
        final List<HRegion> generatedRegions = TestSimpleRegionNormalizerOnCluster.generateTestData(tableName, 1, 1, 3, 3, 5);
        Assert.assertEquals((long)5L, (long)MetaTableAccessor.getRegionCount((Connection)TEST_UTIL.getConnection(), (TableName)tableName));
        admin.flush(tableName);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)admin.getDescriptor(tableName)).setNormalizationEnabled(true).build();
        admin.modifyTable(td);
        LOG.debug("waiting for region statistics to settle.");
        TEST_UTIL.waitFor(TimeUnit.MINUTES.toMillis(1L), (Waiter.Predicate)new Waiter.ExplainingPredicate<IOException>(){

            public String explainFailure() {
                return "expected largest region to be >= 4mb.";
            }

            public boolean evaluate() {
                return generatedRegions.stream().mapToDouble(val -> TestSimpleRegionNormalizerOnCluster.getRegionSizeMB((MasterServices)master, val.getRegionInfo())).allMatch(val -> val > 0.0) && TestSimpleRegionNormalizerOnCluster.getRegionSizeMB((MasterServices)master, ((HRegion)generatedRegions.get(4)).getRegionInfo()) >= 4.0;
            }
        });
        return 5;
    }

    private static void dropIfExists(TableName tableName) throws IOException {
        if (tableName != null && admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
    }
}

