/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCatalogJanitor.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogJanitor.class);
    @Rule
    public final TestName name = new TestName();
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private MockMasterServices masterServices;
    private CatalogJanitor janitor;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
    }

    @Before
    public void setup() throws IOException, KeeperException {
        this.setRootDirAndCleanIt(HTU, this.name.getMethodName());
        ConcurrentSkipListMap<ServerName, SortedSet<byte[]>> regionsToRegionServers = new ConcurrentSkipListMap<ServerName, SortedSet<byte[]>>();
        this.masterServices = new MockMasterServices(HTU.getConfiguration(), regionsToRegionServers);
        this.masterServices.start(10, null);
        this.janitor = new CatalogJanitor((MasterServices)this.masterServices);
    }

    @After
    public void teardown() {
        this.janitor.cancel(true);
        this.masterServices.stop("DONE");
    }

    @Test
    public void testCleanParent() throws IOException, InterruptedException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo parent = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result r = this.createResult(parent, splita, splitb);
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path parentdir = new Path(tabledir, parent.getEncodedName());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (RegionInfo)splita, (byte[])td.getColumnFamilies()[0].getName());
        Reference ref = Reference.createTopReference((byte[])Bytes.toBytes((String)"ccc"));
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = this.masterServices.getMasterFileSystem().getFileSystem();
        Path path = ref.write(fs, p);
        Assert.assertTrue((boolean)fs.exists(path));
        LOG.info("Created reference " + path);
        fs.mkdirs(parentdir);
        Assert.assertFalse((boolean)this.janitor.cleanParent((RegionInfo)parent, r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((boolean)fs.exists(parentdir));
        Assert.assertTrue((boolean)fs.delete(p, true));
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)parent, r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentdir) ? 1 : 0) != 0);
    }

    @Test
    public void testParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(this.name.getMethodName(), Bytes.toBytes((String)"eee"));
    }

    @Test
    public void testLastParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(this.name.getMethodName(), new byte[0]);
    }

    private TableDescriptor createTableDescriptorForCurrentMethod() {
        return TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).setColumnFamily((ColumnFamilyDescriptor)new HColumnDescriptor("cf")).build();
    }

    private void parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(String rootDir, byte[] lastEndKey) throws IOException, InterruptedException {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo parent = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"));
        HRegionInfo splitab = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splitba = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"));
        HRegionInfo splitbb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ddd"), lastEndKey);
        TreeMap<HRegionInfo, Result> regions = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        regions.put(parent, this.createResult(parent, splita, splitb));
        regions.put(splitb, this.createResult(splitb, splitba, splitbb));
        regions.put(splita, this.createResult(splita, splitaa, splitab));
        int index = 0;
        for (Map.Entry e : regions.entrySet()) {
            if (index == 0) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(parent.getEncodedName()));
            } else if (index == 1) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splita.getEncodedName()));
            } else if (index == 2) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splitb.getEncodedName()));
            }
            ++index;
        }
        Path splitaRef = this.createReferences(this.masterServices, td, parent, splita, Bytes.toBytes((String)"ccc"), false);
        Assert.assertFalse((boolean)this.janitor.cleanParent((RegionInfo)parent, (Result)regions.get(parent)));
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)splitb, (Result)regions.get(splitb)));
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Path splitaaRef = this.createReferences(this.masterServices, td, splita, splitaa, Bytes.toBytes((String)"bbb"), false);
        Path splitabRef = this.createReferences(this.masterServices, td, splita, splitab, Bytes.toBytes((String)"bbb"), true);
        Assert.assertFalse((boolean)this.janitor.cleanParent((RegionInfo)splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)fs.delete(splitaaRef, true));
        Assert.assertTrue((boolean)fs.delete(splitabRef, true));
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)parent, (Result)regions.get(parent)));
    }

    @Test
    public void testScanDoesNotCleanRegionsWithExistingParents() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo parent = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), HConstants.EMPTY_BYTE_ARRAY, true);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"), true);
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), false);
        HRegionInfo splitab = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        HRegionInfo splitb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), HConstants.EMPTY_BYTE_ARRAY);
        Thread.sleep(1001L);
        TreeMap<HRegionInfo, Result> splitParents = new TreeMap<HRegionInfo, Result>((Comparator<HRegionInfo>)new CatalogJanitor.SplitParentFirstComparator());
        splitParents.put(parent, this.createResult(parent, splita, splitb));
        splita.setOffline(true);
        splitParents.put(splita, this.createResult(splita, splitaa, splitab));
        TreeMap mergedRegions = new TreeMap();
        CatalogJanitor spy = (CatalogJanitor)Mockito.spy((Object)this.janitor);
        CatalogJanitor.Report report = new CatalogJanitor.Report();
        report.count = 10;
        report.mergedRegions.putAll(mergedRegions);
        report.splitParents.putAll(splitParents);
        ((CatalogJanitor)Mockito.doReturn((Object)report).when((Object)spy)).scanForReport();
        LOG.info("parent=" + parent.getShortNameToLog() + ", splita=" + splita.getShortNameToLog());
        Path splitaRef = this.createReferences(this.masterServices, td, parent, splita, Bytes.toBytes((String)"ccc"), false);
        LOG.info("Created reference " + splitaRef);
        int gcs = spy.scan();
        Assert.assertEquals((long)0L, (long)gcs);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        gcs = spy.scan();
        Assert.assertEquals((long)2L, (long)gcs);
    }

    @Test
    public void testSplitParentFirstComparator() {
        CatalogJanitor.SplitParentFirstComparator comp = new CatalogJanitor.SplitParentFirstComparator();
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo rootRegion = new HRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, true);
        HRegionInfo firstRegion = new HRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"bbb"), true);
        HRegionInfo lastRegion = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)rootRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegion, (RegionInfo)firstRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegion, (RegionInfo)lastRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)firstRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)lastRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegion, (RegionInfo)lastRegion) < 0 ? 1 : 0) != 0);
        HRegionInfo firstRegiona = new HRegionInfo(td.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"aaa"), true);
        HRegionInfo firstRegionb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), true);
        HRegionInfo lastRegiona = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ddd"), true);
        HRegionInfo lastRegionb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ddd"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegiona, (RegionInfo)firstRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegionb, (RegionInfo)firstRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegion, (RegionInfo)firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegion, (RegionInfo)firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegiona, (RegionInfo)firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegiona, (RegionInfo)lastRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegionb, (RegionInfo)lastRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)rootRegion, (RegionInfo)lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegion, (RegionInfo)lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegion, (RegionInfo)lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegiona, (RegionInfo)lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegiona, (RegionInfo)lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegiona, (RegionInfo)lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegionb, (RegionInfo)lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)firstRegionb, (RegionInfo)lastRegionb) < 0 ? 1 : 0) != 0);
        HRegionInfo lastRegionaa = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), false);
        HRegionInfo lastRegionab = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), false);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegiona, (RegionInfo)lastRegionaa) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegiona, (RegionInfo)lastRegionab) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare((RegionInfo)lastRegionaa, (RegionInfo)lastRegionab) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArchiveOldRegion() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo parent = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result parentMetaRow = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        CommonFSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)td.getTableName());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (RegionInfo)parent, (byte[])td.getColumnFamilies()[0].getName());
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)this.masterServices.getConfiguration(), (RegionInfo)parent, (Path)tabledir, (byte[])td.getColumnFamilies()[0].getName());
        LOG.debug("Table dir:" + tabledir);
        LOG.debug("Store dir:" + storedir);
        LOG.debug("Store archive dir:" + storeArchive);
        FileStatus[] mockFiles = this.addMockStoreFiles(2, this.masterServices, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        int index = 0;
        for (FileStatus file : storeFiles) {
            LOG.debug("Have store file:" + file.getPath());
            Assert.assertEquals((String)"Got unexpected store file", (Object)mockFiles[index].getPath(), (Object)storeFiles[index].getPath());
            ++index;
        }
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)parent, parentMetaRow));
        Path parentDir = new Path(tabledir, parent.getEncodedName());
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        LOG.debug("Finished cleanup of parent region");
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        this.logFiles("archived files", storeFiles);
        this.logFiles("archived files", archivedStoreFiles);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        CommonFSUtils.delete((FileSystem)fs, (Path)rootdir, (boolean)true);
    }

    private void logFiles(String description, FileStatus[] storeFiles) {
        LOG.debug("Current " + description + ": ");
        for (FileStatus file : storeFiles) {
            LOG.debug(Objects.toString(file.getPath()));
        }
    }

    @Test
    public void testDuplicateHFileResolution() throws Exception {
        TableDescriptor td = this.createTableDescriptorForCurrentMethod();
        HRegionInfo parent = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"eee"));
        HRegionInfo splita = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ccc"));
        HRegionInfo splitb = new HRegionInfo(td.getTableName(), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"eee"));
        Result r = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Path rootdir = this.masterServices.getMasterFileSystem().getRootDir();
        CommonFSUtils.setRootDir((Configuration)fs.getConf(), (Path)rootdir);
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (RegionInfo)parent, (byte[])td.getColumnFamilies()[0].getName());
        System.out.println("Old root:" + rootdir);
        System.out.println("Old table:" + tabledir);
        System.out.println("Old store:" + storedir);
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath((Configuration)this.masterServices.getConfiguration(), (RegionInfo)parent, (Path)tabledir, (byte[])td.getColumnFamilies()[0].getName());
        System.out.println("Old archive:" + storeArchive);
        this.addMockStoreFiles(2, this.masterServices, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)parent, r));
        Path parentDir = new Path(tabledir, parent.getEncodedName());
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        this.addMockStoreFiles(2, this.masterServices, storedir);
        Assert.assertTrue((boolean)this.janitor.cleanParent((RegionInfo)parent, r));
        ProcedureTestingUtility.waitAllProcedures(this.masterServices.getMasterProcedureExecutor());
        Assert.assertTrue((!fs.exists(parentDir) ? 1 : 0) != 0);
        archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs, true);
    }

    @Test
    public void testAlreadyRunningStatus() throws Exception {
        int i;
        int numberOfThreads = 2;
        ArrayList gcValues = new ArrayList();
        Thread[] threads = new Thread[numberOfThreads];
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i] = new Thread(() -> {
                try {
                    gcValues.add(this.janitor.scan());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numberOfThreads; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)"One janitor.scan() call should have returned -1", (boolean)gcValues.contains(-1));
    }

    private FileStatus[] addMockStoreFiles(int count, MasterServices services, Path storedir) throws IOException {
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        fs.mkdirs(storedir);
        for (int i = 0; i < count; ++i) {
            Path storeFile = new Path(storedir, "_store" + i);
            FSDataOutputStream dos = fs.create(storeFile, true);
            dos.writeBytes("Some data: " + i);
            dos.close();
        }
        LOG.debug("Adding " + count + " store files to the storedir:" + storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertEquals((String)"Didn't have expected store files", (long)count, (long)storeFiles.length);
        return storeFiles;
    }

    private String setRootDirAndCleanIt(HBaseTestingUtility htu, String subdir) throws IOException {
        Path testdir = htu.getDataTestDir(subdir);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        if (fs.exists(testdir)) {
            Assert.assertTrue((boolean)fs.delete(testdir, true));
        }
        CommonFSUtils.setRootDir((Configuration)htu.getConfiguration(), (Path)testdir);
        return CommonFSUtils.getRootDir((Configuration)htu.getConfiguration()).toString();
    }

    private Path createReferences(MasterServices services, TableDescriptor td, HRegionInfo parent, HRegionInfo daughter, byte[] midkey, boolean top) throws IOException {
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = CommonFSUtils.getTableDir((Path)rootdir, (TableName)parent.getTable());
        Path storedir = HStore.getStoreHomedir((Path)tabledir, (RegionInfo)daughter, (byte[])td.getColumnFamilies()[0].getName());
        Reference ref = top ? Reference.createTopReference((byte[])midkey) : Reference.createBottomReference((byte[])midkey);
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        return p;
    }

    private Result createResult(HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(parent, null, a, b);
    }
}

