/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.ExclusiveMemHFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileReaderImpl;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.SharedMemHFileBlock;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.TestBucketCache;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, LargeTests.class})
public class TestHFileScannerImplReferenceCount {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileScannerImplReferenceCount.class);
    @Rule
    public TestName CASE = new TestName();
    @Parameterized.Parameter
    public String ioengine;
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileScannerImplReferenceCount.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] SUFFIX = TestHFileScannerImplReferenceCount.randLongBytes();
    private static final int CELL_COUNT = 1000;
    private Configuration conf;
    private Path workDir;
    private FileSystem fs;
    private Path hfilePath;
    private Cell firstCell = null;
    private Cell secondCell = null;
    private ByteBuffAllocator allocator;

    @Parameterized.Parameters(name="{index}: ioengine={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"file"}, {"offheap"}, {"mmap"}, {"pmem"});
    }

    private static byte[] randLongBytes() {
        Random rand = new Random();
        byte[] keys = new byte[30];
        rand.nextBytes(keys);
        return keys;
    }

    @BeforeClass
    public static void setUpBeforeClass() {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hfile.index.block.max.size", 10);
        conf.setInt("hfile.index.block.min.entries", 2);
        conf.set("hbase.bucketcache.ioengine", "offheap");
        conf.setInt("hbase.bucketcache.size", 32);
        conf.setInt("hbase.server.allocator.buffer.size", 1024);
        conf.setInt("hbase.server.allocator.max.buffer.count", 32768);
        conf.setInt("hbase.server.allocator.minimal.allocate.size", 0);
    }

    @Before
    public void setUp() throws IOException {
        String caseName = this.CASE.getMethodName().replaceAll("[^a-zA-Z0-9]", "_");
        this.workDir = UTIL.getDataTestDir(caseName);
        if (!"offheap".equals(this.ioengine)) {
            this.ioengine = this.ioengine + ":" + this.workDir.toString() + "/cachedata";
        }
        UTIL.getConfiguration().set("hbase.bucketcache.ioengine", this.ioengine);
        this.firstCell = null;
        this.secondCell = null;
        this.allocator = ByteBuffAllocator.create((Configuration)UTIL.getConfiguration(), (boolean)true);
        this.conf = new Configuration(UTIL.getConfiguration());
        this.fs = this.workDir.getFileSystem(this.conf);
        this.hfilePath = new Path(this.workDir, caseName + System.currentTimeMillis());
        LOG.info("Start to write {} cells into hfile: {}, case:{}", new Object[]{1000, this.hfilePath, caseName});
    }

    @After
    public void tearDown() throws IOException {
        this.allocator.clean();
        this.fs.delete(this.workDir, true);
    }

    private void waitBucketCacheFlushed(BlockCache cache) throws InterruptedException {
        Assert.assertTrue((boolean)(cache instanceof CombinedBlockCache));
        BlockCache[] blockCaches = cache.getBlockCaches();
        Assert.assertEquals((long)blockCaches.length, (long)2L);
        Assert.assertTrue((boolean)(blockCaches[1] instanceof BucketCache));
        TestBucketCache.waitUntilAllFlushedToBucket((BucketCache)blockCaches[1]);
    }

    private void writeHFile(Configuration conf, FileSystem fs, Path hfilePath, Compression.Algorithm compression, DataBlockEncoding encoding, int cellCount) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(1).withDataBlockEncoding(DataBlockEncoding.NONE).withCompression(compression).withDataBlockEncoding(encoding).build();
        try (HFile.Writer writer = new HFile.WriterFactory(conf, new CacheConfig(conf)).withPath(fs, hfilePath).withFileContext(context).create();){
            Random rand = new Random(9713312L);
            for (int i = 0; i < cellCount; ++i) {
                byte[] keyBytes = Bytes.add((byte[])Bytes.toBytes((int)i), (byte[])SUFFIX);
                byte[] valueBytes = RandomKeyValueUtil.randomValue(rand);
                KeyValue keyValue = new KeyValue(keyBytes, FAMILY, QUALIFIER, Long.MAX_VALUE, valueBytes);
                if (this.firstCell == null) {
                    this.firstCell = keyValue;
                } else if (this.secondCell == null) {
                    this.secondCell = keyValue;
                }
                writer.append((Cell)keyValue);
            }
        }
    }

    private void testReleaseBlock(Compression.Algorithm compression, DataBlockEncoding encoding) throws Exception {
        this.writeHFile(this.conf, this.fs, this.hfilePath, compression, encoding, 1000);
        BlockCache defaultBC = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        CacheConfig cacheConfig = new CacheConfig(this.conf, null, defaultBC, this.allocator);
        Assert.assertNotNull((Object)defaultBC);
        Assert.assertTrue((boolean)cacheConfig.isCombinedBlockCache());
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)this.hfilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)this.conf);
        Assert.assertTrue((boolean)(reader instanceof HFileReaderImpl));
        Assert.assertEquals((long)16L, (long)reader.getTrailer().getNumDataIndexLevels());
        HFileReaderImpl.HFileScannerImpl scanner = (HFileReaderImpl.HFileScannerImpl)reader.getScanner(true, true, false);
        HFileBlock block1 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.firstCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        this.waitBucketCacheFlushed(defaultBC);
        Assert.assertTrue((boolean)block1.getBlockType().isData());
        Assert.assertFalse((boolean)(block1 instanceof ExclusiveMemHFileBlock));
        HFileBlock block2 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.secondCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        this.waitBucketCacheFlushed(defaultBC);
        Assert.assertTrue((boolean)block2.getBlockType().isData());
        Assert.assertFalse((boolean)(block2 instanceof ExclusiveMemHFileBlock));
        Assert.assertEquals((long)block1.refCnt(), (long)1L);
        Assert.assertEquals((long)block2.refCnt(), (long)1L);
        Assert.assertFalse((block1 == block2 ? 1 : 0) != 0);
        scanner.seekTo(this.firstCell);
        HFileBlock curBlock = scanner.curBlock;
        this.assertRefCnt(curBlock, 2);
        scanner.seekTo(this.firstCell);
        Assert.assertTrue((curBlock == scanner.curBlock ? 1 : 0) != 0);
        this.assertRefCnt(curBlock, 2);
        HFileBlock prevBlock = curBlock;
        scanner.seekTo(this.secondCell);
        curBlock = scanner.curBlock;
        this.assertRefCnt(prevBlock, 2);
        this.assertRefCnt(curBlock, 2);
        scanner.shipped();
        this.assertRefCnt(prevBlock, 1);
        this.assertRefCnt(curBlock, 2);
        scanner.shipped();
        this.assertRefCnt(prevBlock, 1);
        this.assertRefCnt(curBlock, 2);
        scanner.close();
        this.assertRefCnt(curBlock, 1);
        Assert.assertTrue((boolean)block1.release());
        Assert.assertTrue((boolean)block2.release());
        Assert.assertTrue((defaultBC.evictBlocksByHfileName(this.hfilePath.getName()) >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)prevBlock.refCnt(), (long)0L);
        Assert.assertEquals((long)curBlock.refCnt(), (long)0L);
        int count = 0;
        Assert.assertTrue((boolean)scanner.seekTo());
        ++count;
        while (scanner.next()) {
            ++count;
        }
        Assert.assertEquals((long)1000L, (long)count);
    }

    @Test
    public void testSeekBefore() throws Exception {
        this.writeHFile(this.conf, this.fs, this.hfilePath, Compression.Algorithm.NONE, DataBlockEncoding.NONE, 1000);
        BlockCache defaultBC = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        CacheConfig cacheConfig = new CacheConfig(this.conf, null, defaultBC, this.allocator);
        Assert.assertNotNull((Object)defaultBC);
        Assert.assertTrue((boolean)cacheConfig.isCombinedBlockCache());
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)this.hfilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)this.conf);
        Assert.assertTrue((boolean)(reader instanceof HFileReaderImpl));
        Assert.assertEquals((long)16L, (long)reader.getTrailer().getNumDataIndexLevels());
        HFileReaderImpl.HFileScannerImpl scanner = (HFileReaderImpl.HFileScannerImpl)reader.getScanner(true, true, false);
        HFileBlock block1 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.firstCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        Assert.assertTrue((boolean)block1.getBlockType().isData());
        Assert.assertFalse((boolean)(block1 instanceof ExclusiveMemHFileBlock));
        HFileBlock block2 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.secondCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        Assert.assertTrue((boolean)block2.getBlockType().isData());
        Assert.assertFalse((boolean)(block2 instanceof ExclusiveMemHFileBlock));
        this.waitBucketCacheFlushed(defaultBC);
        Assert.assertEquals((long)block1.refCnt(), (long)1L);
        Assert.assertEquals((long)block2.refCnt(), (long)1L);
        scanner.seekTo(this.secondCell);
        HFileBlock curBlock = scanner.curBlock;
        Assert.assertFalse((curBlock == block2 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)block2.refCnt());
        this.assertRefCnt(curBlock, 2);
        HFileBlock prevBlock = scanner.curBlock;
        Assert.assertTrue((boolean)block1.release());
        Assert.assertEquals((long)0L, (long)block1.refCnt());
        Assert.assertTrue((boolean)block2.release());
        Assert.assertEquals((long)0L, (long)block2.refCnt());
        Assert.assertTrue((boolean)scanner.seekBefore(this.secondCell));
        Assert.assertEquals((long)scanner.prevBlocks.size(), (long)1L);
        Assert.assertTrue((scanner.prevBlocks.get(0) == prevBlock ? 1 : 0) != 0);
        curBlock = scanner.curBlock;
        Assert.assertFalse((curBlock == block1 ? 1 : 0) != 0);
        this.assertRefCnt(curBlock, 2);
        this.assertRefCnt(prevBlock, 2);
        scanner.shipped();
        Assert.assertEquals((long)scanner.prevBlocks.size(), (long)0L);
        Assert.assertNotNull((Object)scanner.curBlock);
        this.assertRefCnt(curBlock, 2);
        this.assertRefCnt(prevBlock, 1);
        scanner.close();
        Assert.assertNull((Object)scanner.curBlock);
        this.assertRefCnt(curBlock, 1);
        this.assertRefCnt(prevBlock, 1);
        Assert.assertTrue((defaultBC.evictBlocksByHfileName(this.hfilePath.getName()) >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)curBlock.refCnt());
        Assert.assertEquals((long)0L, (long)prevBlock.refCnt());
        block1 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.firstCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        this.waitBucketCacheFlushed(defaultBC);
        Assert.assertTrue((boolean)block1.getBlockType().isData());
        Assert.assertFalse((boolean)(block1 instanceof ExclusiveMemHFileBlock));
        Assert.assertTrue((boolean)block1.release());
        Assert.assertEquals((long)0L, (long)block1.refCnt());
        Assert.assertTrue((boolean)scanner.seekTo());
        curBlock = scanner.curBlock;
        Assert.assertFalse((curBlock == block1 ? 1 : 0) != 0);
        this.assertRefCnt(curBlock, 2);
        Assert.assertFalse((boolean)scanner.seekBefore(this.firstCell));
        this.assertRefCnt(curBlock, 2);
        scanner.close();
        this.assertRefCnt(curBlock, 1);
        Assert.assertTrue((defaultBC.evictBlocksByHfileName(this.hfilePath.getName()) >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)curBlock.refCnt());
    }

    private void assertRefCnt(HFileBlock block, int value) {
        if (this.ioengine.startsWith("offheap") || this.ioengine.startsWith("pmem")) {
            Assert.assertEquals((long)value, (long)block.refCnt());
        } else {
            Assert.assertEquals((long)(value - 1), (long)block.refCnt());
        }
    }

    @Test
    public void testDefault() throws Exception {
        this.testReleaseBlock(Compression.Algorithm.NONE, DataBlockEncoding.NONE);
    }

    @Test
    public void testCompression() throws Exception {
        this.testReleaseBlock(Compression.Algorithm.GZ, DataBlockEncoding.NONE);
    }

    @Test
    public void testDataBlockEncoding() throws Exception {
        this.testReleaseBlock(Compression.Algorithm.NONE, DataBlockEncoding.ROW_INDEX_V1);
    }

    @Test
    public void testDataBlockEncodingAndCompression() throws Exception {
        this.testReleaseBlock(Compression.Algorithm.GZ, DataBlockEncoding.ROW_INDEX_V1);
    }

    @Test
    public void testWithLruBlockCache() throws Exception {
        this.writeHFile(this.conf, this.fs, this.hfilePath, Compression.Algorithm.NONE, DataBlockEncoding.NONE, 1000);
        this.conf.set("hbase.bucketcache.ioengine", "");
        BlockCache defaultBC = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        CacheConfig cacheConfig = new CacheConfig(this.conf, null, defaultBC, this.allocator);
        Assert.assertNotNull((Object)defaultBC);
        Assert.assertFalse((boolean)cacheConfig.isCombinedBlockCache());
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)this.hfilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)this.conf);
        Assert.assertTrue((boolean)(reader instanceof HFileReaderImpl));
        Assert.assertEquals((long)16L, (long)reader.getTrailer().getNumDataIndexLevels());
        HFileReaderImpl.HFileScannerImpl scanner = (HFileReaderImpl.HFileScannerImpl)reader.getScanner(true, true, false);
        HFileBlock block1 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.firstCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        Assert.assertTrue((boolean)block1.getBlockType().isData());
        Assert.assertTrue((boolean)(block1 instanceof ExclusiveMemHFileBlock));
        HFileBlock block2 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.secondCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        Assert.assertTrue((boolean)block2.getBlockType().isData());
        Assert.assertTrue((boolean)(block2 instanceof ExclusiveMemHFileBlock));
        Assert.assertEquals((long)block1.refCnt(), (long)0L);
        Assert.assertEquals((long)block2.refCnt(), (long)0L);
        scanner.seekTo(this.firstCell);
        HFileBlock curBlock = scanner.curBlock;
        Assert.assertTrue((curBlock == block1 ? 1 : 0) != 0);
        Assert.assertEquals((long)curBlock.refCnt(), (long)0L);
        Assert.assertTrue((boolean)scanner.prevBlocks.isEmpty());
        scanner.seekTo(this.secondCell);
        curBlock = scanner.curBlock;
        Assert.assertTrue((curBlock == block2 ? 1 : 0) != 0);
        Assert.assertEquals((long)curBlock.refCnt(), (long)0L);
        Assert.assertEquals((long)curBlock.retain().refCnt(), (long)0L);
        Assert.assertTrue((boolean)scanner.prevBlocks.isEmpty());
        scanner.close();
        Assert.assertNull((Object)scanner.curBlock);
        Assert.assertTrue((boolean)scanner.prevBlocks.isEmpty());
    }

    @Test
    public void testDisabledBlockCache() throws Exception {
        this.writeHFile(this.conf, this.fs, this.hfilePath, Compression.Algorithm.NONE, DataBlockEncoding.NONE, 1000);
        this.conf.setFloat("hfile.block.cache.size", 0.0f);
        BlockCache defaultBC = BlockCacheFactory.createBlockCache((Configuration)this.conf);
        Assert.assertNull((Object)defaultBC);
        CacheConfig cacheConfig = new CacheConfig(this.conf, null, defaultBC, this.allocator);
        Assert.assertFalse((boolean)cacheConfig.isCombinedBlockCache());
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)this.hfilePath, (CacheConfig)cacheConfig, (boolean)true, (Configuration)this.conf);
        Assert.assertTrue((boolean)(reader instanceof HFileReaderImpl));
        Assert.assertEquals((long)16L, (long)reader.getTrailer().getNumDataIndexLevels());
        HFileBlock block1 = reader.getDataBlockIndexReader().loadDataBlockWithScanInfo(this.firstCell, null, true, true, false, DataBlockEncoding.NONE, (HFile.CachingBlockReader)reader).getHFileBlock();
        Assert.assertTrue((boolean)block1.isSharedMem());
        Assert.assertTrue((boolean)(block1 instanceof SharedMemHFileBlock));
        Assert.assertEquals((long)1L, (long)block1.refCnt());
        Assert.assertTrue((boolean)block1.release());
    }
}

