/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(ReplicationHFileCleaner.class);
    private ZooKeeperWatcher zkw;
    private ReplicationQueuesClient rqc;
    private boolean stopped = false;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Set<String> hfileRefs;
        if (this.getConf() == null) {
            return files;
        }
        try {
            hfileRefs = this.loadHFileRefsFromPeers();
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed to read hfile references from zookeeper, skipping checking deletable files");
            return Collections.emptyList();
        }
        return Iterables.filter(files, (Predicate)new Predicate<FileStatus>(){

            public boolean apply(FileStatus file) {
                String hfile = file.getPath().getName();
                boolean foundHFileRefInQueue = hfileRefs.contains(hfile);
                if (LOG.isDebugEnabled()) {
                    if (foundHFileRefInQueue) {
                        LOG.debug((Object)("Found hfile reference in ZK, keeping: " + hfile));
                    } else {
                        LOG.debug((Object)("Did not find hfile reference in ZK, deleting: " + hfile));
                    }
                }
                return !foundHFileRefInQueue;
            }
        });
    }

    private Set<String> loadHFileRefsFromPeers() throws KeeperException {
        HashSet hfileRefs = Sets.newHashSet();
        int retry = 0;
        while (true) {
            int v0 = this.rqc.getHFileRefsNodeChangeVersion();
            hfileRefs.clear();
            List listOfPeers = this.rqc.getAllPeersFromHFileRefsQueue();
            if (listOfPeers == null) {
                LOG.debug((Object)"Didn't find any peers with hfile references, won't prevent any deletions.");
                return ImmutableSet.of();
            }
            for (String id : listOfPeers) {
                List peerHFileRefs = this.rqc.getReplicableHFiles(id);
                if (peerHFileRefs == null) continue;
                hfileRefs.addAll(peerHFileRefs);
            }
            int v1 = this.rqc.getHFileRefsNodeChangeVersion();
            if (v0 == v1) {
                return hfileRefs;
            }
            LOG.debug((Object)String.format("Replication hfile references node cversion changed from %d to %d, retry = %d", v0, v1, retry));
            ++retry;
        }
    }

    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", true) || !config.getBoolean("hbase.replication.bulkload.enabled", false)) {
            LOG.warn((Object)("hbase.replication is not enabled so allowing all hfile references to be deleted. Better to remove " + ReplicationHFileCleaner.class + " from " + "hbase.master.hfilecleaner.plugins" + " configuration."));
            return;
        }
        Configuration conf = new Configuration(config);
        try {
            this.setConf(conf, new ZooKeeperWatcher(conf, "replicationHFileCleaner", null));
        }
        catch (IOException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
    }

    @InterfaceAudience.Private
    public void setConf(Configuration conf, ZooKeeperWatcher zk) {
        super.setConf(conf);
        try {
            this.initReplicationQueuesClient(conf, zk);
        }
        catch (IOException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
    }

    private void initReplicationQueuesClient(Configuration conf, ZooKeeperWatcher zk) throws ZooKeeperConnectionException, IOException {
        this.zkw = zk;
        this.rqc = ReplicationFactory.getReplicationQueuesClient((ZooKeeperWatcher)this.zkw, (Configuration)conf, (Abortable)new WarnOnlyAbortable());
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info((Object)("Stopping " + this.zkw));
            this.zkw.close();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        Set<String> hfileRefsFromQueue;
        if (this.getConf() == null) {
            return true;
        }
        try {
            hfileRefsFromQueue = this.loadHFileRefsFromPeers();
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to read hfile references from zookeeper, skipping checking deletable file for " + fStat.getPath()));
            return false;
        }
        return !hfileRefsFromQueue.contains(fStat.getPath().getName());
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        public void abort(String why, Throwable e) {
            LOG.warn((Object)("ReplicationHFileCleaner received abort, ignoring.  Reason: " + why));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }

        public boolean isAborted() {
            return false;
        }
    }
}

