/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public class FinishRegionRecoveringHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(FinishRegionRecoveringHandler.class);
    protected final RegionServerServices rss;
    protected final String regionName;
    protected final String path;

    public FinishRegionRecoveringHandler(RegionServerServices rss, String regionName, String path) {
        super(rss, EventType.M_RS_OPEN_REGION);
        this.rss = rss;
        this.regionName = regionName;
        this.path = path;
    }

    @Override
    public void process() throws IOException {
        Region region = this.rss.getRecoveringRegions().remove(this.regionName);
        if (region != null) {
            ((HRegion)region).setRecovering(false);
            LOG.info((Object)(this.path + " deleted; " + this.regionName + " recovered."));
        }
    }
}

