/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.AbstractFileAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
final class InternalLog4jUtils {
    private InternalLog4jUtils() {
    }

    static void setLogLevel(String loggerName, String levelName) {
        Level level = Level.toLevel((String)levelName.toUpperCase());
        if (!level.toString().equalsIgnoreCase(levelName)) {
            throw new IllegalArgumentException("Unsupported log level " + levelName);
        }
        Configurator.setLevel((String)loggerName, (Level)level);
    }

    static String getEffectiveLevel(String loggerName) {
        Logger logger = LogManager.getLogger((String)loggerName);
        return logger.getLevel().name();
    }

    static Set<File> getActiveLogFiles() throws IOException {
        HashSet<File> ret = new HashSet<File>();
        Logger logger = LogManager.getRootLogger();
        if (!(logger instanceof org.apache.logging.log4j.core.Logger)) {
            return ret;
        }
        org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
        for (Appender appender : coreLogger.getAppenders().values()) {
            String fileName;
            if (appender instanceof FileAppender) {
                fileName = ((FileAppender)appender).getFileName();
                ret.add(new File(fileName));
                continue;
            }
            if (appender instanceof AbstractFileAppender) {
                fileName = ((AbstractFileAppender)appender).getFileName();
                ret.add(new File(fileName));
                continue;
            }
            if (appender instanceof RollingFileAppender) {
                fileName = ((RollingFileAppender)appender).getFileName();
                ret.add(new File(fileName));
                continue;
            }
            if (appender instanceof RandomAccessFileAppender) {
                fileName = ((RandomAccessFileAppender)appender).getFileName();
                ret.add(new File(fileName));
                continue;
            }
            if (!(appender instanceof MemoryMappedFileAppender)) continue;
            fileName = ((MemoryMappedFileAppender)appender).getFileName();
            ret.add(new File(fileName));
        }
        return ret;
    }
}

