/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationActivity {
    private String childName = null;
    private String parentName = null;
    private String appPriority = null;
    private String requestPriority = null;
    private ActivityState state;
    private String diagnostic = null;
    private static final Logger LOG = LoggerFactory.getLogger(AllocationActivity.class);

    public AllocationActivity(String parentName, String queueName, String priority, ActivityState state, String diagnostic, String type) {
        this.childName = queueName;
        this.parentName = parentName;
        if (type != null) {
            if (type.equals("app")) {
                this.appPriority = priority;
            } else if (type.equals("container")) {
                this.requestPriority = priority;
            }
        }
        this.state = state;
        this.diagnostic = diagnostic;
    }

    public ActivityNode createTreeNode() {
        if (this.appPriority != null) {
            return new ActivityNode(this.childName, this.parentName, this.appPriority, this.state, this.diagnostic, "app");
        }
        if (this.requestPriority != null) {
            return new ActivityNode(this.childName, this.parentName, this.requestPriority, this.state, this.diagnostic, "container");
        }
        return new ActivityNode(this.childName, this.parentName, null, this.state, this.diagnostic, null);
    }

    public String getName() {
        return this.childName;
    }

    public String getState() {
        return this.state.toString();
    }
}

