/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.util.AbstractLivelinessMonitor;

public class NMLivelinessMonitor
extends AbstractLivelinessMonitor<NodeId> {
    private EventHandler<Event> dispatcher;

    public NMLivelinessMonitor(Dispatcher d) {
        super("NMLivelinessMonitor");
        this.dispatcher = d.getEventHandler();
    }

    public void serviceInit(Configuration conf) throws Exception {
        int expireIntvl = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.setExpireInterval(expireIntvl);
        this.setMonitorInterval(expireIntvl / 3);
        super.serviceInit(conf);
    }

    protected void expire(NodeId id) {
        this.dispatcher.handle((Event)new RMNodeEvent(id, RMNodeEventType.EXPIRE));
    }
}

