/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.IncreaseContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.RegularContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ContainerAllocator
extends AbstractContainerAllocator {
    AbstractContainerAllocator increaseContainerAllocator;
    AbstractContainerAllocator regularContainerAllocator;

    public ContainerAllocator(FiCaSchedulerApp application, ResourceCalculator rc, RMContext rmContext) {
        super(application, rc, rmContext);
        this.increaseContainerAllocator = new IncreaseContainerAllocator(application, rc, rmContext);
        this.regularContainerAllocator = new RegularContainerAllocator(application, rc, rmContext);
    }

    @Override
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, SchedulingMode schedulingMode, ResourceLimits resourceLimits, RMContainer reservedContainer) {
        if (reservedContainer != null) {
            if (reservedContainer.getState() == RMContainerState.RESERVED) {
                return this.regularContainerAllocator.assignContainers(clusterResource, node, schedulingMode, resourceLimits, reservedContainer);
            }
            return this.increaseContainerAllocator.assignContainers(clusterResource, node, schedulingMode, resourceLimits, reservedContainer);
        }
        CSAssignment assign = this.increaseContainerAllocator.assignContainers(clusterResource, node, schedulingMode, resourceLimits, null);
        if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)assign.getResource(), (Resource)Resources.none())) {
            return assign;
        }
        return this.regularContainerAllocator.assignContainers(clusterResource, node, schedulingMode, resourceLimits, null);
    }
}

