/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(SchedulerApplicationAttempt.class);
    private static final long MEM_AGGREGATE_ALLOCATION_CACHE_MSECS = 3000L;
    protected long lastMemoryAggregateAllocationUpdateTime = 0L;
    private long lastMemorySeconds = 0L;
    private long lastVcoreSeconds = 0L;
    protected final AppSchedulingInfo appSchedulingInfo;
    protected ApplicationAttemptId attemptId;
    protected Map<ContainerId, RMContainer> liveContainers = new HashMap<ContainerId, RMContainer>();
    protected final Map<Priority, Map<NodeId, RMContainer>> reservedContainers = new HashMap<Priority, Map<NodeId, RMContainer>>();
    private final Multiset<Priority> reReservations = HashMultiset.create();
    protected final Resource currentReservation = Resource.newInstance((int)0, (int)0);
    private Resource resourceLimit = Resource.newInstance((int)0, (int)0);
    protected Resource currentConsumption = Resource.newInstance((int)0, (int)0);
    private Resource amResource = Resources.none();
    private boolean unmanagedAM = true;
    private boolean amRunning = false;
    private LogAggregationContext logAggregationContext;
    protected List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    private Set<ContainerId> pendingRelease = null;
    Multiset<Priority> schedulingOpportunities = HashMultiset.create();
    protected Map<Priority, Long> lastScheduledContainer = new HashMap<Priority, Long>();
    protected Queue queue;
    protected boolean isStopped = false;
    protected final RMContext rmContext;

    public SchedulerApplicationAttempt(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        ApplicationSubmissionContext appSubmissionContext;
        Preconditions.checkNotNull((Object)rmContext, (Object)"RMContext should not be null");
        this.rmContext = rmContext;
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, activeUsersManager, rmContext.getEpoch());
        this.queue = queue;
        this.pendingRelease = new HashSet<ContainerId>();
        this.attemptId = applicationAttemptId;
        if (rmContext.getRMApps() != null && rmContext.getRMApps().containsKey(applicationAttemptId.getApplicationId()) && (appSubmissionContext = ((RMApp)rmContext.getRMApps().get(applicationAttemptId.getApplicationId())).getApplicationSubmissionContext()) != null) {
            this.unmanagedAM = appSubmissionContext.getUnmanagedAM();
            this.logAggregationContext = appSubmissionContext.getLogAggregationContext();
        }
    }

    public synchronized Collection<RMContainer> getLiveContainers() {
        return new ArrayList<RMContainer>(this.liveContainers.values());
    }

    public AppSchedulingInfo getAppSchedulingInfo() {
        return this.appSchedulingInfo;
    }

    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.appSchedulingInfo.getResourceRequests(priority);
    }

    public Set<ContainerId> getPendingRelease() {
        return this.pendingRelease;
    }

    public long getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<Priority> getPriorities() {
        return this.appSchedulingInfo.getPriorities();
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        return this.appSchedulingInfo.getResourceRequest(priority, resourceName);
    }

    public synchronized int getTotalRequiredResources(Priority priority) {
        return this.getResourceRequest(priority, "*").getNumContainers();
    }

    public synchronized Resource getResource(Priority priority) {
        return this.appSchedulingInfo.getResource(priority);
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    public Resource getAMResource() {
        return this.amResource;
    }

    public void setAMResource(Resource amResource) {
        this.amResource = amResource;
    }

    public boolean isAmRunning() {
        return this.amRunning;
    }

    public void setAmRunning(boolean bool) {
        this.amRunning = bool;
    }

    public boolean getUnmanagedAM() {
        return this.unmanagedAM;
    }

    public synchronized RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    protected synchronized void resetReReservations(Priority priority) {
        this.reReservations.setCount((Object)priority, 0);
    }

    protected synchronized void addReReservation(Priority priority) {
        this.reReservations.add((Object)priority);
    }

    public synchronized int getReReservations(Priority priority) {
        return this.reReservations.count((Object)priority);
    }

    @InterfaceStability.Stable
    @InterfaceAudience.Private
    public synchronized Resource getCurrentReservation() {
        return this.currentReservation;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateResourceRequests(requests, false);
        }
    }

    public synchronized void recoverResourceRequests(List<ResourceRequest> requests) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateResourceRequests(requests, true);
        }
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.isStopped = true;
        this.appSchedulingInfo.stop(rmAppAttemptFinalState);
    }

    public synchronized boolean isStopped() {
        return this.isStopped;
    }

    public synchronized List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
        for (Map.Entry<Priority, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
            reservedContainers.addAll(e.getValue().values());
        }
        return reservedContainers;
    }

    public synchronized RMContainer reserve(SchedulerNode node, Priority priority, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
            Resources.addTo((Resource)this.currentReservation, (Resource)container.getResource());
            this.resetReReservations(priority);
        } else {
            this.addReReservation(priority);
        }
        rmContainer.handle((Event)new RMContainerReservedEvent(container.getId(), container.getResource(), node.getNodeID(), priority));
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(priority, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Application attempt " + this.getApplicationAttemptId() + " reserved container " + rmContainer + " on node " + node + ". This attempt currently has " + reservedContainers.size() + " reserved containers at priority " + priority + "; currentReservation " + this.currentReservation.getMemory()));
        }
        return rmContainer;
    }

    public synchronized boolean isReserved(SchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers != null) {
            return reservedContainers.containsKey(node.getNodeID());
        }
        return false;
    }

    public synchronized void setHeadroom(Resource globalLimit) {
        this.resourceLimit = globalLimit;
    }

    public synchronized Resource getHeadroom() {
        if (this.resourceLimit.getMemory() < 0) {
            this.resourceLimit.setMemory(0);
        }
        return this.resourceLimit;
    }

    public synchronized int getNumReservedContainers(Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        return reservedContainers == null ? 0 : reservedContainers.size();
    }

    public synchronized void containerLaunchedOnNode(ContainerId containerId, NodeId nodeId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(nodeId, containerId));
            return;
        }
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
    }

    public synchronized void showRequests() {
        if (LOG.isDebugEnabled()) {
            for (Priority priority : this.getPriorities()) {
                Map<String, ResourceRequest> requests = this.getResourceRequests(priority);
                if (requests == null) continue;
                LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.currentConsumption.getMemory()));
                for (ResourceRequest request : requests.values()) {
                    LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " request=" + request));
                }
            }
        }
    }

    public Resource getCurrentConsumption() {
        return this.currentConsumption;
    }

    public synchronized ContainersAndNMTokensAllocation pullNewlyAllocatedContainersAndNMTokens() {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
        ArrayList<NMToken> nmTokens = new ArrayList<NMToken>();
        Iterator<RMContainer> i = this.newlyAllocatedContainers.iterator();
        while (i.hasNext()) {
            Container container;
            RMContainer rmContainer;
            block3: {
                rmContainer = i.next();
                container = rmContainer.getContainer();
                try {
                    container.setContainerToken(this.rmContext.getContainerTokenSecretManager().createContainerToken(container.getId(), container.getNodeId(), this.getUser(), container.getResource(), container.getPriority(), rmContainer.getCreationTime(), this.logAggregationContext));
                    NMToken nmToken = this.rmContext.getNMTokenSecretManager().createAndGetNMToken(this.getUser(), this.getApplicationAttemptId(), container);
                    if (nmToken == null) break block3;
                    nmTokens.add(nmToken);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Object)("Error trying to assign container token and NM token to an allocated container " + container.getId()), (Throwable)e);
                    continue;
                }
            }
            returnContainerList.add(container);
            i.remove();
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
        }
        return new ContainersAndNMTokensAllocation(returnContainerList, nmTokens);
    }

    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateBlacklist(blacklistAdditions, blacklistRemovals);
        }
    }

    public boolean isBlacklisted(String resourceName) {
        return this.appSchedulingInfo.isBlacklisted(resourceName);
    }

    public synchronized void addSchedulingOpportunity(Priority priority) {
        this.schedulingOpportunities.setCount((Object)priority, this.schedulingOpportunities.count((Object)priority) + 1);
    }

    public synchronized void subtractSchedulingOpportunity(Priority priority) {
        int count = this.schedulingOpportunities.count((Object)priority) - 1;
        this.schedulingOpportunities.setCount((Object)priority, Math.max(count, 0));
    }

    public synchronized int getSchedulingOpportunities(Priority priority) {
        return this.schedulingOpportunities.count((Object)priority);
    }

    public synchronized void resetSchedulingOpportunities(Priority priority) {
        this.resetSchedulingOpportunities(priority, System.currentTimeMillis());
    }

    public synchronized void resetSchedulingOpportunities(Priority priority, long currentTimeMs) {
        this.lastScheduledContainer.put(priority, currentTimeMs);
        this.schedulingOpportunities.setCount((Object)priority, 0);
    }

    synchronized AggregateAppResourceUsage getRunningAggregateAppResourceUsage() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastMemoryAggregateAllocationUpdateTime > 3000L) {
            long memorySeconds = 0L;
            long vcoreSeconds = 0L;
            for (RMContainer rmContainer : this.liveContainers.values()) {
                long usedMillis = currentTimeMillis - rmContainer.getCreationTime();
                Resource resource = rmContainer.getContainer().getResource();
                memorySeconds += (long)resource.getMemory() * usedMillis / 1000L;
                vcoreSeconds += (long)resource.getVirtualCores() * usedMillis / 1000L;
            }
            this.lastMemoryAggregateAllocationUpdateTime = currentTimeMillis;
            this.lastMemorySeconds = memorySeconds;
            this.lastVcoreSeconds = vcoreSeconds;
        }
        return new AggregateAppResourceUsage(this.lastMemorySeconds, this.lastVcoreSeconds);
    }

    public synchronized ApplicationResourceUsageReport getResourceUsageReport() {
        AggregateAppResourceUsage resUsage = this.getRunningAggregateAppResourceUsage();
        return ApplicationResourceUsageReport.newInstance((int)this.liveContainers.size(), (int)this.reservedContainers.size(), (Resource)Resources.clone((Resource)this.currentConsumption), (Resource)Resources.clone((Resource)this.currentReservation), (Resource)Resources.add((Resource)this.currentConsumption, (Resource)this.currentReservation), (long)resUsage.getMemorySeconds(), (long)resUsage.getVcoreSeconds());
    }

    public synchronized Map<ContainerId, RMContainer> getLiveContainersMap() {
        return this.liveContainers;
    }

    public synchronized Resource getResourceLimit() {
        return this.resourceLimit;
    }

    public synchronized Map<Priority, Long> getLastScheduledContainer() {
        return this.lastScheduledContainer;
    }

    public synchronized void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        this.liveContainers = appAttempt.getLiveContainersMap();
        this.currentConsumption = appAttempt.getCurrentConsumption();
        this.resourceLimit = appAttempt.getResourceLimit();
        this.lastScheduledContainer = appAttempt.getLastScheduledContainer();
        this.appSchedulingInfo.transferStateFromPreviousAppSchedulingInfo(appAttempt.appSchedulingInfo);
    }

    public synchronized void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        String user = this.getUser();
        for (RMContainer rMContainer : this.liveContainers.values()) {
            Resource resource = rMContainer.getContainer().getResource();
            oldMetrics.releaseResources(user, 1, resource);
            newMetrics.allocateResources(user, 1, resource, false);
        }
        for (Map map : this.reservedContainers.values()) {
            for (RMContainer reservedContainer : map.values()) {
                Resource resource = reservedContainer.getReservedResource();
                oldMetrics.unreserveResource(user, resource);
                newMetrics.reserveResource(user, resource);
            }
        }
        this.appSchedulingInfo.move(newQueue);
        this.queue = newQueue;
    }

    public synchronized void recoverContainer(RMContainer rmContainer) {
        this.appSchedulingInfo.recoverContainer(rmContainer);
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        LOG.info((Object)("SchedulerAttempt " + this.getApplicationAttemptId() + " is recovering container " + rmContainer.getContainerId()));
        this.liveContainers.put(rmContainer.getContainerId(), rmContainer);
        Resources.addTo((Resource)this.currentConsumption, (Resource)rmContainer.getContainer().getResource());
    }

    public void incNumAllocatedContainers(NodeType containerType, NodeType requestType) {
        RMAppAttempt attempt = ((RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
        if (attempt != null) {
            attempt.getRMAppAttemptMetrics().incNumAllocatedContainers(containerType, requestType);
        }
    }

    public void setApplicationHeadroomForMetrics(Resource headroom) {
        RMAppAttempt attempt = ((RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
        if (attempt != null) {
            attempt.getRMAppAttemptMetrics().setApplicationAttemptHeadRoom(Resources.clone((Resource)headroom));
        }
    }

    public Set<String> getBlacklistedNodes() {
        return this.appSchedulingInfo.getBlackListCopy();
    }

    public static class ContainersAndNMTokensAllocation {
        List<Container> containerList;
        List<NMToken> nmTokenList;

        public ContainersAndNMTokensAllocation(List<Container> containerList, List<NMToken> nmTokenList) {
            this.containerList = containerList;
            this.nmTokenList = nmTokenList;
        }

        public List<Container> getContainerList() {
            return this.containerList;
        }

        public List<NMToken> getNMTokenList() {
            return this.nmTokenList;
        }
    }
}

