/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationQueue
extends LeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ReservationQueue.class);
    private PlanQueue parent;
    private int maxSystemApps;

    public ReservationQueue(CapacitySchedulerContext cs, String queueName, PlanQueue parent) throws IOException {
        super(cs, queueName, parent, null);
        this.maxSystemApps = cs.getConfiguration().getMaximumSystemApplications();
        this.updateQuotas(parent.getUserLimitForReservation(), parent.getUserLimitFactor(), parent.getMaxApplicationsForReservations(), parent.getMaxApplicationsPerUserForReservation());
        this.parent = parent;
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof ReservationQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        CSQueueUtils.updateQueueStatistics(this.parent.schedulerContext.getResourceCalculator(), newlyParsedQueue, this.parent, this.parent.schedulerContext.getClusterResource(), this.parent.schedulerContext.getMinimumResourceCapability());
        super.reinitialize(newlyParsedQueue, clusterResource);
        this.updateQuotas(this.parent.getUserLimitForReservation(), this.parent.getUserLimitFactor(), this.parent.getMaxApplicationsForReservations(), this.parent.getMaxApplicationsPerUserForReservation());
    }

    public synchronized void setEntitlement(QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        float capacity = entitlement.getCapacity();
        if (capacity < 0.0f || capacity > 1.0f) {
            throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
        }
        this.setCapacity(capacity);
        this.setAbsoluteCapacity(this.getParent().getAbsoluteCapacity() * this.getCapacity());
        this.setMaxApplications((int)((float)this.maxSystemApps * this.getAbsoluteCapacity()));
        this.setMaxCapacity(entitlement.getMaxCapacity());
        if (LOG.isDebugEnabled()) {
            LOG.debug("successfully changed to " + capacity + " for queue " + this.getQueueName());
        }
    }

    private void updateQuotas(int userLimit, float userLimitFactor, int maxAppsForReservation, int maxAppsPerUserForReservation) {
        this.setUserLimit(userLimit);
        this.setUserLimitFactor(userLimitFactor);
        this.setMaxApplications(maxAppsForReservation);
        this.maxApplicationsPerUser = maxAppsPerUserForReservation;
    }

    @Override
    protected float getCapacityFromConf() {
        return 0.0f;
    }
}

