/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.ArrayList;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateResponsePBImpl;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ContainerResourceDecrease;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncrease;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocateResponse {
    @Test
    public void testAllocateResponseWithIncDecContainers() {
        int i;
        int i2;
        ArrayList<ContainerResourceIncrease> incContainers = new ArrayList<ContainerResourceIncrease>();
        ArrayList<ContainerResourceDecrease> decContainers = new ArrayList<ContainerResourceDecrease>();
        for (i2 = 0; i2 < 3; ++i2) {
            incContainers.add(ContainerResourceIncrease.newInstance(null, (Resource)Resource.newInstance((int)1024, (int)i2), null));
        }
        for (i2 = 0; i2 < 5; ++i2) {
            decContainers.add(ContainerResourceDecrease.newInstance(null, (Resource)Resource.newInstance((int)1024, (int)i2)));
        }
        AllocateResponse r = AllocateResponse.newInstance((int)3, new ArrayList(), new ArrayList(), new ArrayList(), null, (AMCommand)AMCommand.AM_RESYNC, (int)3, null, new ArrayList(), incContainers, decContainers);
        YarnServiceProtos.AllocateResponseProto p = ((AllocateResponsePBImpl)r).getProto();
        r = new AllocateResponsePBImpl(p);
        Assert.assertEquals((long)incContainers.size(), (long)r.getIncreasedContainers().size());
        Assert.assertEquals((long)decContainers.size(), (long)r.getDecreasedContainers().size());
        for (i = 0; i < incContainers.size(); ++i) {
            Assert.assertEquals((long)i, (long)((ContainerResourceIncrease)r.getIncreasedContainers().get(i)).getCapability().getVirtualCores());
        }
        for (i = 0; i < decContainers.size(); ++i) {
            Assert.assertEquals((long)i, (long)((ContainerResourceDecrease)r.getDecreasedContainers().get(i)).getCapability().getVirtualCores());
        }
    }

    @Test
    public void testAllocateResponseWithoutIncDecContainers() {
        AllocateResponse r = AllocateResponse.newInstance((int)3, new ArrayList(), new ArrayList(), new ArrayList(), null, (AMCommand)AMCommand.AM_RESYNC, (int)3, null, new ArrayList(), null, null);
        YarnServiceProtos.AllocateResponseProto p = ((AllocateResponsePBImpl)r).getProto();
        r = new AllocateResponsePBImpl(p);
        Assert.assertEquals((long)0L, (long)r.getIncreasedContainers().size());
        Assert.assertEquals((long)0L, (long)r.getDecreasedContainers().size());
    }
}

