/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.util.ArrayList;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.AllocateRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ContainerResourceIncreaseRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocateRequest {
    @Test
    public void testAllcoateRequestWithIncrease() {
        ArrayList<ContainerResourceIncreaseRequest> incRequests = new ArrayList<ContainerResourceIncreaseRequest>();
        for (int i = 0; i < 3; ++i) {
            incRequests.add(ContainerResourceIncreaseRequest.newInstance(null, (Resource)Resource.newInstance((int)0, (int)i)));
        }
        AllocateRequest r = AllocateRequest.newInstance((int)123, (float)0.0f, null, null, null, incRequests);
        YarnServiceProtos.AllocateRequestProto p = ((AllocateRequestPBImpl)r).getProto();
        r = new AllocateRequestPBImpl(p);
        Assert.assertEquals((long)123L, (long)r.getResponseId());
        Assert.assertEquals((long)incRequests.size(), (long)r.getIncreaseRequests().size());
        for (int i = 0; i < incRequests.size(); ++i) {
            Assert.assertEquals((long)((ContainerResourceIncreaseRequest)r.getIncreaseRequests().get(i)).getCapability().getVirtualCores(), (long)((ContainerResourceIncreaseRequest)incRequests.get(i)).getCapability().getVirtualCores());
        }
    }

    @Test
    public void testAllcoateRequestWithoutIncrease() {
        AllocateRequest r = AllocateRequest.newInstance((int)123, (float)0.0f, null, null, null, null);
        YarnServiceProtos.AllocateRequestProto p = ((AllocateRequestPBImpl)r).getProto();
        r = new AllocateRequestPBImpl(p);
        Assert.assertEquals((long)123L, (long)r.getResponseId());
        Assert.assertEquals((long)0L, (long)r.getIncreaseRequests().size());
    }
}

