/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestLeaseManager {
    @Rule
    public Timeout timeout = new Timeout(300000);
    public static long maxLockHoldToReleaseLeaseMs = 100L;

    @Test
    public void testRemoveLeases() throws Exception {
        long id;
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        LeaseManager lm = new LeaseManager(fsn);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{16386L, 16387L, 16388L, 16389L});
        Iterator i$ = ids.iterator();
        while (i$.hasNext()) {
            id = (Long)i$.next();
            lm.addLease("foo", id);
        }
        Assert.assertEquals((long)4L, (long)lm.getINodeIdWithLeases().size());
        i$ = ids.iterator();
        while (i$.hasNext()) {
            id = (Long)i$.next();
            lm.removeLease(id);
        }
        Assert.assertEquals((long)0L, (long)lm.getINodeIdWithLeases().size());
    }

    @Test
    public void testCheckLease() {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        long numLease = 100L;
        lm.setLeasePeriod(0L, 0L);
        for (long i = 0L; i <= numLease - 1L; ++i) {
            lm.addLease("holder" + i, 16385L + i);
        }
        Assert.assertEquals((long)numLease, (long)lm.countLease());
        lm.checkLeases();
        Assert.assertTrue(((long)lm.countLease() < numLease ? 1 : 0) != 0);
    }

    @Test
    public void testInternalLeaseHolder() throws Exception {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.setLeasePeriod(100L, 500L);
        String holder = lm.getInternalLeaseHolder();
        Thread.sleep(1000L);
        Assert.assertNotEquals((Object)holder, (Object)lm.getInternalLeaseHolder());
    }

    @Test
    public void testCountPath() {
        LeaseManager lm = new LeaseManager(TestLeaseManager.makeMockFsNameSystem());
        lm.addLease("holder1", 1L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)1L));
        lm.addLease("holder2", 2L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.addLease("holder2", 2L);
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(3L));
        lm.removeLease("InvalidLeaseHolder", TestLeaseManager.stubInodeFile(1L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        INodeFile file = TestLeaseManager.stubInodeFile(1L);
        lm.reassignLease(lm.getLease(file), file, "holder2");
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)2L));
        lm.removeLease("holder2", TestLeaseManager.stubInodeFile(2L));
        Assert.assertThat((Object)lm.countPath(), (Matcher)CoreMatchers.is((Object)1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseRestorationOnRestart() throws Exception {
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            String path = "/testLeaseRestorationOnRestart";
            FSDataOutputStream out = dfs.create(new Path(path));
            FSDirectory dir = cluster.getNamesystem().getFSDirectory();
            INodeFile file = dir.getINode(path).asFile();
            cluster.getNamesystem().leaseManager.removeLease(file.getFileUnderConstructionFeature().getClientName(), file);
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            cluster.getNameNodeRpc().saveNamespace();
            dfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
            cluster.restartNameNode(true);
            dir = cluster.getNamesystem().getFSDirectory();
            file = dir.getINode(path).asFile();
            Assert.assertTrue((String)"Lease should exist.", (cluster.getNamesystem().leaseManager.getLease(file) != null ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static FSNamesystem makeMockFsNameSystem() {
        FSDirectory dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)fsn.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)fsn.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)fsn.getFSDirectory()).thenReturn((Object)dir);
        Mockito.when((Object)fsn.getMaxLockHoldToReleaseLeaseMs()).thenReturn((Object)maxLockHoldToReleaseLeaseMs);
        return fsn;
    }

    private static INodeFile stubInodeFile(long inodeId) {
        PermissionStatus p = new PermissionStatus("dummy", "dummy", new FsPermission(511));
        return new INodeFile(inodeId, "/foo".getBytes(), p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 1, 1L);
    }
}

