/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestRollingUpgrade;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodeRollingUpgrade {
    private static final Log LOG = LogFactory.getLog(TestDataNodeRollingUpgrade.class);
    private static final short REPL_FACTOR = 1;
    private static final int BLOCK_SIZE = 0x100000;
    private static final long FILE_SIZE = 0x100000L;
    private static final long SEED = 464384013L;
    Configuration conf;
    MiniDFSCluster cluster = null;
    DistributedFileSystem fs = null;
    DataNode dn = null;
    NameNode nn = null;
    String blockPoolId = null;

    private void startCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        this.nn = this.cluster.getNameNode(0);
        Assert.assertNotNull((Object)this.nn);
        this.dn = this.cluster.getDataNodes().get(0);
        Assert.assertNotNull((Object)this.dn);
        this.blockPoolId = this.cluster.getNameNode(0).getNamesystem().getBlockPoolId();
    }

    private void shutdownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        this.fs = null;
        this.nn = null;
        this.dn = null;
        this.blockPoolId = null;
    }

    private void triggerHeartBeats() throws Exception {
        this.cluster.triggerHeartbeats();
        Thread.sleep(5000L);
    }

    private File getBlockForFile(Path path, boolean exists) throws IOException {
        LocatedBlocks blocks = this.nn.getRpcServer().getBlockLocations(path.toString(), 0L, Long.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)blocks.getLocatedBlocks().size());
        ExtendedBlock block = ((LocatedBlock)blocks.getLocatedBlocks().get(0)).getBlock();
        BlockLocalPathInfo bInfo = this.dn.getFSDataset().getBlockLocalPathInfo(block);
        File blockFile = new File(bInfo.getBlockPath());
        Assert.assertEquals((Object)exists, (Object)blockFile.exists());
        return blockFile;
    }

    private File getTrashFileForBlock(File blockFile, boolean exists) {
        File trashFile = new File(this.dn.getStorage().getTrashDirectoryForBlockFile(this.blockPoolId, blockFile));
        Assert.assertEquals((Object)exists, (Object)trashFile.exists());
        return trashFile;
    }

    private void deleteAndEnsureInTrash(Path pathToDelete, File blockFile, File trashFile) throws Exception {
        Assert.assertTrue((boolean)blockFile.exists());
        Assert.assertFalse((boolean)trashFile.exists());
        LOG.info((Object)("Deleting file " + pathToDelete + " during rolling upgrade"));
        this.fs.delete(pathToDelete, false);
        assert (!this.fs.exists(pathToDelete));
        this.triggerHeartBeats();
        Assert.assertTrue((boolean)trashFile.exists());
        Assert.assertFalse((boolean)blockFile.exists());
    }

    private void ensureTrashDisabled() {
        Assert.assertFalse((boolean)this.dn.getFSDataset().trashEnabled(this.blockPoolId));
        BlockPoolSliceStorage bps = this.dn.getStorage().getBPStorage(this.blockPoolId);
        Assert.assertFalse((boolean)bps.trashEnabled());
    }

    private void ensureTrashRestored(File blockFile, File trashFile) throws Exception {
        Assert.assertTrue((boolean)blockFile.exists());
        Assert.assertFalse((boolean)trashFile.exists());
        this.ensureTrashDisabled();
    }

    private void startRollingUpgrade() throws Exception {
        LOG.info((Object)"Starting rolling upgrade");
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "prepare");
        this.triggerHeartBeats();
        Assert.assertTrue((boolean)this.dn.getFSDataset().trashEnabled(this.blockPoolId));
    }

    private void finalizeRollingUpgrade() throws Exception {
        LOG.info((Object)"Finalizing rolling upgrade");
        DFSAdmin dfsadmin = new DFSAdmin(this.conf);
        TestRollingUpgrade.runCmd(dfsadmin, true, "-rollingUpgrade", "finalize");
        this.triggerHeartBeats();
        Assert.assertFalse((boolean)this.dn.getFSDataset().trashEnabled(this.blockPoolId));
        BlockPoolSliceStorage bps = this.dn.getStorage().getBPStorage(this.blockPoolId);
        Assert.assertFalse((boolean)bps.trashEnabled());
    }

    private void rollbackRollingUpgrade() throws Exception {
        LOG.info((Object)"Starting rollback of the rolling upgrade");
        MiniDFSCluster.DataNodeProperties dnprop = this.cluster.stopDataNode(0);
        this.cluster.shutdownNameNodes();
        this.cluster.restartNameNode("-rollingupgrade", "rollback");
        this.cluster.restartDataNode(dnprop);
        this.cluster.waitActive();
        this.nn = this.cluster.getNameNode(0);
        this.dn = this.cluster.getDataNodes().get(0);
        this.triggerHeartBeats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDatanodeRollingUpgradeWithFinalize() throws Exception {
        try {
            this.startCluster();
            Path testFile1 = new Path("/TestDataNodeRollingUpgrade1.dat");
            Path testFile2 = new Path("/TestDataNodeRollingUpgrade2.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
            DFSTestUtil.createFile((FileSystem)this.fs, testFile2, 0x100000L, (short)1, 464384013L);
            this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            this.startRollingUpgrade();
            File blockFile = this.getBlockForFile(testFile2, true);
            File trashFile = this.getTrashFileForBlock(blockFile, false);
            this.deleteAndEnsureInTrash(testFile2, blockFile, trashFile);
            this.finalizeRollingUpgrade();
            this.ensureTrashDisabled();
            assert (!this.fs.exists(testFile2));
            assert (this.fs.exists(testFile1));
        }
        finally {
            this.shutdownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testDatanodeRollingUpgradeWithRollback() throws Exception {
        try {
            this.startCluster();
            Path testFile1 = new Path("/TestDataNodeRollingUpgrade1.dat");
            DFSTestUtil.createFile((FileSystem)this.fs, testFile1, 0x100000L, (short)1, 464384013L);
            String fileContents1 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            this.fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            this.startRollingUpgrade();
            File blockFile = this.getBlockForFile(testFile1, true);
            File trashFile = this.getTrashFileForBlock(blockFile, false);
            this.deleteAndEnsureInTrash(testFile1, blockFile, trashFile);
            this.rollbackRollingUpgrade();
            this.ensureTrashRestored(blockFile, trashFile);
            assert (this.fs.exists(testFile1));
            String fileContents2 = DFSTestUtil.readFile((FileSystem)this.fs, testFile1);
            Assert.assertThat((Object)fileContents1, (Matcher)Is.is((Object)fileContents2));
        }
        finally {
            this.shutdownCluster();
        }
    }
}

