/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;

public class MiniQJMHACluster {
    private MiniDFSCluster cluster;
    private MiniJournalCluster journalCluster;
    private final Configuration conf;
    public static final String NAMESERVICE = "ns1";
    private static final String NN1 = "nn1";
    private static final String NN2 = "nn2";
    private static final int NN1_IPC_PORT = 10000;
    private static final int NN1_INFO_PORT = 10001;
    private static final int NN2_IPC_PORT = 10002;
    private static final int NN2_INFO_PORT = 10003;

    public static MiniDFSNNTopology createDefaultTopology() {
        return new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf(NAMESERVICE).addNN(new MiniDFSNNTopology.NNConf(NN1).setIpcPort(10000).setHttpPort(10001)).addNN(new MiniDFSNNTopology.NNConf(NN2).setIpcPort(10002).setHttpPort(10003)));
    }

    private MiniQJMHACluster(Builder builder) throws IOException {
        this.conf = builder.conf;
        this.journalCluster = new MiniJournalCluster.Builder(this.conf).format(true).build();
        URI journalURI = this.journalCluster.getQuorumJournalURI(NAMESERVICE);
        MiniDFSNNTopology topology = MiniQJMHACluster.createDefaultTopology();
        this.initHAConf(journalURI, builder.conf);
        this.cluster = builder.dfsBuilder.nnTopology(topology).manageNameDfsSharedDirs(false).build();
        this.cluster.waitActive();
        this.cluster.shutdown();
        Configuration confNN0 = this.cluster.getConfiguration(0);
        NameNode.initializeSharedEdits((Configuration)confNN0, (boolean)true);
        this.cluster.getNameNodeInfos()[0].setStartOpt(builder.startOpt);
        this.cluster.getNameNodeInfos()[1].setStartOpt(builder.startOpt);
        this.cluster.restartNameNodes();
    }

    private Configuration initHAConf(URI journalURI, Configuration conf) {
        conf.set("dfs.namenode.shared.edits.dir", journalURI.toString());
        String address1 = "127.0.0.1:10000";
        String address2 = "127.0.0.1:10002";
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NAMESERVICE, NN1}), address1);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{NAMESERVICE, NN2}), address2);
        conf.set("dfs.nameservices", NAMESERVICE);
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{NAMESERVICE}), "nn1,nn2");
        conf.set("dfs.client.failover.proxy.provider.ns1", ConfiguredFailoverProxyProvider.class.getName());
        conf.set("fs.defaultFS", "hdfs://ns1");
        return conf;
    }

    public MiniDFSCluster getDfsCluster() {
        return this.cluster;
    }

    public MiniJournalCluster getJournalCluster() {
        return this.journalCluster;
    }

    public void shutdown() throws IOException {
        this.cluster.shutdown();
        this.journalCluster.shutdown();
    }

    public static class Builder {
        private final Configuration conf;
        private HdfsServerConstants.StartupOption startOpt = null;
        private final MiniDFSCluster.Builder dfsBuilder;

        public Builder(Configuration conf) {
            this.conf = conf;
            this.dfsBuilder = new MiniDFSCluster.Builder(conf);
        }

        public MiniDFSCluster.Builder getDfsBuilder() {
            return this.dfsBuilder;
        }

        public MiniQJMHACluster build() throws IOException {
            return new MiniQJMHACluster(this);
        }

        public void startupOption(HdfsServerConstants.StartupOption startOpt) {
            this.startOpt = startOpt;
        }
    }
}

