/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientReportBadBlock {
    private static final Log LOG = LogFactory.getLog(TestClientReportBadBlock.class);
    static final long BLOCK_SIZE = 65536L;
    private static int buffersize;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static final int numDataNodes = 3;
    private static final Configuration conf;
    Random rand = new Random();

    @Before
    public void startUpCluster() throws IOException {
        conf.setInt("dfs.datanode.scan.period.hours", -1);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        buffersize = conf.getInt("io.file.buffer.size", 4096);
    }

    @After
    public void shutDownCluster() throws IOException {
        dfs.close();
        cluster.shutdown();
    }

    @Test
    public void testOneBlockReplica() throws Exception {
        boolean repl = true;
        boolean corruptBlockNumber = true;
        for (int i = 0; i < 2; ++i) {
            String fileName = "/tmp/testClientReportBadBlock/OneBlockReplica" + i;
            Path filePath = new Path(fileName);
            this.createAFileWithCorruptedBlockReplicas(filePath, (short)1, 1);
            if (i == 0) {
                this.dfsClientReadFile(filePath);
            } else {
                this.dfsClientReadFileFromPosition(filePath);
            }
            int expectedReplicaCount = 1;
            this.verifyCorruptedBlockCount(filePath, expectedReplicaCount);
            this.verifyFirstBlockCorrupted(filePath, true);
            TestClientReportBadBlock.verifyFsckBlockCorrupted();
            TestClientReportBadBlock.testFsckListCorruptFilesBlocks(filePath, -1);
        }
    }

    @Test
    public void testCorruptAllOfThreeReplicas() throws Exception {
        int repl = 3;
        int corruptBlockNumber = 3;
        for (int i = 0; i < 2; ++i) {
            String fileName = "/tmp/testClientReportBadBlock/testCorruptAllReplicas" + i;
            Path filePath = new Path(fileName);
            this.createAFileWithCorruptedBlockReplicas(filePath, (short)3, 3);
            if (i == 0) {
                this.dfsClientReadFile(filePath);
            } else {
                this.dfsClientReadFileFromPosition(filePath);
            }
            int expectedReplicasReturned = 3;
            this.verifyCorruptedBlockCount(filePath, expectedReplicasReturned);
            this.verifyFirstBlockCorrupted(filePath, false);
            TestClientReportBadBlock.verifyFsckHealth("");
            TestClientReportBadBlock.testFsckListCorruptFilesBlocks(filePath, 0);
        }
    }

    @Test
    public void testCorruptTwoOutOfThreeReplicas() throws Exception {
        int repl = 3;
        int corruptBlocReplicas = 2;
        for (int i = 0; i < 2; ++i) {
            String fileName = "/tmp/testClientReportBadBlock/CorruptTwoOutOfThreeReplicas" + i;
            Path filePath = new Path(fileName);
            this.createAFileWithCorruptedBlockReplicas(filePath, (short)3, 2);
            int replicaCount = 0;
            while (replicaCount != 1) {
                if (i == 0) {
                    this.dfsClientReadFile(filePath);
                } else {
                    this.dfsClientReadFileFromPosition(filePath);
                }
                LocatedBlocks blocks = TestClientReportBadBlock.dfs.dfs.getNamenode().getBlockLocations(filePath.toString(), 0L, Long.MAX_VALUE);
                replicaCount = blocks.get(0).getLocations().length;
            }
            this.verifyFirstBlockCorrupted(filePath, false);
            int expectedReplicaCount = 1;
            this.verifyCorruptedBlockCount(filePath, expectedReplicaCount);
            TestClientReportBadBlock.verifyFsckHealth("Target Replicas is 3 but found 1 replica");
            TestClientReportBadBlock.testFsckListCorruptFilesBlocks(filePath, 0);
        }
    }

    private void createAFileWithCorruptedBlockReplicas(Path filePath, short repl, int corruptBlockCount) throws IOException, AccessControlException, FileNotFoundException, UnresolvedLinkException, InterruptedException, TimeoutException {
        DFSTestUtil.createFile((FileSystem)dfs, filePath, 65536L, repl, 0L);
        DFSTestUtil.waitReplication((FileSystem)dfs, filePath, repl);
        LocatedBlocks locatedblocks = TestClientReportBadBlock.dfs.dfs.getNamenode().getBlockLocations(filePath.toString(), 0L, 65536L);
        Assert.assertEquals((long)repl, (long)locatedblocks.get(0).getLocations().length);
        LocatedBlock lblock = locatedblocks.get(0);
        DatanodeInfo[] datanodeinfos = lblock.getLocations();
        ExtendedBlock block = lblock.getBlock();
        for (int i = 0; i < corruptBlockCount; ++i) {
            DatanodeInfo dninfo = datanodeinfos[i];
            DataNode dn = cluster.getDataNode(dninfo.getIpcPort());
            TestClientReportBadBlock.corruptBlock(block, dn);
            LOG.debug((Object)("Corrupted block " + block.getBlockName() + " on data node " + dninfo));
        }
    }

    private void verifyFirstBlockCorrupted(Path filePath, boolean isCorrupted) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks locatedBlocks = TestClientReportBadBlock.dfs.dfs.getNamenode().getBlockLocations(filePath.toUri().getPath(), 0L, Long.MAX_VALUE);
        LocatedBlock firstLocatedBlock = locatedBlocks.get(0);
        Assert.assertEquals((Object)isCorrupted, (Object)firstLocatedBlock.isCorrupt());
    }

    private void verifyCorruptedBlockCount(Path filePath, int expectedReplicas) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        LocatedBlocks lBlocks = TestClientReportBadBlock.dfs.dfs.getNamenode().getBlockLocations(filePath.toUri().getPath(), 0L, Long.MAX_VALUE);
        LocatedBlock firstLocatedBlock = lBlocks.get(0);
        Assert.assertEquals((long)expectedReplicas, (long)firstLocatedBlock.getLocations().length);
    }

    private void dfsClientReadFile(Path corruptedFile) throws IOException, UnresolvedLinkException {
        DFSInputStream in = TestClientReportBadBlock.dfs.dfs.open(corruptedFile.toUri().getPath());
        byte[] buf = new byte[buffersize];
        int nRead = 0;
        try {
            while ((nRead = in.read(buf, 0, buf.length)) > 0) {
            }
        }
        catch (ChecksumException ce) {
            LOG.debug((Object)"DfsClientReadFile caught ChecksumException.");
        }
        catch (BlockMissingException bme) {
            LOG.debug((Object)"DfsClientReadFile caught BlockMissingException.");
        }
    }

    private void dfsClientReadFileFromPosition(Path corruptedFile) throws UnresolvedLinkException, IOException {
        DFSInputStream in = TestClientReportBadBlock.dfs.dfs.open(corruptedFile.toUri().getPath());
        byte[] buf = new byte[buffersize];
        int startPosition = 2;
        int nRead = 0;
        try {
            do {
                nRead = in.read((long)startPosition, buf, 0, buf.length);
                startPosition += buf.length;
            } while (nRead > 0);
        }
        catch (BlockMissingException bme) {
            LOG.debug((Object)"DfsClientReadFile caught BlockMissingException.");
        }
    }

    private static void corruptBlock(ExtendedBlock block, DataNode dn) throws FileNotFoundException, IOException {
        File f = DataNodeTestUtils.getBlockFile(dn, block.getBlockPoolId(), block.getLocalBlock());
        RandomAccessFile raFile = new RandomAccessFile(f, "rw");
        byte[] bytes = new byte[65536];
        int i = 0;
        while ((long)i < 65536L) {
            bytes[i] = (byte)i;
            ++i;
        }
        raFile.write(bytes);
        raFile.close();
    }

    private static void verifyFsckHealth(String expected) throws Exception {
        String outStr = TestClientReportBadBlock.runFsck(conf, 0, true, "/");
        LOG.info((Object)outStr);
        Assert.assertTrue((boolean)outStr.contains("is HEALTHY"));
        if (!expected.equals("")) {
            Assert.assertTrue((boolean)outStr.contains(expected));
        }
    }

    private static void verifyFsckBlockCorrupted() throws Exception {
        String outStr = TestClientReportBadBlock.runFsck(conf, 1, true, "/");
        LOG.info((Object)outStr);
        Assert.assertTrue((boolean)outStr.contains("is CORRUPT"));
    }

    private static void testFsckListCorruptFilesBlocks(Path filePath, int errorCode) throws Exception {
        String outStr = TestClientReportBadBlock.runFsck(conf, errorCode, true, filePath.toString(), "-list-corruptfileblocks");
        LOG.info((Object)("fsck -list-corruptfileblocks out: " + outStr));
        if (errorCode != 0) {
            Assert.assertTrue((boolean)outStr.contains("CORRUPT files"));
        }
    }

    static String runFsck(Configuration conf, int expectedErrCode, boolean checkErrorCode, String ... path) throws Exception {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bStream, true);
        int errCode = ToolRunner.run((Tool)new DFSck(conf, out), (String[])path);
        if (checkErrorCode) {
            Assert.assertEquals((long)expectedErrCode, (long)errCode);
        }
        return bStream.toString();
    }

    static {
        conf = new HdfsConfiguration();
    }
}

