/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.TestMapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.mockito.Mockito;

public class TestBloomMapFile
extends TestCase {
    private static Configuration conf = new Configuration();
    private static final Path TEST_ROOT = new Path(System.getProperty("test.build.data", "/tmp"), TestMapFile.class.getSimpleName());
    private static final Path TEST_DIR = new Path(TEST_ROOT, "testfile");
    private static final Path TEST_FILE = new Path(TEST_ROOT, "testfile");
    static final Progressable defaultProgress = new Progressable(){

        public void progress() {
        }
    };
    static final CompressionCodec defaultCodec = new CompressionCodec(){

        public String getDefaultExtension() {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return null;
        }

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }
    };

    public void setUp() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(TEST_ROOT) && !fs.delete(TEST_ROOT, true)) {
            Assert.fail((String)"Can't clean up test root dir");
        }
        fs.mkdirs(TEST_ROOT);
    }

    public void testMembershipTest() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(TEST_DIR);
        conf.setInt("io.mapfile.bloom.size", 2048);
        BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, Text.class);
        IntWritable key = new IntWritable();
        Text value = new Text();
        for (int i = 0; i < 2000; i += 2) {
            key.set(i);
            value.set("00" + i);
            writer.append((WritableComparable)key, (Writable)value);
        }
        writer.close();
        BloomMapFile.Reader reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            key.set(i);
            boolean exists = reader.probablyHasKey((WritableComparable)key);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close();
        fs.delete(qualifiedDirName, true);
        System.out.println("False negatives: " + falseNeg);
        TestBloomMapFile.assertEquals((int)0, (int)falseNeg);
        System.out.println("False positives: " + falsePos);
        TestBloomMapFile.assertTrue((falsePos < 2 ? 1 : 0) != 0);
    }

    private void checkMembershipVaryingSizedKeys(String name, List<Text> keys) throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(TEST_DIR);
        BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, NullWritable.class);
        for (Text key : keys) {
            writer.append((WritableComparable)key, (Writable)NullWritable.get());
        }
        writer.close();
        BloomMapFile.Reader reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        Collections.reverse(keys);
        for (Text key : keys) {
            TestBloomMapFile.assertTrue((String)("False negative for existing key " + key), (boolean)reader.probablyHasKey((WritableComparable)key));
        }
        reader.close();
        fs.delete(qualifiedDirName, true);
    }

    public void testMembershipVaryingSizedKeysTest1() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("A"));
        list.add(new Text("BB"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }

    public void testMembershipVaryingSizedKeysTest2() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("AA"));
        list.add(new Text("B"));
        this.checkMembershipVaryingSizedKeys(this.getName(), list);
    }

    public void testDeleteFile() {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            TestBloomMapFile.assertNotNull((String)"testDeleteFile error !!!", (Object)writer);
            BloomMapFile.delete((FileSystem)fs, (String)("." + TEST_FILE));
        }
        catch (Exception ex) {
            TestBloomMapFile.fail((String)"unexpect ex in testDeleteFile !!!");
        }
    }

    public void testIOExceptionInWriterConstructor() {
        Path dirNameSpy = (Path)Mockito.spy((Object)TEST_FILE);
        try {
            BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("123124142"));
            writer.close();
            Mockito.when((Object)dirNameSpy.getFileSystem(conf)).thenThrow(new Throwable[]{new IOException()});
            BloomMapFile.Reader reader = new BloomMapFile.Reader(dirNameSpy, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(IntWritable.class))});
            TestBloomMapFile.assertNull((String)"testIOExceptionInWriterConstructor error !!!", (Object)reader.getBloomFilter());
            reader.close();
        }
        catch (Exception ex) {
            TestBloomMapFile.fail((String)"unexpect ex in testIOExceptionInWriterConstructor !!!");
        }
    }

    public void testGetBloomMapFile() {
        int SIZE = 10;
        try {
            BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text());
            }
            writer.close();
            BloomMapFile.Reader reader = new BloomMapFile.Reader(TEST_FILE, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(IntWritable.class))});
            for (int i = 0; i < SIZE; ++i) {
                TestBloomMapFile.assertNotNull((String)"testGetBloomMapFile error !!!", (Object)reader.get((WritableComparable)new IntWritable(i), (Writable)new Text()));
            }
            TestBloomMapFile.assertNull((String)"testGetBloomMapFile error !!!", (Object)reader.get((WritableComparable)new IntWritable(SIZE + 5), (Writable)new Text()));
            reader.close();
        }
        catch (Exception ex) {
            TestBloomMapFile.fail((String)"unexpect ex in testGetBloomMapFile !!!");
        }
    }

    public void testBloomMapFileConstructors() {
        try {
            FileSystem ts = FileSystem.get((Configuration)conf);
            String testFileName = TEST_FILE.toString();
            BloomMapFile.Writer writer1 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultCodec, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer1);
            BloomMapFile.Writer writer2 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer2);
            BloomMapFile.Writer writer3 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer3);
            BloomMapFile.Writer writer4 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultCodec, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer4);
            BloomMapFile.Writer writer5 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultProgress);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer5);
            BloomMapFile.Writer writer6 = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer6);
            BloomMapFile.Writer writer7 = new BloomMapFile.Writer(conf, ts, testFileName, WritableComparator.get(Text.class), Text.class);
            TestBloomMapFile.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer7);
        }
        catch (Exception ex) {
            TestBloomMapFile.fail((String)"testBloomMapFileConstructors error !!!");
        }
    }
}

