/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.util.StringUtils;
import org.junit.Before;
import org.junit.Test;

public class TestArrayPrimitiveWritable
extends TestCase {
    static final boolean[] b = new boolean[]{true, true, false};
    static final char[] c = new char[]{'a', 'b', 'c'};
    static final byte[] by = new byte[]{1, 2, 3};
    static final short[] sh = new short[]{1, 2, 3};
    static final int[] i = new int[]{1, 2, 3};
    static final long[] lo = new long[]{1L, 2L, 3L};
    static final float[] f = new float[]{1.0f, 2.5f, 3.3f};
    static final double[] d = new double[]{1.0, 2.5, 3.3};
    static final Object[] bigSet = new Object[]{b, c, by, sh, i, lo, f, d};
    static final Object[] expectedResultSet = new Object[]{b, b, c, c, by, by, sh, sh, i, i, lo, lo, f, f, d, d};
    final Object[] resultSet = new Object[bigSet.length * 2];
    final DataOutputBuffer out = new DataOutputBuffer();
    final DataInputBuffer in = new DataInputBuffer();

    @Before
    public void resetBuffers() throws IOException {
        this.out.reset();
        this.in.reset();
    }

    @Test
    public void testMany() throws IOException {
        for (Object x : bigSet) {
            ObjectWritable.writeObject((DataOutput)this.out, (Object)x, x.getClass(), null, (boolean)true);
            new ArrayPrimitiveWritable(x).write((DataOutput)this.out);
        }
        this.in.reset(this.out.getData(), this.out.getLength());
        int x = 0;
        while (x < this.resultSet.length) {
            this.resultSet[x++] = ObjectWritable.readObject((DataInput)this.in, null);
            ArrayPrimitiveWritable apw = new ArrayPrimitiveWritable();
            apw.readFields((DataInput)this.in);
            this.resultSet[x++] = apw.get();
        }
        TestArrayPrimitiveWritable.assertEquals((int)expectedResultSet.length, (int)this.resultSet.length);
        for (x = 0; x < this.resultSet.length; ++x) {
            TestArrayPrimitiveWritable.assertEquals((String)("ComponentType of array " + x), expectedResultSet[x].getClass().getComponentType(), this.resultSet[x].getClass().getComponentType());
        }
        TestArrayPrimitiveWritable.assertTrue((String)"In and Out arrays didn't match values", (boolean)Arrays.deepEquals(expectedResultSet, this.resultSet));
    }

    @Test
    public void testObjectLabeling() throws IOException {
        ObjectWritable.writeObject((DataOutput)this.out, (Object)i, i.getClass(), null, (boolean)true);
        ArrayPrimitiveWritable apw = new ArrayPrimitiveWritable((Object)i);
        ObjectWritable.writeObject((DataOutput)this.out, (Object)apw, apw.getClass(), null, (boolean)true);
        this.in.reset(this.out.getData(), this.out.getLength());
        String className = UTF8.readString((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The int[] written by ObjectWritable was not labelled as an ArrayPrimitiveWritable.Internal", (String)ArrayPrimitiveWritable.Internal.class.getName(), (String)className);
        ArrayPrimitiveWritable.Internal apwi = new ArrayPrimitiveWritable.Internal();
        apwi.readFields((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The ArrayPrimitiveWritable.Internal component type was corrupted", Integer.TYPE, (Object)apw.getComponentType());
        TestArrayPrimitiveWritable.assertTrue((String)"The int[] written by ObjectWritable as ArrayPrimitiveWritable.Internal was corrupted", (boolean)Arrays.equals(i, (int[])apwi.get()));
        String declaredClassName = UTF8.readString((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The APW written by ObjectWritable was not labelled as declaredClass ArrayPrimitiveWritable", (String)ArrayPrimitiveWritable.class.getName(), (String)declaredClassName);
        className = UTF8.readString((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The APW written by ObjectWritable was not labelled as class ArrayPrimitiveWritable", (String)ArrayPrimitiveWritable.class.getName(), (String)className);
        ArrayPrimitiveWritable apw2 = new ArrayPrimitiveWritable();
        apw2.readFields((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The ArrayPrimitiveWritable component type was corrupted", Integer.TYPE, (Object)apw2.getComponentType());
        TestArrayPrimitiveWritable.assertTrue((String)"The int[] written by ObjectWritable as ArrayPrimitiveWritable was corrupted", (boolean)Arrays.equals(i, (int[])apw2.get()));
    }

    @Test
    public void testOldFormat() throws IOException {
        ObjectWritable.writeObject((DataOutput)this.out, (Object)i, i.getClass(), null);
        this.in.reset(this.out.getData(), this.out.getLength());
        String className = UTF8.readString((DataInput)this.in);
        TestArrayPrimitiveWritable.assertEquals((String)"The int[] written by ObjectWritable as a non-compact array was not labelled as an array of int", (String)i.getClass().getName(), (String)className);
        int length = this.in.readInt();
        TestArrayPrimitiveWritable.assertEquals((String)"The int[] written by ObjectWritable as a non-compact array was not expected length", (int)i.length, (int)length);
        int[] readValue = new int[length];
        try {
            for (int i = 0; i < length; ++i) {
                readValue[i] = (Integer)ObjectWritable.readObject((DataInput)this.in, null);
            }
        }
        catch (Exception e) {
            TestArrayPrimitiveWritable.fail((String)("The int[] written by ObjectWritable as a non-compact array was corrupted.  Failed to correctly read int[] of length " + length + ". Got exception:\n" + StringUtils.stringifyException((Throwable)e)));
        }
        TestArrayPrimitiveWritable.assertTrue((String)"The int[] written by ObjectWritable as a non-compact array was corrupted.", (boolean)Arrays.equals(i, readValue));
    }
}

