/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.CountingBloomFilter;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.bloom.RetouchedBloomFilter;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class BloomFilterCommonTester<T extends Filter> {
    private static final double LN2 = Math.log(2.0);
    private static final double LN2_SQUARED = LN2 * LN2;
    private final int hashType;
    private final int numInsertions;
    private final ImmutableList.Builder<T> builder = ImmutableList.builder();
    private ImmutableSet<BloomFilterTestStrategy> filterTestStrateges;
    private final PreAssertionHelper preAssertionHelper;

    static int optimalNumOfBits(int n, double p) {
        return (int)((double)(-n) * Math.log(p) / LN2_SQUARED);
    }

    public static <T extends Filter> BloomFilterCommonTester<T> of(int hashId, int numInsertions) {
        return new BloomFilterCommonTester<T>(hashId, numInsertions);
    }

    public BloomFilterCommonTester<T> withFilterInstance(T filter) {
        this.builder.add(filter);
        return this;
    }

    private BloomFilterCommonTester(int hashId, int numInsertions) {
        this.hashType = hashId;
        this.numInsertions = numInsertions;
        this.preAssertionHelper = new PreAssertionHelper(){

            @Override
            public ImmutableSet<Integer> falsePositives(int hashId) {
                switch (hashId) {
                    case 0: {
                        return ImmutableSet.of((Object)99, (Object)963);
                    }
                    case 1: {
                        return ImmutableSet.of((Object)769, (Object)772, (Object)810, (Object)874);
                    }
                }
                Assert.assertFalse((String)"unknown hash error", (boolean)true);
                return ImmutableSet.of();
            }
        };
    }

    public BloomFilterCommonTester<T> withTestCases(ImmutableSet<BloomFilterTestStrategy> filterTestStrateges) {
        this.filterTestStrateges = ImmutableSet.copyOf(filterTestStrateges);
        return this;
    }

    public void test() {
        ImmutableList filtersList = this.builder.build();
        ImmutableSet<Integer> falsePositives = this.preAssertionHelper.falsePositives(this.hashType);
        for (Filter filter : filtersList) {
            for (BloomFilterTestStrategy strategy : this.filterTestStrateges) {
                strategy.getStrategy().assertWhat(filter, this.numInsertions, this.hashType, falsePositives);
                filter = BloomFilterCommonTester.getSymmetricFilter(filter.getClass(), this.numInsertions, this.hashType);
            }
        }
    }

    private static Filter getSymmetricFilter(Class<?> filterClass, int numInsertions, int hashType) {
        int bitSetSize = BloomFilterCommonTester.optimalNumOfBits(numInsertions, 0.03);
        int hashFunctionNumber = 5;
        if (filterClass == BloomFilter.class) {
            return new BloomFilter(bitSetSize, hashFunctionNumber, hashType);
        }
        if (filterClass == CountingBloomFilter.class) {
            return new CountingBloomFilter(bitSetSize, hashFunctionNumber, hashType);
        }
        if (filterClass == RetouchedBloomFilter.class) {
            return new RetouchedBloomFilter(bitSetSize, hashFunctionNumber, hashType);
        }
        if (filterClass == DynamicBloomFilter.class) {
            return new DynamicBloomFilter(bitSetSize, hashFunctionNumber, hashType, 3);
        }
        Assert.assertFalse((String)"unexpected filterClass", (boolean)true);
        return null;
    }

    static interface PreAssertionHelper {
        public ImmutableSet<Integer> falsePositives(int var1);
    }

    public static enum BloomFilterTestStrategy {
        ADD_KEYS_STRATEGY(new FilterTesterStrategy(){
            private final ImmutableList<Key> keys = ImmutableList.of((Object)new Key(new byte[]{49, 48, 48}), (Object)new Key(new byte[]{50, 48, 48}));

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                filter.add(this.keys);
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("100".getBytes())));
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("200".getBytes())));
                filter.add((Key[])this.keys.toArray((Object[])new Key[0]));
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("100".getBytes())));
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("200".getBytes())));
                filter.add((Collection)new AbstractCollection<Key>(){

                    @Override
                    public Iterator<Key> iterator() {
                        return keys.iterator();
                    }

                    @Override
                    public int size() {
                        return keys.size();
                    }
                });
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("100".getBytes())));
                Assert.assertTrue((String)" might contain key error ", (boolean)filter.membershipTest(new Key("200".getBytes())));
            }
        }),
        KEY_TEST_STRATEGY(new FilterTesterStrategy(){

            private void checkOnKeyMethods() {
                String line = "werabsdbe";
                Key key = new Key(line.getBytes());
                Assert.assertTrue((String)"default key weight error ", (key.getWeight() == 1.0 ? 1 : 0) != 0);
                key.set(line.getBytes(), 2.0);
                Assert.assertTrue((String)" setted key weight error ", (key.getWeight() == 2.0 ? 1 : 0) != 0);
                Key sKey = new Key(line.getBytes(), 2.0);
                Assert.assertTrue((String)"equals error", (boolean)key.equals((Object)sKey));
                Assert.assertTrue((String)"hashcode error", (key.hashCode() == sKey.hashCode() ? 1 : 0) != 0);
                sKey = new Key(line.concat("a").getBytes(), 2.0);
                Assert.assertFalse((String)"equals error", (boolean)key.equals((Object)sKey));
                Assert.assertFalse((String)"hashcode error", (key.hashCode() == sKey.hashCode() ? 1 : 0) != 0);
                sKey = new Key(line.getBytes(), 3.0);
                Assert.assertFalse((String)"equals error", (boolean)key.equals((Object)sKey));
                Assert.assertFalse((String)"hashcode error", (key.hashCode() == sKey.hashCode() ? 1 : 0) != 0);
                key.incrementWeight();
                Assert.assertTrue((String)"weight error", (key.getWeight() == 3.0 ? 1 : 0) != 0);
                key.incrementWeight(2.0);
                Assert.assertTrue((String)"weight error", (key.getWeight() == 5.0 ? 1 : 0) != 0);
            }

            private void checkOnReadWrite() {
                String line = "qryqeb354645rghdfvbaq23312fg";
                DataOutputBuffer out = new DataOutputBuffer();
                DataInputBuffer in = new DataInputBuffer();
                Key originKey = new Key(line.getBytes(), 100.0);
                try {
                    originKey.write((DataOutput)out);
                    in.reset(out.getData(), out.getData().length);
                    Key restoredKey = new Key(new byte[]{0});
                    Assert.assertFalse((String)"checkOnReadWrite equals error", (boolean)restoredKey.equals((Object)originKey));
                    restoredKey.readFields((DataInput)in);
                    Assert.assertTrue((String)"checkOnReadWrite equals error", (boolean)restoredKey.equals((Object)originKey));
                    out.reset();
                }
                catch (Exception ioe) {
                    Assert.fail((String)"checkOnReadWrite ex error");
                }
            }

            private void checkSetOnIAE() {
                Key key = new Key();
                try {
                    key.set(null, 0.0);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)"checkSetOnIAE ex error");
                }
            }

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                this.checkOnKeyMethods();
                this.checkOnReadWrite();
                this.checkSetOnIAE();
            }
        }),
        EXCEPTIONS_CHECK_STRATEGY(new FilterTesterStrategy(){

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                this.checkAddOnNPE(filter);
                this.checkTestMembershipOnNPE(filter);
                this.checkAndOnIAE(filter);
            }

            private void checkAndOnIAE(Filter filter) {
                List keys;
                Filter tfilter = null;
                try {
                    keys = null;
                    filter.add(keys);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
                try {
                    keys = null;
                    filter.add(keys);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
                try {
                    keys = null;
                    filter.add(keys);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
                try {
                    filter.and(tfilter);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
                try {
                    filter.or(tfilter);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
                try {
                    filter.xor(tfilter);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (UnsupportedOperationException unex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
            }

            private void checkTestMembershipOnNPE(Filter filter) {
                try {
                    Key nullKey = null;
                    filter.membershipTest(nullKey);
                }
                catch (NullPointerException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
            }

            private void checkAddOnNPE(Filter filter) {
                try {
                    Key nullKey = null;
                    filter.add(nullKey);
                }
                catch (NullPointerException ex) {
                }
                catch (Exception e) {
                    Assert.fail((String)("" + e));
                }
            }
        }),
        ODD_EVEN_ABSENT_STRATEGY(new FilterTesterStrategy(){

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                int i;
                for (i = 0; i < numInsertions; i += 2) {
                    filter.add(new Key(Integer.toString(i).getBytes()));
                }
                for (i = 0; i < numInsertions; i += 2) {
                    Assert.assertTrue((String)(" filter might contains " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                }
                for (i = 1; i < numInsertions; i += 2) {
                    if (falsePositives.contains((Object)i)) continue;
                    Assert.assertFalse((String)(" filter should not contain " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                }
            }
        }),
        WRITE_READ_STRATEGY(new FilterTesterStrategy(){
            private int slotSize = 10;

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                Random rnd = new Random();
                DataOutputBuffer out = new DataOutputBuffer();
                DataInputBuffer in = new DataInputBuffer();
                try {
                    Filter tempFilter = BloomFilterCommonTester.getSymmetricFilter(filter.getClass(), numInsertions, hashId);
                    ImmutableList.Builder blist = ImmutableList.builder();
                    for (int i = 0; i < this.slotSize; ++i) {
                        blist.add((Object)rnd.nextInt(numInsertions * 2));
                    }
                    ImmutableList list = blist.build();
                    for (Integer slot : list) {
                        filter.add(new Key(String.valueOf(slot).getBytes()));
                    }
                    filter.write((DataOutput)out);
                    in.reset(out.getData(), out.getLength());
                    tempFilter.readFields((DataInput)in);
                    for (Integer slot : list) {
                        Assert.assertTrue((String)("read/write mask check filter error on " + slot), (boolean)filter.membershipTest(new Key(String.valueOf(slot).getBytes())));
                    }
                }
                catch (IOException ex) {
                    Assert.fail((String)("error ex !!!" + ex));
                }
            }
        }),
        FILTER_XOR_STRATEGY(new FilterTesterStrategy(){

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                Filter symmetricFilter = BloomFilterCommonTester.getSymmetricFilter(filter.getClass(), numInsertions, hashId);
                try {
                    int i;
                    filter.xor(symmetricFilter);
                    for (i = 0; i < numInsertions; ++i) {
                        Assert.assertFalse((String)(" filter might contains " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                    }
                    for (i = 0; i < numInsertions; i += 2) {
                        filter.add(new Key(Integer.toString(i).getBytes()));
                    }
                    for (i = 0; i < numInsertions; i += 2) {
                        symmetricFilter.add(new Key(Integer.toString(i).getBytes()));
                    }
                    filter.xor(symmetricFilter);
                    for (i = 0; i < numInsertions; ++i) {
                        Assert.assertFalse((String)(" filter might not contains " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                    }
                }
                catch (UnsupportedOperationException ex) {
                    return;
                }
            }
        }),
        FILTER_AND_STRATEGY(new FilterTesterStrategy(){

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                int i;
                int startIntersection = numInsertions - (numInsertions - 100);
                int endIntersection = numInsertions - 100;
                Filter partialFilter = BloomFilterCommonTester.getSymmetricFilter(filter.getClass(), numInsertions, hashId);
                for (i = 0; i < numInsertions; ++i) {
                    String digit = Integer.toString(i);
                    filter.add(new Key(digit.getBytes()));
                    if (i < startIntersection || i > endIntersection) continue;
                    partialFilter.add(new Key(digit.getBytes()));
                }
                filter.and(partialFilter);
                for (i = 0; i < numInsertions; ++i) {
                    if (i < startIntersection || i > endIntersection) continue;
                    Assert.assertTrue((String)(" filter might contains " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                }
            }
        }),
        FILTER_OR_STRATEGY(new FilterTesterStrategy(){

            @Override
            public void assertWhat(Filter filter, int numInsertions, int hashId, ImmutableSet<Integer> falsePositives) {
                int i;
                Filter evenFilter = BloomFilterCommonTester.getSymmetricFilter(filter.getClass(), numInsertions, hashId);
                for (i = 0; i < numInsertions; i += 2) {
                    evenFilter.add(new Key(Integer.toString(i).getBytes()));
                }
                for (i = 1; i < numInsertions; i += 2) {
                    filter.add(new Key(Integer.toString(i).getBytes()));
                }
                filter.or(evenFilter);
                for (i = 0; i < numInsertions; ++i) {
                    Assert.assertTrue((String)(" filter might contains " + i), (boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())));
                }
            }
        });

        private final FilterTesterStrategy testerStrategy;

        private BloomFilterTestStrategy(FilterTesterStrategy testerStrategy) {
            this.testerStrategy = testerStrategy;
        }

        public FilterTesterStrategy getStrategy() {
            return this.testerStrategy;
        }
    }

    static interface FilterTesterStrategy {
        public static final Logger logger = Logger.getLogger(FilterTesterStrategy.class);

        public void assertWhat(Filter var1, int var2, int var3, ImmutableSet<Integer> var4);
    }
}

