/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.ObjectWritable;

public class TestEnumSetWritable
extends TestCase {
    EnumSet<TestEnumSet> nonEmptyFlag = EnumSet.of(TestEnumSet.APPEND);
    EnumSetWritable<TestEnumSet> nonEmptyFlagWritable = new EnumSetWritable(this.nonEmptyFlag);
    EnumSet<TestEnumSet> emptyFlag = EnumSet.noneOf(TestEnumSet.class);
    public EnumSetWritable<TestEnumSet> testField;

    public void testSerializeAndDeserializeNonEmpty() throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject((DataOutput)out, this.nonEmptyFlagWritable, this.nonEmptyFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject((DataInput)in, null)).get();
        TestEnumSetWritable.assertEquals((Object)read, this.nonEmptyFlag);
    }

    public void testSerializeAndDeserializeEmpty() throws IOException {
        boolean gotException = false;
        try {
            new EnumSetWritable(this.emptyFlag);
        }
        catch (RuntimeException e) {
            gotException = true;
        }
        TestEnumSetWritable.assertTrue((String)"Instantiation of empty EnumSetWritable with no element type class provided should throw exception.", (boolean)gotException);
        EnumSetWritable emptyFlagWritable = new EnumSetWritable(this.emptyFlag, TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject((DataOutput)out, (Object)emptyFlagWritable, emptyFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject((DataInput)in, null)).get();
        TestEnumSetWritable.assertEquals((Object)read, this.emptyFlag);
    }

    public void testSerializeAndDeserializeNull() throws IOException {
        boolean gotException = false;
        try {
            new EnumSetWritable(null);
        }
        catch (RuntimeException e) {
            gotException = true;
        }
        TestEnumSetWritable.assertTrue((String)"Instantiation of empty EnumSetWritable with no element type class provided should throw exception", (boolean)gotException);
        EnumSetWritable nullFlagWritable = new EnumSetWritable(null, TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        ObjectWritable.writeObject((DataOutput)out, (Object)nullFlagWritable, nullFlagWritable.getClass(), null);
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        EnumSet read = ((EnumSetWritable)ObjectWritable.readObject((DataInput)in, null)).get();
        TestEnumSetWritable.assertEquals((Object)read, null);
    }

    public void testAvroReflect() throws Exception {
        String schema = "{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"TestEnumSet\",\"namespace\":\"org.apache.hadoop.io.TestEnumSetWritable$\",\"symbols\":[\"CREATE\",\"OVERWRITE\",\"APPEND\"]},\"java-class\":\"org.apache.hadoop.io.EnumSetWritable\"}";
        Type type = TestEnumSetWritable.class.getField("testField").getGenericType();
        AvroTestUtil.testReflect(this.nonEmptyFlagWritable, type, schema);
    }

    public void testEnumSetWritableEquals() {
        EnumSetWritable eset1 = new EnumSetWritable(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        EnumSetWritable eset2 = new EnumSetWritable(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        TestEnumSetWritable.assertTrue((String)"testEnumSetWritableEquals error !!!", (boolean)eset1.equals((Object)eset2));
        TestEnumSetWritable.assertFalse((String)"testEnumSetWritableEquals error !!!", (boolean)eset1.equals((Object)new EnumSetWritable(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE, TestEnumSet.OVERWRITE), TestEnumSet.class)));
        TestEnumSetWritable.assertTrue((String)"testEnumSetWritableEquals getElementType error !!!", (boolean)eset1.getElementType().equals(TestEnumSet.class));
    }

    public void testEnumSetWritableWriteRead() throws Exception {
        EnumSetWritable srcSet = new EnumSetWritable(EnumSet.of(TestEnumSet.APPEND, TestEnumSet.CREATE), TestEnumSet.class);
        DataOutputBuffer out = new DataOutputBuffer();
        srcSet.write((DataOutput)out);
        EnumSetWritable dstSet = new EnumSetWritable();
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        dstSet.readFields((DataInput)in);
        EnumSet result = dstSet.get();
        Iterator dstIter = result.iterator();
        Iterator srcIter = srcSet.iterator();
        while (dstIter.hasNext() && srcIter.hasNext()) {
            TestEnumSetWritable.assertEquals((String)"testEnumSetWritableWriteRead error !!!", dstIter.next(), srcIter.next());
        }
    }

    static enum TestEnumSet {
        CREATE,
        OVERWRITE,
        APPEND;

    }
}

