/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSSLHttpServer
extends HttpServerFunctionalTest {
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestSSLHttpServer.class.getSimpleName();
    private static final Log LOG = LogFactory.getLog(TestSSLHttpServer.class);
    private static Configuration conf;
    private static HttpServer2 server;
    private static URL baseUrl;
    private static String keystoresDir;
    private static String sslConfDir;
    private static SSLFactory clientSslFactory;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        conf.setInt("hadoop.http.max.threads", 10);
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        base.mkdirs();
        keystoresDir = new File(BASEDIR).getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSSLHttpServer.class);
        KeyStoreTestUtil.setupSSLConfig(keystoresDir, sslConfDir, conf, false);
        Configuration sslConf = new Configuration(false);
        sslConf.addResource("ssl-server.xml");
        sslConf.addResource("ssl-client.xml");
        clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, sslConf);
        clientSslFactory.init();
        server = new HttpServer2.Builder().setName("test").addEndpoint(new URI("https://localhost")).setConf(conf).keyPassword(sslConf.get("ssl.server.keystore.keypassword")).keyStore(sslConf.get("ssl.server.keystore.location"), sslConf.get("ssl.server.keystore.password"), sslConf.get("ssl.server.keystore.type", "jks")).trustStore(sslConf.get("ssl.server.truststore.location"), sslConf.get("ssl.server.truststore.password"), sslConf.get("ssl.server.truststore.type", "jks")).build();
        server.addServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.start();
        baseUrl = new URL("https://" + NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0)));
        LOG.info((Object)("HTTP server started: " + baseUrl));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
        FileUtil.fullyDelete((File)new File(BASEDIR));
        KeyStoreTestUtil.cleanupSSLConfig(keystoresDir, sslConfDir);
        clientSslFactory.destroy();
    }

    @Test
    public void testEcho() throws Exception {
        TestSSLHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c=d")));
        TestSSLHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestSSLHttpServer.readOut(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    private static String readOut(URL url) throws Exception {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setSSLSocketFactory(clientSslFactory.createSSLSocketFactory());
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        return out.toString();
    }
}

