/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;

public class TestGetInstances
extends TestCase {
    public void testGetInstances() throws Exception {
        Configuration conf = new Configuration();
        List classes = conf.getInstances("no.such.property", SampleInterface.class);
        TestGetInstances.assertTrue((boolean)classes.isEmpty());
        conf.set("empty.property", "");
        classes = conf.getInstances("empty.property", SampleInterface.class);
        TestGetInstances.assertTrue((boolean)classes.isEmpty());
        conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName()});
        classes = conf.getInstances("some.classes", SampleInterface.class);
        TestGetInstances.assertEquals((int)2, (int)classes.size());
        try {
            conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName(), String.class.getName()});
            conf.getInstances("some.classes", SampleInterface.class);
            TestGetInstances.fail((String)"java.lang.String does not implement SampleInterface");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            conf.setStrings("some.classes", new String[]{SampleClass.class.getName(), AnotherClass.class.getName(), "no.such.Class"});
            conf.getInstances("some.classes", SampleInterface.class);
            TestGetInstances.fail((String)"no.such.Class does not exist");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    static class AnotherClass
    implements ChildInterface {
        AnotherClass() {
        }
    }

    static class SampleClass
    implements SampleInterface {
        SampleClass() {
        }
    }

    static interface ChildInterface
    extends SampleInterface {
    }

    static interface SampleInterface {
    }
}

