/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch.client;

import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.apache.flume.sink.elasticsearch.ElasticSearchIndexRequestBuilderFactory;
import org.apache.flume.sink.elasticsearch.client.ElasticSearchClient;
import org.apache.flume.sink.elasticsearch.client.ElasticSearchRestClient;
import org.apache.flume.sink.elasticsearch.client.ElasticSearchTransportClient;
import org.apache.flume.sink.elasticsearch.client.NoSuchClientTypeException;

public class ElasticSearchClientFactory {
    public static final String TransportClient = "transport";
    public static final String RestClient = "rest";

    public ElasticSearchClient getClient(String clientType, String[] hostNames, String clusterName, ElasticSearchEventSerializer serializer, ElasticSearchIndexRequestBuilderFactory indexBuilder) throws NoSuchClientTypeException {
        if (clientType.equalsIgnoreCase(TransportClient) && serializer != null) {
            return new ElasticSearchTransportClient(hostNames, clusterName, serializer);
        }
        if (clientType.equalsIgnoreCase(TransportClient) && indexBuilder != null) {
            return new ElasticSearchTransportClient(hostNames, clusterName, indexBuilder);
        }
        if (clientType.equalsIgnoreCase(RestClient) && serializer != null) {
            return new ElasticSearchRestClient(hostNames, serializer);
        }
        throw new NoSuchClientTypeException();
    }

    public ElasticSearchClient getLocalClient(String clientType, ElasticSearchEventSerializer serializer, ElasticSearchIndexRequestBuilderFactory indexBuilder) throws NoSuchClientTypeException {
        if (clientType.equalsIgnoreCase(TransportClient) && serializer != null) {
            return new ElasticSearchTransportClient(serializer);
        }
        if (clientType.equalsIgnoreCase(TransportClient) && indexBuilder != null) {
            return new ElasticSearchTransportClient(indexBuilder);
        }
        if (clientType.equalsIgnoreCase(RestClient)) {
            // empty if block
        }
        throw new NoSuchClientTypeException();
    }
}

