/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import java.io.IOException;
import java.nio.charset.Charset;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class ContentBuilderUtil {
    private static final Charset charset = Charset.defaultCharset();

    private ContentBuilderUtil() {
    }

    public static void appendField(XContentBuilder builder, String field, byte[] data) throws IOException {
        XContentType contentType = XContentFactory.xContentType((byte[])data);
        if (contentType == null) {
            ContentBuilderUtil.addSimpleField(builder, field, data);
        } else {
            ContentBuilderUtil.addComplexField(builder, field, contentType, data);
        }
    }

    public static void addSimpleField(XContentBuilder builder, String fieldName, byte[] data) throws IOException {
        builder.field(fieldName, new String(data, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addComplexField(XContentBuilder builder, String fieldName, XContentType contentType, byte[] data) throws IOException {
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent((XContentType)contentType).createParser(data);
            while (parser.nextToken() != null) {
            }
            parser = XContentFactory.xContent((XContentType)contentType).createParser(data);
            builder.field(fieldName);
            builder.copyCurrentStructure(parser);
        }
    }
}

