/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class LogUtils {
    private static final Pattern pattern = Pattern.compile("^log-\\d+$");

    static void sort(List<File> logs) {
        Collections.sort(logs, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                int id2;
                int id1 = LogUtils.getIDForFile(file1);
                if (id1 > (id2 = LogUtils.getIDForFile(file2))) {
                    return 1;
                }
                if (id1 == id2) {
                    return 0;
                }
                return -1;
            }
        });
    }

    static int getIDForFile(File file) {
        return Integer.parseInt(file.getName().substring("log-".length()));
    }

    static List<File> getLogs(File logDir) {
        ArrayList result = Lists.newArrayList();
        File[] files = logDir.listFiles();
        if (files == null) {
            String msg = logDir + ".listFiles() returned null: ";
            msg = msg + "File = " + logDir.isFile() + ", ";
            msg = msg + "Exists = " + logDir.exists() + ", ";
            msg = msg + "Writable = " + logDir.canWrite();
            throw new IllegalStateException(msg);
        }
        for (File file : files) {
            String name = file.getName();
            if (!pattern.matcher(name).matches()) continue;
            result.add(file);
        }
        return result;
    }
}

