/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import java.util.Arrays;
import org.apache.flume.channel.file.TransactionEventRecord;

public class LogRecord
implements Comparable<LogRecord> {
    private int fileID;
    private int offset;
    private TransactionEventRecord event;
    private static final short[] replaySortOrder = new short[]{TransactionEventRecord.Type.TAKE.get(), TransactionEventRecord.Type.PUT.get(), TransactionEventRecord.Type.ROLLBACK.get(), TransactionEventRecord.Type.COMMIT.get()};

    public LogRecord(int fileID, int offset, TransactionEventRecord event) {
        this.fileID = fileID;
        this.offset = offset;
        this.event = event;
    }

    public int getFileID() {
        return this.fileID;
    }

    public int getOffset() {
        return this.offset;
    }

    public TransactionEventRecord getEvent() {
        return this.event;
    }

    @Override
    public int compareTo(LogRecord o) {
        int result = new Long(this.event.getLogWriteOrderID()).compareTo(o.getEvent().getLogWriteOrderID());
        if (result == 0 && (result = new Long(this.event.getTransactionID()).compareTo(o.getEvent().getTransactionID())) == 0) {
            Integer thisIndex = Arrays.binarySearch(replaySortOrder, this.event.getRecordType());
            Integer thatIndex = Arrays.binarySearch(replaySortOrder, o.getEvent().getRecordType());
            return thisIndex.compareTo(thatIndex);
        }
        return result;
    }
}

