/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import java.util.List;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

public class YarnConfigOptions {
    public static final ConfigOption<Integer> APP_MASTER_VCORES = ConfigOptions.key((String)"yarn.appmaster.vcores").intType().defaultValue((Object)1).withDescription("The number of virtual cores (vcores) used by YARN application master.");
    public static final ConfigOption<UserJarInclusion> CLASSPATH_INCLUDE_USER_JAR = ConfigOptions.key((String)"yarn.per-job-cluster.include-user-jar").enumType(UserJarInclusion.class).defaultValue((Object)UserJarInclusion.ORDER).withDescription(String.format("Defines whether user-jars are included in the system class path for per-job-clusters as well as their positioning in the path. They can be positioned at the beginning (%s), at the end (%s), or be positioned based on their name (%s). %s means the user-jars are excluded from the system class path.", UserJarInclusion.FIRST.name(), UserJarInclusion.LAST.name(), UserJarInclusion.ORDER.name(), UserJarInclusion.DISABLED.name()));
    public static final ConfigOption<Integer> VCORES = ConfigOptions.key((String)"yarn.containers.vcores").intType().defaultValue((Object)-1).withDescription(Description.builder().text("The number of virtual cores (vcores) per YARN container. By default, the number of vcores is set to the number of slots per TaskManager, if set, or to 1, otherwise. In order for this parameter to be used your cluster must have CPU scheduling enabled. You can do this by setting the %s.", new InlineElement[]{TextElement.code((String)"org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler")}).build());
    public static final ConfigOption<String> APPLICATION_ATTEMPTS = ConfigOptions.key((String)"yarn.application-attempts").stringType().noDefaultValue().withDescription(Description.builder().text("Number of ApplicationMaster restarts. By default, the value will be set to 1. If high availability is enabled, then the default value will be 2. The restart number is also limited by YARN (configured via %s). Note that that the entire Flink cluster will restart and the YARN Client will lose the connection.", new InlineElement[]{LinkElement.link((String)"https://hadoop.apache.org/docs/stable/hadoop-yarn/hadoop-yarn-common/yarn-default.xml", (String)"yarn.resourcemanager.am.max-attempts")}).build());
    public static final ConfigOption<Long> APPLICATION_ATTEMPT_FAILURE_VALIDITY_INTERVAL = ConfigOptions.key((String)"yarn.application-attempt-failures-validity-interval").longType().defaultValue((Object)10000L).withDescription(Description.builder().text("Time window in milliseconds which defines the number of application attempt failures when restarting the AM. Failures which fall outside of this window are not being considered. Set this value to -1 in order to count globally. See %s for more information.", new InlineElement[]{LinkElement.link((String)"https://hortonworks.com/blog/apache-hadoop-yarn-hdp-2-2-fault-tolerance-features-long-running-services/", (String)"here")}).build());
    public static final ConfigOption<Integer> HEARTBEAT_DELAY_SECONDS = ConfigOptions.key((String)"yarn.heartbeat.interval").intType().defaultValue((Object)5).withDeprecatedKeys(new String[]{"yarn.heartbeat-delay"}).withDescription("Time between heartbeats with the ResourceManager in seconds.");
    public static final ConfigOption<Integer> CONTAINER_REQUEST_HEARTBEAT_INTERVAL_MILLISECONDS = ConfigOptions.key((String)"yarn.heartbeat.container-request-interval").intType().defaultValue((Object)500).withDescription(new Description.DescriptionBuilder().text("Time between heartbeats with the ResourceManager in milliseconds if Flink requests containers:").list(new InlineElement[]{TextElement.text((String)"The lower this value is, the faster Flink will get notified about container allocations since requests and allocations are transmitted via heartbeats."), TextElement.text((String)"The lower this value is, the more excessive containers might get allocated which will eventually be released but put pressure on Yarn.")}).text("If you observe too many container allocations on the ResourceManager, then it is recommended to increase this value. See %s for more information.", new InlineElement[]{LinkElement.link((String)"https://issues.apache.org/jira/browse/YARN-1902", (String)"this link")}).build());
    public static final ConfigOption<String> PROPERTIES_FILE_LOCATION = ConfigOptions.key((String)"yarn.properties-file.location").stringType().noDefaultValue().withDescription("When a Flink job is submitted to YARN, the JobManager\u2019s host and the number of available processing slots is written into a properties file, so that the Flink client is able to pick those details up. This configuration parameter allows changing the default location of that file (for example for environments sharing a Flink installation between users).");
    public static final ConfigOption<String> APPLICATION_MASTER_PORT = ConfigOptions.key((String)"yarn.application-master.port").stringType().defaultValue((Object)"0").withDescription("With this configuration option, users can specify a port, a range of ports or a list of ports for the Application Master (and JobManager) RPC port. By default we recommend using the default value (0) to let the operating system choose an appropriate port. In particular when multiple AMs are running on the same physical host, fixed port assignments prevent the AM from starting. For example when running Flink on YARN on an environment with a restrictive firewall, this option allows specifying a range of allowed ports.");
    public static final ConfigOption<Integer> APPLICATION_PRIORITY = ConfigOptions.key((String)"yarn.application.priority").intType().defaultValue((Object)-1).withDescription("A non-negative integer indicating the priority for submitting a Flink YARN application. It will only take effect if YARN priority scheduling setting is enabled. Larger integer corresponds with higher priority. If priority is negative or set to '-1'(default), Flink will unset yarn priority setting and use cluster default priority. Please refer to YARN's official documentation for specific settings required to enable priority scheduling for the targeted YARN version.");
    public static final ConfigOption<Integer> FILE_REPLICATION = ConfigOptions.key((String)"yarn.file-replication").intType().defaultValue((Object)-1).withDescription("Number of file replication of each local resource file. If it is not configured, Flink will use the default replication value in hadoop configuration.");
    public static final ConfigOption<String> APPLICATION_TAGS = ConfigOptions.key((String)"yarn.tags").stringType().defaultValue((Object)"").withDescription("A comma-separated list of tags to apply to the Flink YARN application.");
    public static final ConfigOption<String> STAGING_DIRECTORY = ConfigOptions.key((String)"yarn.staging-directory").stringType().noDefaultValue().withDescription("Staging directory used to store YARN files while submitting applications. Per default, it uses the home directory of the configured file system.");
    public static final ConfigOption<List<String>> SHIP_FILES = ConfigOptions.key((String)"yarn.ship-files").stringType().asList().noDefaultValue().withDeprecatedKeys(new String[]{"yarn.ship-directories"}).withDescription("A semicolon-separated list of files and/or directories to be shipped to the YARN cluster.");
    public static final ConfigOption<List<String>> SHIP_ARCHIVES = ConfigOptions.key((String)"yarn.ship-archives").stringType().asList().noDefaultValue().withDescription("A semicolon-separated list of archives to be shipped to the YARN cluster. These archives will be un-packed when localizing and they can be any of the following types: \".tar.gz\", \".tar\", \".tgz\", \".dst\", \".jar\", \".zip\".");
    public static final ConfigOption<String> FLINK_DIST_JAR = ConfigOptions.key((String)"yarn.flink-dist-jar").stringType().noDefaultValue().withDescription("The location of the Flink dist jar.");
    public static final ConfigOption<String> APPLICATION_ID = ConfigOptions.key((String)"yarn.application.id").stringType().noDefaultValue().withDescription("The YARN application id of the running yarn cluster. This is the YARN cluster where the pipeline is going to be executed.");
    public static final ConfigOption<String> APPLICATION_QUEUE = ConfigOptions.key((String)"yarn.application.queue").stringType().noDefaultValue().withDescription("The YARN queue on which to put the current pipeline.");
    public static final ConfigOption<String> APPLICATION_NAME = ConfigOptions.key((String)"yarn.application.name").stringType().noDefaultValue().withDescription("A custom name for your YARN application.");
    public static final ConfigOption<String> APPLICATION_TYPE = ConfigOptions.key((String)"yarn.application.type").stringType().noDefaultValue().withDescription("A custom type for your YARN application..");
    public static final ConfigOption<String> NODE_LABEL = ConfigOptions.key((String)"yarn.application.node-label").stringType().noDefaultValue().withDescription("Specify YARN node label for the YARN application.");
    public static final ConfigOption<Boolean> SHIP_LOCAL_KEYTAB = ConfigOptions.key((String)"yarn.security.kerberos.ship-local-keytab").booleanType().defaultValue((Object)true).withDescription("When this is true Flink will ship the keytab file configured via " + SecurityOptions.KERBEROS_LOGIN_KEYTAB.key() + " as a localized YARN resource.");
    public static final ConfigOption<String> LOCALIZED_KEYTAB_PATH = ConfigOptions.key((String)"yarn.security.kerberos.localized-keytab-path").stringType().defaultValue((Object)"krb5.keytab").withDescription("Local (on NodeManager) path where kerberos keytab file will be localized to. If " + SHIP_LOCAL_KEYTAB.key() + " set to true, Flink willl ship the keytab file as a YARN local resource. In this case, the path is relative to the local resource directory. If set to false, Flink will try to directly locate the keytab from the path itself.");
    public static final ConfigOption<List<String>> PROVIDED_LIB_DIRS = ConfigOptions.key((String)"yarn.provided.lib.dirs").stringType().asList().noDefaultValue().withDescription("A semicolon-separated list of provided lib directories. They should be pre-uploaded and world-readable. Flink will use them to exclude the local Flink jars(e.g. flink-dist, lib/, plugins/)uploading to accelerate the job submission process. Also YARN will cache them on the nodes so that they doesn't need to be downloaded every time for each application. An example could be hdfs://$namenode_address/path/of/flink/lib");
    public static final ConfigOption<List<String>> YARN_ACCESS = ConfigOptions.key((String)"yarn.security.kerberos.additionalFileSystems").stringType().asList().noDefaultValue().withDescription("A comma-separated list of additional Kerberos-secured Hadoop filesystems Flink is going to access. For example, yarn.security.kerberos.additionalFileSystems=hdfs://namenode2:9002,hdfs://namenode3:9003. The client submitting to YARN needs to have access to these file systems to retrieve the security tokens.");
    public static final ConfigOption<String> HADOOP_CONFIG_KEY = ConfigOptions.key((String)"flink.hadoop.<key>").stringType().noDefaultValue().withDescription(Description.builder().text("A general option to probe Hadoop configuration through prefix 'flink.hadoop.'. Flink will remove the prefix to get <key> (from %s and %s) then set the <key> and value to Hadoop configuration. For example, flink.hadoop.dfs.replication=5 in Flink configuration and convert to dfs.replication=5 in Hadoop configuration.", new InlineElement[]{LinkElement.link((String)"https://hadoop.apache.org/docs/stable/hadoop-project-dist/hadoop-common/core-default.xml", (String)"core-default.xml"), LinkElement.link((String)"https://hadoop.apache.org/docs/stable/hadoop-project-dist/hadoop-hdfs/hdfs-default.xml", (String)"hdfs-default.xml")}).build());
    public static final ConfigOption<String> YARN_CONFIG_KEY = ConfigOptions.key((String)"flink.yarn.<key>").stringType().noDefaultValue().withDescription(Description.builder().text("A general option to probe Yarn configuration through prefix 'flink.yarn.'. Flink will remove the prefix 'flink.' to get yarn.<key> (from %s) then set the yarn.<key> and value to Yarn configuration. For example, flink.yarn.resourcemanager.container.liveness-monitor.interval-ms=300000 in Flink configuration and convert to yarn.resourcemanager.container.liveness-monitor.interval-ms=300000 in Yarn configuration.", new InlineElement[]{LinkElement.link((String)"https://hadoop.apache.org/docs/stable/hadoop-yarn/hadoop-yarn-common/yarn-default.xml", (String)"yarn-default.xml")}).build());
    public static final String EXTERNAL_RESOURCE_YARN_CONFIG_KEY_SUFFIX = "yarn.config-key";
    public static final ConfigOption<String> EXTERNAL_RESOURCE_YARN_CONFIG_KEY = ConfigOptions.key((String)ExternalResourceOptions.genericKeyWithSuffix((String)"yarn.config-key")).stringType().noDefaultValue().withDescription("If configured, Flink will add this key to the resource profile of container request to Yarn. The value will be set to the value of " + ExternalResourceOptions.EXTERNAL_RESOURCE_AMOUNT.key() + ".");

    private YarnConfigOptions() {
    }

    public static enum UserJarInclusion {
        DISABLED,
        FIRST,
        LAST,
        ORDER;

    }
}

