/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.cli;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnApplicationStatusMonitor
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(YarnApplicationStatusMonitor.class);
    private static final long UPDATE_INTERVAL = 1000L;
    private final YarnClient yarnClient;
    private final ApplicationId yarnApplicationId;
    private final ScheduledFuture<?> applicationStatusUpdateFuture;
    private volatile ApplicationStatus applicationStatus;

    public YarnApplicationStatusMonitor(YarnClient yarnClient, ApplicationId yarnApplicationId, ScheduledExecutor scheduledExecutor) {
        this.yarnClient = (YarnClient)Preconditions.checkNotNull((Object)yarnClient);
        this.yarnApplicationId = (ApplicationId)Preconditions.checkNotNull((Object)yarnApplicationId);
        this.applicationStatusUpdateFuture = scheduledExecutor.scheduleWithFixedDelay(this::updateApplicationStatus, 0L, 1000L, TimeUnit.MILLISECONDS);
        this.applicationStatus = ApplicationStatus.UNKNOWN;
    }

    public ApplicationStatus getApplicationStatusNow() {
        return this.applicationStatus;
    }

    @Override
    public void close() {
        this.applicationStatusUpdateFuture.cancel(false);
    }

    private void updateApplicationStatus() {
        if (this.yarnClient.isInState(Service.STATE.STARTED)) {
            ApplicationReport applicationReport;
            try {
                applicationReport = this.yarnClient.getApplicationReport(this.yarnApplicationId);
            }
            catch (Exception e) {
                LOG.info("Could not retrieve the Yarn application report for {}.", (Object)this.yarnApplicationId);
                this.applicationStatus = ApplicationStatus.UNKNOWN;
                return;
            }
            YarnApplicationState yarnApplicationState = applicationReport.getYarnApplicationState();
            this.applicationStatus = yarnApplicationState == YarnApplicationState.FAILED || yarnApplicationState == YarnApplicationState.KILLED ? ApplicationStatus.FAILED : ApplicationStatus.SUCCEEDED;
        } else {
            LOG.info("Yarn client is no longer in state STARTED. Stopping the Yarn application status monitor.");
            this.applicationStatusUpdateFuture.cancel(false);
        }
    }
}

