/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.util.Preconditions;

@Internal
public class TableSchemaUtils {
    public static TableSchema getPhysicalSchema(TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)tableSchema);
        TableSchema.Builder builder = new TableSchema.Builder();
        tableSchema.getTableColumns().forEach(tableColumn -> {
            if (!tableColumn.isGenerated()) {
                builder.field(tableColumn.getName(), tableColumn.getType());
            }
        });
        return builder.build();
    }

    public static boolean containsGeneratedColumns(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        return schema.getTableColumns().stream().anyMatch(TableColumn::isGenerated);
    }

    public static TableSchema checkNoGeneratedColumns(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (TableSchemaUtils.containsGeneratedColumns(schema)) {
            throw new ValidationException("The given schema contains generated columns, schema: " + schema.toString());
        }
        return schema;
    }
}

