/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public final class LegacyTypeInfoDataTypeConverter {
    private static final Map<TypeInformation<?>, DataType> typeInfoDataTypeMap = new HashMap();
    private static final Map<DataType, TypeInformation<?>> dataTypeTypeInfoMap = new HashMap();

    private static void addMapping(TypeInformation<?> typeInfo, DataType dataType2) {
        Preconditions.checkArgument((!typeInfoDataTypeMap.containsKey(typeInfo) ? 1 : 0) != 0);
        typeInfoDataTypeMap.put(typeInfo, dataType2);
        dataTypeTypeInfoMap.put(dataType2, typeInfo);
    }

    public static DataType toDataType(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof TimeIndicatorTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToTimeAttributeType((TimeIndicatorTypeInfo)typeInfo);
        }
        DataType foundDataType = typeInfoDataTypeMap.get(typeInfo);
        if (foundDataType != null) {
            return foundDataType;
        }
        if (typeInfo instanceof RowTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToRowType((RowTypeInfo)typeInfo);
        }
        if (typeInfo instanceof ObjectArrayTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToArrayType(typeInfo.getTypeClass(), ((ObjectArrayTypeInfo)typeInfo).getComponentInfo());
        }
        if (typeInfo instanceof BasicArrayTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.ARRAY, typeInfo);
        }
        if (typeInfo instanceof MultisetTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToMultisetType(((MultisetTypeInfo)typeInfo).getElementTypeInfo());
        }
        if (typeInfo instanceof MapTypeInfo) {
            return LegacyTypeInfoDataTypeConverter.convertToMapType((MapTypeInfo)typeInfo);
        }
        if (typeInfo instanceof CompositeType) {
            return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.STRUCTURED_TYPE, typeInfo);
        }
        return LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.RAW, typeInfo);
    }

    public static TypeInformation<?> toLegacyTypeInfo(DataType dataType2) {
        if (LegacyTypeInfoDataTypeConverter.canConvertToTimeAttributeTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToTimeAttributeTypeInfo((TimestampType)dataType2.getLogicalType());
        }
        TypeInformation<?> foundTypeInfo = dataTypeTypeInfoMap.get(dataType2.nullable());
        if (foundTypeInfo != null) {
            return foundTypeInfo;
        }
        LogicalType logicalType = dataType2.getLogicalType();
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.DECIMAL)) {
            return Types.BIG_DEC;
        }
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.CHAR)) {
            return Types.STRING;
        }
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.VARCHAR)) {
            return Types.STRING;
        }
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && dataType2.getConversionClass() == Timestamp.class) {
            return Types.SQL_TIMESTAMP;
        }
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && dataType2.getConversionClass() == LocalDateTime.class) {
            return Types.LOCAL_DATE_TIME;
        }
        if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE) && dataType2.getConversionClass() == LocalTime.class) {
            return Types.LOCAL_TIME;
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToLegacyTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToLegacyTypeInfo(dataType2);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToRowTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToRowTypeInfo((FieldsDataType)dataType2);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToObjectArrayTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToObjectArrayTypeInfo((CollectionDataType)dataType2);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToMultisetTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToMultisetTypeInfo((CollectionDataType)dataType2);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToMapTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToMapTypeInfo((KeyValueDataType)dataType2);
        }
        if (LegacyTypeInfoDataTypeConverter.canConvertToRawTypeInfo(dataType2)) {
            return LegacyTypeInfoDataTypeConverter.convertToRawTypeInfo(dataType2);
        }
        throw new TableException(String.format("Unsupported conversion from data type '%s' (conversion class: %s) to type information. Only data types that originated from type information fully support a reverse conversion.", dataType2, dataType2.getConversionClass().getName()));
    }

    private static DataType createLegacyType(LogicalTypeRoot typeRoot, TypeInformation<?> typeInfo) {
        return new AtomicDataType(new LegacyTypeInformationType(typeRoot, typeInfo)).bridgedTo(typeInfo.getTypeClass());
    }

    private static DataType convertToTimeAttributeType(TimeIndicatorTypeInfo timeIndicatorTypeInfo) {
        TimestampKind kind = timeIndicatorTypeInfo.isEventTime() ? TimestampKind.ROWTIME : TimestampKind.PROCTIME;
        return new AtomicDataType(new TimestampType(true, kind, 3)).bridgedTo(Timestamp.class);
    }

    private static boolean canConvertToTimeAttributeTypeInfo(DataType dataType2) {
        return LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && dataTypeTypeInfoMap.containsKey(dataType2) && ((TimestampType)dataType2.getLogicalType()).getKind() != TimestampKind.REGULAR;
    }

    private static TypeInformation<?> convertToTimeAttributeTypeInfo(TimestampType timestampType) {
        if (LogicalTypeChecks.isRowtimeAttribute(timestampType)) {
            return TimeIndicatorTypeInfo.ROWTIME_INDICATOR;
        }
        return TimeIndicatorTypeInfo.PROCTIME_INDICATOR;
    }

    private static DataType convertToRowType(RowTypeInfo rowTypeInfo) {
        String[] fieldNames = rowTypeInfo.getFieldNames();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, rowTypeInfo.getArity()).mapToObj(i -> {
            DataType fieldType = LegacyTypeInfoDataTypeConverter.toDataType(rowTypeInfo.getTypeAt(i));
            return DataTypes.FIELD(fieldNames[i], fieldType);
        }).toArray(DataTypes.Field[]::new);
        return DataTypes.ROW(fields).bridgedTo(Row.class);
    }

    private static boolean canConvertToRowTypeInfo(DataType dataType2) {
        return LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.ROW) && dataType2.getConversionClass().equals(Row.class) && ((RowType)dataType2.getLogicalType()).getFields().stream().noneMatch(f -> f.getDescription().isPresent());
    }

    private static TypeInformation<?> convertToRowTypeInfo(FieldsDataType fieldsDataType) {
        RowType rowType = (RowType)fieldsDataType.getLogicalType();
        String[] fieldNames = (String[])rowType.getFields().stream().map(RowType.RowField::getName).toArray(String[]::new);
        TypeInformation[] fieldTypes = (TypeInformation[])Stream.of(fieldNames).map(name -> fieldsDataType.getFieldDataTypes().get(name)).map(LegacyTypeInfoDataTypeConverter::toLegacyTypeInfo).toArray(TypeInformation[]::new);
        return Types.ROW_NAMED((String[])fieldNames, (TypeInformation[])fieldTypes);
    }

    private static DataType convertToArrayType(Class<?> arrayClass, TypeInformation<?> elementTypeInfo) {
        return DataTypes.ARRAY(LegacyTypeInfoDataTypeConverter.toDataType(elementTypeInfo)).bridgedTo(arrayClass);
    }

    private static boolean canConvertToObjectArrayTypeInfo(DataType dataType2) {
        return LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.ARRAY) && dataType2.getConversionClass().isArray();
    }

    private static TypeInformation<?> convertToObjectArrayTypeInfo(CollectionDataType collectionDataType) {
        return ObjectArrayTypeInfo.getInfoFor(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(collectionDataType.getElementDataType()));
    }

    private static DataType convertToMultisetType(TypeInformation elementTypeInfo) {
        return DataTypes.MULTISET(LegacyTypeInfoDataTypeConverter.toDataType(elementTypeInfo)).bridgedTo(Map.class);
    }

    private static boolean canConvertToMultisetTypeInfo(DataType dataType2) {
        return LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.MULTISET) && dataType2.getConversionClass() == Map.class;
    }

    private static TypeInformation<?> convertToMultisetTypeInfo(CollectionDataType collectionDataType) {
        return new MultisetTypeInfo(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(collectionDataType.getElementDataType()));
    }

    private static DataType convertToMapType(MapTypeInfo typeInfo) {
        return DataTypes.MAP(LegacyTypeInfoDataTypeConverter.toDataType(typeInfo.getKeyTypeInfo()), LegacyTypeInfoDataTypeConverter.toDataType(typeInfo.getValueTypeInfo())).bridgedTo(Map.class);
    }

    private static boolean canConvertToMapTypeInfo(DataType dataType2) {
        return LogicalTypeChecks.hasRoot(dataType2.getLogicalType(), LogicalTypeRoot.MAP) && dataType2.getConversionClass() == Map.class;
    }

    private static TypeInformation<?> convertToMapTypeInfo(KeyValueDataType dataType2) {
        return Types.MAP(LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(dataType2.getKeyDataType()), LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(dataType2.getValueDataType()));
    }

    private static boolean canConvertToLegacyTypeInfo(DataType dataType2) {
        return dataType2.getLogicalType() instanceof LegacyTypeInformationType;
    }

    private static TypeInformation<?> convertToLegacyTypeInfo(DataType dataType2) {
        return ((LegacyTypeInformationType)dataType2.getLogicalType()).getTypeInformation();
    }

    private static boolean canConvertToRawTypeInfo(DataType dataType2) {
        return dataType2.getLogicalType() instanceof TypeInformationRawType && dataType2.getConversionClass().equals(((TypeInformationRawType)dataType2.getLogicalType()).getTypeInformation().getTypeClass());
    }

    private static TypeInformation<?> convertToRawTypeInfo(DataType dataType2) {
        return ((TypeInformationRawType)dataType2.getLogicalType()).getTypeInformation();
    }

    private LegacyTypeInfoDataTypeConverter() {
    }

    static {
        LegacyTypeInfoDataTypeConverter.addMapping(Types.STRING, DataTypes.STRING().bridgedTo(String.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BOOLEAN, DataTypes.BOOLEAN().bridgedTo(Boolean.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BYTE, DataTypes.TINYINT().bridgedTo(Byte.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SHORT, DataTypes.SMALLINT().bridgedTo(Short.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.INT, DataTypes.INT().bridgedTo(Integer.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LONG, DataTypes.BIGINT().bridgedTo(Long.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.FLOAT, DataTypes.FLOAT().bridgedTo(Float.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.DOUBLE, DataTypes.DOUBLE().bridgedTo(Double.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.BIG_DEC, LegacyTypeInfoDataTypeConverter.createLegacyType(LogicalTypeRoot.DECIMAL, Types.BIG_DEC));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_DATE, DataTypes.DATE().bridgedTo(LocalDate.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_TIME, DataTypes.TIME(0).bridgedTo(LocalTime.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.LOCAL_DATE_TIME, DataTypes.TIMESTAMP(3).bridgedTo(LocalDateTime.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.INSTANT, DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(3).bridgedTo(Instant.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_DATE, DataTypes.DATE().bridgedTo(Date.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_TIME, DataTypes.TIME(0).bridgedTo(Time.class));
        LegacyTypeInfoDataTypeConverter.addMapping(Types.SQL_TIMESTAMP, DataTypes.TIMESTAMP(3).bridgedTo(Timestamp.class));
        LegacyTypeInfoDataTypeConverter.addMapping(TimeIntervalTypeInfo.INTERVAL_MONTHS, DataTypes.INTERVAL(DataTypes.MONTH()).bridgedTo(Integer.class));
        LegacyTypeInfoDataTypeConverter.addMapping(TimeIntervalTypeInfo.INTERVAL_MILLIS, DataTypes.INTERVAL(DataTypes.SECOND(3)).bridgedTo(Long.class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.BOOLEAN().notNull().bridgedTo(Boolean.TYPE)).bridgedTo(boolean[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.BYTES().bridgedTo(byte[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.SMALLINT().notNull().bridgedTo(Short.TYPE)).bridgedTo(short[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.INT().notNull().bridgedTo(Integer.TYPE)).bridgedTo(int[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.BIGINT().notNull().bridgedTo(Long.TYPE)).bridgedTo(long[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.FLOAT().notNull().bridgedTo(Float.TYPE)).bridgedTo(float[].class));
        LegacyTypeInfoDataTypeConverter.addMapping(PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, DataTypes.ARRAY(DataTypes.DOUBLE().notNull().bridgedTo(Double.TYPE)).bridgedTo(double[].class));
    }
}

