/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.util.Preconditions;

@Internal
public final class DataTypeUtils {
    public static DataType replaceLogicalType(DataType dataType2, LogicalType replacement) {
        return LogicalTypeDataTypeConverter.toDataType(replacement).bridgedTo(dataType2.getConversionClass());
    }

    public static DataType transform(DataType typeToTransform, TypeTransformation ... transformations) {
        Preconditions.checkArgument((transformations.length > 0 ? 1 : 0) != 0, (Object)"transformations should not be empty.");
        DataType newType = typeToTransform;
        for (TypeTransformation transformation : transformations) {
            newType = newType.accept(new DataTypeTransformer(transformation));
        }
        return newType;
    }

    public static TableSchema expandCompositeTypeToSchema(DataType dataType2) {
        if (dataType2 instanceof FieldsDataType) {
            return DataTypeUtils.expandCompositeType((FieldsDataType)dataType2);
        }
        if (dataType2.getLogicalType() instanceof LegacyTypeInformationType && dataType2.getLogicalType().getTypeRoot() == LogicalTypeRoot.STRUCTURED_TYPE) {
            return DataTypeUtils.expandLegacyCompositeType(dataType2);
        }
        throw new IllegalArgumentException("Expected a composite type");
    }

    private DataTypeUtils() {
    }

    private static TableSchema expandCompositeType(FieldsDataType dataType2) {
        final Map<String, DataType> fieldDataTypes = dataType2.getFieldDataTypes();
        return dataType2.getLogicalType().accept(new LogicalTypeDefaultVisitor<TableSchema>(){

            @Override
            public TableSchema visit(RowType rowType) {
                return DataTypeUtils.expandRowType(rowType, fieldDataTypes);
            }

            @Override
            public TableSchema visit(StructuredType structuredType) {
                return DataTypeUtils.expandStructuredType(structuredType, fieldDataTypes);
            }

            @Override
            public TableSchema visit(DistinctType distinctType) {
                return distinctType.getSourceType().accept(this);
            }

            @Override
            protected TableSchema defaultMethod(LogicalType logicalType) {
                throw new IllegalArgumentException("Expected a composite type");
            }
        });
    }

    private static TableSchema expandLegacyCompositeType(DataType dataType2) {
        CompositeType compositeType = (CompositeType)((LegacyTypeInformationType)dataType2.getLogicalType()).getTypeInformation();
        String[] fieldNames = compositeType.getFieldNames();
        TypeInformation[] fieldTypes = (TypeInformation[])Arrays.stream(fieldNames).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).toArray(TypeInformation[]::new);
        return new TableSchema(fieldNames, fieldTypes);
    }

    private static TableSchema expandStructuredType(StructuredType structuredType, Map<String, DataType> fieldDataTypes) {
        String[] fieldNames = (String[])structuredType.getAttributes().stream().map(StructuredType.StructuredAttribute::getName).toArray(String[]::new);
        DataType[] dataTypes = (DataType[])structuredType.getAttributes().stream().map(attr -> (DataType)fieldDataTypes.get(attr.getName())).toArray(DataType[]::new);
        return TableSchema.builder().fields(fieldNames, dataTypes).build();
    }

    private static TableSchema expandRowType(RowType rowType, Map<String, DataType> fieldDataTypes) {
        String[] fieldNames = rowType.getFieldNames().toArray(new String[0]);
        DataType[] dataTypes = (DataType[])rowType.getFields().stream().map(field -> (DataType)fieldDataTypes.get(field.getName())).toArray(DataType[]::new);
        return TableSchema.builder().fields(fieldNames, dataTypes).build();
    }

    private static class DataTypeTransformer
    implements DataTypeVisitor<DataType> {
        private final TypeTransformation transformation;

        private DataTypeTransformer(TypeTransformation transformation) {
            this.transformation = transformation;
        }

        @Override
        public DataType visit(AtomicDataType atomicDataType) {
            return this.transformation.transform(atomicDataType);
        }

        @Override
        public DataType visit(CollectionDataType collectionDataType) {
            LogicalType newLogicalType;
            DataType newElementType = collectionDataType.getElementDataType().accept(this);
            LogicalType logicalType = collectionDataType.getLogicalType();
            if (logicalType instanceof ArrayType) {
                newLogicalType = new ArrayType(logicalType.isNullable(), newElementType.getLogicalType());
            } else if (logicalType instanceof MultisetType) {
                newLogicalType = new MultisetType(logicalType.isNullable(), newElementType.getLogicalType());
            } else {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            return this.transformation.transform(new CollectionDataType(newLogicalType, newElementType));
        }

        @Override
        public DataType visit(FieldsDataType fieldsDataType) {
            HashMap<String, DataType> newFields = new HashMap<String, DataType>();
            fieldsDataType.getFieldDataTypes().forEach((name, type) -> newFields.put((String)name, type.accept(this)));
            LogicalType logicalType = fieldsDataType.getLogicalType();
            if (!(logicalType instanceof RowType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            List<RowType.RowField> rowFields = ((RowType)logicalType).getFields();
            List<RowType.RowField> newRowFields = rowFields.stream().map(f -> new RowType.RowField(f.getName(), ((DataType)newFields.get(f.getName())).getLogicalType(), f.getDescription().orElse(null))).collect(Collectors.toList());
            RowType newLogicalType = new RowType(logicalType.isNullable(), newRowFields);
            return this.transformation.transform(new FieldsDataType((LogicalType)newLogicalType, newFields));
        }

        @Override
        public DataType visit(KeyValueDataType keyValueDataType) {
            DataType newKeyType = keyValueDataType.getKeyDataType().accept(this);
            DataType newValueType = keyValueDataType.getValueDataType().accept(this);
            LogicalType logicalType = keyValueDataType.getLogicalType();
            if (!(logicalType instanceof MapType)) {
                throw new UnsupportedOperationException("Unsupported logical type : " + logicalType);
            }
            MapType newLogicalType = new MapType(logicalType.isNullable(), newKeyType.getLogicalType(), newValueType.getLogicalType());
            return this.transformation.transform(new KeyValueDataType(newLogicalType, newKeyType, newValueType));
        }
    }
}

