/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.TableSymbol;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.SymbolType;

@Internal
public final class ClassDataTypeConverter {
    private static final Map<String, DataType> defaultDataTypes = new HashMap<String, DataType>();

    private static void addDefaultDataType(Class<?> clazz, DataType rootType) {
        DataType dataType2 = clazz.isPrimitive() ? rootType.notNull() : rootType.nullable();
        defaultDataTypes.put(clazz.getName(), dataType2.bridgedTo(clazz));
    }

    public static Optional<DataType> extractDataType(Class<?> clazz) {
        if (clazz.equals(byte[].class)) {
            return Optional.of(DataTypes.BYTES());
        }
        if (clazz.isArray()) {
            return ClassDataTypeConverter.extractDataType(clazz.getComponentType()).map(DataTypes::ARRAY);
        }
        if (TableSymbol.class.isAssignableFrom(clazz)) {
            return Optional.of(new AtomicDataType(new SymbolType(clazz)));
        }
        return Optional.ofNullable(defaultDataTypes.get(clazz.getName()));
    }

    private ClassDataTypeConverter() {
    }

    static {
        ClassDataTypeConverter.addDefaultDataType(String.class, DataTypes.STRING());
        ClassDataTypeConverter.addDefaultDataType(Boolean.class, DataTypes.BOOLEAN());
        ClassDataTypeConverter.addDefaultDataType(Boolean.TYPE, DataTypes.BOOLEAN());
        ClassDataTypeConverter.addDefaultDataType(Byte.class, DataTypes.TINYINT());
        ClassDataTypeConverter.addDefaultDataType(Byte.TYPE, DataTypes.TINYINT());
        ClassDataTypeConverter.addDefaultDataType(Short.class, DataTypes.SMALLINT());
        ClassDataTypeConverter.addDefaultDataType(Short.TYPE, DataTypes.SMALLINT());
        ClassDataTypeConverter.addDefaultDataType(Integer.class, DataTypes.INT());
        ClassDataTypeConverter.addDefaultDataType(Integer.TYPE, DataTypes.INT());
        ClassDataTypeConverter.addDefaultDataType(Long.class, DataTypes.BIGINT());
        ClassDataTypeConverter.addDefaultDataType(Long.TYPE, DataTypes.BIGINT());
        ClassDataTypeConverter.addDefaultDataType(Float.class, DataTypes.FLOAT());
        ClassDataTypeConverter.addDefaultDataType(Float.TYPE, DataTypes.FLOAT());
        ClassDataTypeConverter.addDefaultDataType(Double.class, DataTypes.DOUBLE());
        ClassDataTypeConverter.addDefaultDataType(Double.TYPE, DataTypes.DOUBLE());
        ClassDataTypeConverter.addDefaultDataType(Date.class, DataTypes.DATE());
        ClassDataTypeConverter.addDefaultDataType(LocalDate.class, DataTypes.DATE());
        ClassDataTypeConverter.addDefaultDataType(Time.class, DataTypes.TIME(0));
        ClassDataTypeConverter.addDefaultDataType(LocalTime.class, DataTypes.TIME(9));
        ClassDataTypeConverter.addDefaultDataType(Timestamp.class, DataTypes.TIMESTAMP(9));
        ClassDataTypeConverter.addDefaultDataType(LocalDateTime.class, DataTypes.TIMESTAMP(9));
        ClassDataTypeConverter.addDefaultDataType(OffsetDateTime.class, DataTypes.TIMESTAMP_WITH_TIME_ZONE(9));
        ClassDataTypeConverter.addDefaultDataType(Instant.class, DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(9));
        ClassDataTypeConverter.addDefaultDataType(Duration.class, DataTypes.INTERVAL(DataTypes.SECOND(9)));
        ClassDataTypeConverter.addDefaultDataType(Period.class, DataTypes.INTERVAL(DataTypes.YEAR(4), DataTypes.MONTH()));
    }
}

