/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.transforms;

import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class DataTypeConversionClassTransformation
implements TypeTransformation {
    private final Map<LogicalTypeRoot, Class<?>> conversions;

    public DataTypeConversionClassTransformation(Map<LogicalTypeRoot, Class<?>> conversions) {
        this.conversions = conversions;
    }

    @Override
    public DataType transform(DataType dataType2) {
        LogicalType logicalType = dataType2.getLogicalType();
        Class<?> conversionClass = this.conversions.get((Object)logicalType.getTypeRoot());
        if (conversionClass != null) {
            return dataType2.bridgedTo(conversionClass);
        }
        return dataType2;
    }
}

