/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction.utils;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ExtractionVersion;
import org.apache.flink.table.annotation.HintFlag;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.catalog.DataTypeLookup;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.utils.ExtractionUtils;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
public final class DataTypeTemplate {
    private static final DataTypeHint DEFAULT_ANNOTATION = DataTypeTemplate.getDefaultAnnotation();
    private static final String RAW_TYPE_NAME = "RAW";
    @Nullable
    public final DataType dataType;
    @Nullable
    public final Class<? extends TypeSerializer<?>> rawSerializer;
    @Nullable
    public final InputGroup inputGroup;
    @Nullable
    public final ExtractionVersion version;
    @Nullable
    public final Boolean allowRawGlobally;
    @Nullable
    public final String[] allowRawPattern;
    @Nullable
    public final String[] forceRawPattern;
    @Nullable
    public final Integer defaultDecimalPrecision;
    @Nullable
    public final Integer defaultDecimalScale;
    @Nullable
    public final Integer defaultYearPrecision;
    @Nullable
    public final Integer defaultSecondPrecision;

    private DataTypeTemplate(@Nullable DataType dataType2, @Nullable Class<? extends TypeSerializer<?>> rawSerializer, @Nullable InputGroup inputGroup, @Nullable ExtractionVersion version, @Nullable Boolean allowRawGlobally, @Nullable String[] allowRawPattern, @Nullable String[] forceRawPattern, @Nullable Integer defaultDecimalPrecision, @Nullable Integer defaultDecimalScale, @Nullable Integer defaultYearPrecision, @Nullable Integer defaultSecondPrecision) {
        this.dataType = dataType2;
        this.rawSerializer = rawSerializer;
        this.inputGroup = inputGroup;
        this.version = version;
        this.allowRawGlobally = allowRawGlobally;
        this.allowRawPattern = allowRawPattern;
        this.forceRawPattern = forceRawPattern;
        this.defaultDecimalPrecision = defaultDecimalPrecision;
        this.defaultDecimalScale = defaultDecimalScale;
        this.defaultYearPrecision = defaultYearPrecision;
        this.defaultSecondPrecision = defaultSecondPrecision;
    }

    public static DataTypeTemplate fromAnnotation(DataTypeLookup lookup, DataTypeHint hint) {
        String typeName = DataTypeTemplate.defaultAsNull(hint, DataTypeHint::value);
        Class conversionClass = DataTypeTemplate.defaultAsNull(hint, DataTypeHint::bridgedTo);
        if (typeName != null || conversionClass != null) {
            DataTypeTemplate extractionTemplate = DataTypeTemplate.fromAnnotation(hint, null);
            return DataTypeTemplate.fromAnnotation(hint, DataTypeTemplate.extractDataType(lookup, typeName, conversionClass, extractionTemplate));
        }
        return DataTypeTemplate.fromAnnotation(hint, null);
    }

    public static DataTypeTemplate fromAnnotation(DataTypeHint hint, @Nullable DataType dataType2) {
        return new DataTypeTemplate(dataType2, DataTypeTemplate.defaultAsNull(hint, DataTypeHint::rawSerializer), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::inputGroup), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::version), DataTypeTemplate.hintFlagToBoolean(DataTypeTemplate.defaultAsNull(hint, DataTypeHint::allowRawGlobally)), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::allowRawPattern), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::forceRawPattern), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultDecimalPrecision), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultDecimalScale), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultYearPrecision), DataTypeTemplate.defaultAsNull(hint, DataTypeHint::defaultSecondPrecision));
    }

    public static DataTypeTemplate fromDefaults() {
        return new DataTypeTemplate(null, null, null, null, null, null, null, null, null, null, null);
    }

    public DataTypeTemplate copyWithoutDataType() {
        return new DataTypeTemplate(null, this.rawSerializer, this.inputGroup, this.version, this.allowRawGlobally, this.allowRawPattern, this.forceRawPattern, this.defaultDecimalPrecision, this.defaultDecimalScale, this.defaultYearPrecision, this.defaultSecondPrecision);
    }

    public DataTypeTemplate mergeWithInnerAnnotation(DataTypeLookup lookup, DataTypeHint hint) {
        DataTypeTemplate otherTemplate = DataTypeTemplate.fromAnnotation(lookup, hint);
        return new DataTypeTemplate(otherTemplate.dataType, DataTypeTemplate.rightValueIfNotNull(this.rawSerializer, otherTemplate.rawSerializer), DataTypeTemplate.rightValueIfNotNull(this.inputGroup, otherTemplate.inputGroup), DataTypeTemplate.rightValueIfNotNull(this.version, otherTemplate.version), DataTypeTemplate.rightValueIfNotNull(this.allowRawGlobally, otherTemplate.allowRawGlobally), DataTypeTemplate.rightValueIfNotNull(this.allowRawPattern, otherTemplate.allowRawPattern), DataTypeTemplate.rightValueIfNotNull(this.forceRawPattern, otherTemplate.forceRawPattern), DataTypeTemplate.rightValueIfNotNull(this.defaultDecimalPrecision, otherTemplate.defaultDecimalPrecision), DataTypeTemplate.rightValueIfNotNull(this.defaultDecimalScale, otherTemplate.defaultDecimalScale), DataTypeTemplate.rightValueIfNotNull(this.defaultYearPrecision, otherTemplate.defaultYearPrecision), DataTypeTemplate.rightValueIfNotNull(this.defaultSecondPrecision, otherTemplate.defaultSecondPrecision));
    }

    public boolean hasDataTypeDefinition() {
        return this.dataType != null;
    }

    public boolean hasInputGroupDefinition() {
        return this.inputGroup != null && this.inputGroup != InputGroup.UNKNOWN;
    }

    public ArgumentTypeStrategy toArgumentTypeStrategy() {
        if (this.hasDataTypeDefinition()) {
            return InputTypeStrategies.explicit(this.dataType);
        }
        if (this.hasInputGroupDefinition() && this.inputGroup == InputGroup.ANY) {
            return InputTypeStrategies.ANY;
        }
        throw ExtractionUtils.extractionError("Data type hint does neither specify an explicit data type nor an input group.", new Object[0]);
    }

    public TypeStrategy toTypeStrategy() {
        if (this.hasDataTypeDefinition()) {
            return TypeStrategies.explicit(this.dataType);
        }
        throw ExtractionUtils.extractionError("Data type hint does not specify an explicit data type.", new Object[0]);
    }

    public boolean isAllowRawGlobally() {
        return this.allowRawGlobally != null && this.allowRawGlobally != false;
    }

    public boolean isAllowAnyPattern(@Nullable Class<?> clazz) {
        if (this.allowRawPattern == null || clazz == null) {
            return false;
        }
        String className = clazz.getName();
        for (String pattern : this.allowRawPattern) {
            if (!className.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean isForceAnyPattern(@Nullable Class<?> clazz) {
        if (this.forceRawPattern == null || clazz == null) {
            return false;
        }
        String className = clazz.getName();
        for (String pattern : this.forceRawPattern) {
            if (!className.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeTemplate that = (DataTypeTemplate)o;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.rawSerializer, that.rawSerializer) && Objects.equals((Object)this.inputGroup, (Object)that.inputGroup) && this.version == that.version && Objects.equals(this.allowRawGlobally, that.allowRawGlobally) && Arrays.equals(this.allowRawPattern, that.allowRawPattern) && Arrays.equals(this.forceRawPattern, that.forceRawPattern) && Objects.equals(this.defaultDecimalPrecision, that.defaultDecimalPrecision) && Objects.equals(this.defaultDecimalScale, that.defaultDecimalScale) && Objects.equals(this.defaultYearPrecision, that.defaultYearPrecision) && Objects.equals(this.defaultSecondPrecision, that.defaultSecondPrecision);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.dataType, this.rawSerializer, this.inputGroup, this.version, this.allowRawGlobally, this.defaultDecimalPrecision, this.defaultDecimalScale, this.defaultYearPrecision, this.defaultSecondPrecision});
        result = 31 * result + Arrays.hashCode(this.allowRawPattern);
        result = 31 * result + Arrays.hashCode(this.forceRawPattern);
        return result;
    }

    private static DataTypeHint getDefaultAnnotation() {
        return DefaultAnnotationHelper.class.getAnnotation(DataTypeHint.class);
    }

    private static <T> T defaultAsNull(DataTypeHint hint, Function<DataTypeHint, T> accessor) {
        T actualValue;
        T defaultValue = accessor.apply(DEFAULT_ANNOTATION);
        if (Objects.deepEquals(defaultValue, actualValue = accessor.apply(hint))) {
            return null;
        }
        return actualValue;
    }

    private static <T> T rightValueIfNotNull(T l, T r) {
        if (r != null) {
            return r;
        }
        return l;
    }

    private static Boolean hintFlagToBoolean(HintFlag flag) {
        if (flag == null) {
            return null;
        }
        return flag == HintFlag.TRUE;
    }

    private static DataType extractDataType(DataTypeLookup lookup, @Nullable String typeName, @Nullable Class<?> conversionClass, DataTypeTemplate template) {
        if (typeName != null) {
            if (typeName.equals(RAW_TYPE_NAME)) {
                return ExtractionUtils.createRawType(lookup, template.rawSerializer, conversionClass);
            }
            return lookup.lookupDataType(typeName).map(dataType2 -> {
                if (conversionClass != null) {
                    return dataType2.bridgedTo(conversionClass);
                }
                return dataType2;
            }).orElseThrow(() -> ExtractionUtils.extractionError("Could not resolve type with name '%s'.", typeName));
        }
        if (conversionClass != null) {
            return DataTypeExtractor.extractFromType(lookup, template, conversionClass);
        }
        throw ExtractionUtils.extractionError("Data type hint does neither specify an explicit data type or conversion class from which a data type could be extracted.", new Object[0]);
    }

    @DataTypeHint
    private static class DefaultAnnotationHelper {
        private DefaultAnnotationHelper() {
        }
    }
}

