/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.List;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.tsextractors.TimestampExtractorUtils;
import org.apache.flink.table.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class TableSourceUtil$ {
    public static final TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, Option<int[]> selectedFields) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute.");
                }
                if (selectedFields.isEmpty()) {
                    object = new Some((Object)descriptors.get(0));
                } else {
                    RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                    int fieldIdx = Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getFieldNames()).indexOf((Object)descriptor.getAttributeName());
                    object = Predef$.MODULE$.intArrayOps((int[])selectedFields.get()).contains((Object)BoxesRunTime.boxToInteger((int)fieldIdx)) ? new Some((Object)descriptor) : None$.MODULE$;
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public RexNode getRowtimeExtractionExpression(TimestampExtractor extractor, DataType physicalInputType, DataType expectedDataType, FlinkRelBuilder relBuilder, Function<String, String> nameMapping) {
        ResolvedFieldReference[] accessedFields = TimestampExtractorUtils.getAccessedFields(extractor, physicalInputType, nameMapping);
        relBuilder.push(this.createSchemaRelNode(accessedFields, relBuilder.getCluster()));
        RexNode expr = this.constructExpression(expectedDataType, extractor, accessedFields).accept(PlannerExpressionConverter$.MODULE$.INSTANCE()).toRexNode(relBuilder);
        relBuilder.clear();
        return expr;
    }

    private RelNode createSchemaRelNode(ResolvedFieldReference[] fields, RelOptCluster cluster) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ResolvedFieldReference x$1) {
                return x$1.fieldIndex();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<String, TypeInformation<Object>>> apply(ResolvedFieldReference f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)f.fieldIndex())), (Object)new Tuple2((Object)f.name(), f.resultType()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1)new Serializable(idxMap){
            public static final long serialVersionUID = 0L;
            private final Map idxMap$1;

            public final Tuple2<String, TypeInformation<?>> apply(int i) {
                return (Tuple2)this.idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, TypeInformation<Byte>> apply() {
                        return new Tuple2((Object)"", Types.BYTE());
                    }
                });
            }
            {
                this.idxMap$1 = idxMap$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
            IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
            IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
            IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
            RelDataType physicalSchema = ((FlinkTypeFactory)cluster.getTypeFactory()).buildLogicalRowType((Seq<String>)physicalFields2, (Seq<TypeInformation<?>>)physicalTypes2);
            return LogicalValues.createEmpty(cluster, physicalSchema);
        }
        throw new MatchError((Object)tuple2);
    }

    private Expression constructExpression(DataType expectedType, TimestampExtractor timestampExtractor, ResolvedFieldReference[] fieldAccesses) {
        Expression expression2 = timestampExtractor.getExpression(fieldAccesses);
        return ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.CAST, ApiExpressionUtils.unresolvedCall(BuiltInFunctionDefinitions.CAST, expression2, ApiExpressionUtils.typeLiteral(DataTypes.BIGINT())), ApiExpressionUtils.typeLiteral(expectedType));
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

