/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.OldCsvValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.utils.TableSchemaUtils;

@Internal
public abstract class CsvTableSourceFactoryBase
implements TableFactory {
    @Override
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "filesystem");
        context.put("format.type", "csv");
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return context;
    }

    @Override
    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.path");
        properties.add("format.fields.#.type");
        properties.add("format.fields.#.data-type");
        properties.add("format.fields.#.name");
        properties.add("format.derive-schema");
        properties.add("format.field-delimiter");
        properties.add("format.line-delimiter");
        properties.add("format.quote-character");
        properties.add("format.comment-prefix");
        properties.add("format.ignore-first-line");
        properties.add("format.ignore-parse-errors");
        properties.add("connector.path");
        properties.add("schema.#.type");
        properties.add("schema.#.data-type");
        properties.add("schema.#.name");
        properties.add("schema.#.expr");
        properties.add("schema.watermark.#.rowtime");
        properties.add("schema.watermark.#.strategy.expr");
        properties.add("schema.watermark.#.strategy.data-type");
        return properties;
    }

    protected CsvTableSource createTableSource(Boolean isStreaming, Map<String, String> properties) {
        TableSchema formatSchema;
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new OldCsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema(params.getTableSchema("schema"));
        boolean hasSchema = params.hasPrefix("format.fields");
        if (hasSchema && !(formatSchema = params.getTableSchema("format.fields")).equals(tableSchema)) {
            throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
        }
        params.getOptionalString("connector.path").ifPresent(csvTableSourceBuilder::path);
        params.getOptionalString("format.field-delimiter").ifPresent(csvTableSourceBuilder::fieldDelimiter);
        params.getOptionalString("format.line-delimiter").ifPresent(csvTableSourceBuilder::lineDelimiter);
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            csvTableSourceBuilder.field(tableSchema.getFieldNames()[i], tableSchema.getFieldDataTypes()[i]);
        }
        params.getOptionalCharacter("format.quote-character").ifPresent(csvTableSourceBuilder::quoteCharacter);
        params.getOptionalString("format.comment-prefix").ifPresent(csvTableSourceBuilder::commentPrefix);
        params.getOptionalBoolean("format.ignore-first-line").ifPresent(flag -> {
            if (flag.booleanValue()) {
                csvTableSourceBuilder.ignoreFirstLine();
            }
        });
        params.getOptionalBoolean("format.ignore-parse-errors").ifPresent(flag -> {
            if (flag.booleanValue()) {
                csvTableSourceBuilder.ignoreParseErrors();
            }
        });
        return csvTableSourceBuilder.build();
    }
}

