/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.CalciteParser;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.sqlexec.SqlToOperationConverter;

public class ParserImpl
implements Parser {
    private final CatalogManager catalogManager;
    private final Supplier<FlinkPlannerImpl> validatorSupplier;
    private final Supplier<CalciteParser> calciteParserSupplier;

    public ParserImpl(CatalogManager catalogManager, Supplier<FlinkPlannerImpl> validatorSupplier, Supplier<CalciteParser> calciteParserSupplier) {
        this.catalogManager = catalogManager;
        this.validatorSupplier = validatorSupplier;
        this.calciteParserSupplier = calciteParserSupplier;
    }

    @Override
    public List<Operation> parse(String statement) {
        CalciteParser parser = this.calciteParserSupplier.get();
        FlinkPlannerImpl planner = this.validatorSupplier.get();
        SqlNode parsed = parser.parse(statement);
        Operation operation = SqlToOperationConverter.convert(planner, this.catalogManager, parsed).orElseThrow(() -> new TableException("Unsupported SQL query! parse() only accepts SQL queries of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, ORDER_BY or INSERT;and SQL DDLs of type CREATE TABLE"));
        return Collections.singletonList(operation);
    }

    @Override
    public UnresolvedIdentifier parseIdentifier(String identifier) {
        CalciteParser parser = this.calciteParserSupplier.get();
        SqlIdentifier sqlIdentifier = parser.parseIdentifier(identifier);
        return UnresolvedIdentifier.of(sqlIdentifier.names.toArray(new String[0]));
    }
}

