/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.plan.nodes.CommonMatchRecognize;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public abstract class CommonMatchRecognize$class {
    private static String partitionKeysToString(CommonMatchRecognize $this, ImmutableBitSet keys, Seq fieldNames) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(keys.toArray()).map((Function1)new Serializable($this, fieldNames){
            public static final long serialVersionUID = 0L;
            private final Seq fieldNames$1;

            public final String apply(int k) {
                return (String)this.fieldNames$1.apply(k);
            }
            {
                this.fieldNames$1 = fieldNames$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
    }

    private static String orderingToString(CommonMatchRecognize $this, RelCollation orders, Seq fieldNames) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orders.getFieldCollations()).asScala()).map((Function1)new Serializable($this, fieldNames){
            public static final long serialVersionUID = 0L;
            private final Seq fieldNames$2;

            public final String apply(RelFieldCollation x) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fieldNames$2.apply(x.getFieldIndex()), SortUtil$.MODULE$.directionToOrder(x.direction).getShortName()}));
            }
            {
                this.fieldNames$2 = fieldNames$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private static String measuresDefineToString(CommonMatchRecognize $this, ImmutableMap measures, Seq fieldNames, Function3 expression2) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)measures).asScala()).map((Function1)new Serializable($this, fieldNames, expression2){
            public static final long serialVersionUID = 0L;
            private final Seq fieldNames$3;
            private final Function3 expression$1;

            public final String apply(Tuple2<String, RexNode> x0$1) {
                Tuple2<String, RexNode> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    RexNode v = (RexNode)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expression$1.apply((Object)v, (Object)this.fieldNames$3, (Object)None$.MODULE$), k}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldNames$3 = fieldNames$3;
                this.expression$1 = expression$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private static String rowsPerMatchToString(CommonMatchRecognize $this, boolean isAll) {
        return isAll ? "ALL ROWS PER MATCH" : "ONE ROW PER MATCH";
    }

    private static String subsetToString(CommonMatchRecognize $this, ImmutableMap subset) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)subset).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, SortedSet<String>> x0$2) {
                Tuple2<String, SortedSet<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    SortedSet v = (SortedSet)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)v).asScala()).mkString(", ")}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private static String afterMatchToString(CommonMatchRecognize $this, RexNode after, Seq fieldNames) {
        block5: {
            SqlMatchRecognize.AfterOption afterOption;
            block8: {
                String string;
                block3: {
                    String string2;
                    block7: {
                        block6: {
                            SqlKind sqlKind;
                            block4: {
                                block2: {
                                    sqlKind = after.getKind();
                                    if (!((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) break block2;
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SKIP TO FIRST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RexNode)((RexCall)after).operands.get(0)).toString()}));
                                    break block3;
                                }
                                if (!((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) break block4;
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SKIP TO LAST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((RexNode)((RexCall)after).operands.get(0)).toString()}));
                                break block3;
                            }
                            if (!((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) break block5;
                            afterOption = ((RexLiteral)after).getValueAs(SqlMatchRecognize.AfterOption.class);
                            if (!((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW)).equals((Object)afterOption)) break block6;
                            string2 = "SKIP PAST LAST ROW";
                            break block7;
                        }
                        if (!((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW)).equals((Object)afterOption)) break block8;
                        string2 = "SKIP TO NEXT ROW";
                    }
                    string = string2;
                }
                return string;
            }
            throw new MatchError((Object)afterOption);
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupted query tree. Unexpected ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{after}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after match strategy."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public static String matchToString(CommonMatchRecognize $this, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression2) {
        String partitionBy = logicalMatch.partitionKeys().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PARTITION BY: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.partitionKeysToString($this, logicalMatch.partitionKeys(), fieldNames)}));
        String orderBy = logicalMatch.orderKeys().getFieldCollations().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ORDER BY: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.orderingToString($this, logicalMatch.orderKeys(), fieldNames)}));
        String measures = logicalMatch.measures().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEASURES: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.measuresDefineToString($this, logicalMatch.measures(), fieldNames, expression2)}));
        String afterMatch = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.afterMatchToString($this, logicalMatch.after(), fieldNames)}));
        String allRows = CommonMatchRecognize$class.rowsPerMatchToString($this, logicalMatch.allRows());
        String pattern = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PATTERN: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalMatch.pattern().toString()}));
        String subset = logicalMatch.subsets().isEmpty() ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUBSET: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.subsetToString($this, logicalMatch.subsets())}));
        String define = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEFINE: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonMatchRecognize$class.measuresDefineToString($this, logicalMatch.patternDefinitions(), fieldNames, expression2)}));
        String body = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partitionBy, orderBy, measures, allRows, afterMatch, pattern, subset, define}))).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.isEmpty();
            }
        })).mkString(", ");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Match(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{body}));
    }

    public static RelWriter explainMatch(CommonMatchRecognize $this, RelWriter pw, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression2) {
        return pw.itemIf("partitionBy", CommonMatchRecognize$class.partitionKeysToString($this, logicalMatch.partitionKeys(), fieldNames), !logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", CommonMatchRecognize$class.orderingToString($this, logicalMatch.orderKeys(), fieldNames), !logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", CommonMatchRecognize$class.measuresDefineToString($this, logicalMatch.measures(), fieldNames, expression2), !logicalMatch.measures().isEmpty()).item("rowsPerMatch", CommonMatchRecognize$class.rowsPerMatchToString($this, logicalMatch.allRows())).item("after", CommonMatchRecognize$class.afterMatchToString($this, logicalMatch.after(), fieldNames)).item("pattern", logicalMatch.pattern().toString()).itemIf("subset", CommonMatchRecognize$class.subsetToString($this, logicalMatch.subsets()), !logicalMatch.subsets().isEmpty()).item("define", logicalMatch.patternDefinitions());
    }

    public static void $init$(CommonMatchRecognize $this) {
    }
}

