/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils.factories;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.ProjectQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public final class ProjectionOperationFactory {
    private final TransitiveExtractNameVisitor extractTransitiveNameVisitor = new TransitiveExtractNameVisitor();
    private final StripAliases stripAliases = new StripAliases();
    private int currentFieldIndex = 0;

    public QueryOperation create(List<ResolvedExpression> projectList, QueryOperation child, boolean explicitAlias, ExpressionResolver.PostResolverFactory postResolverFactory) {
        NamingVisitor namingVisitor = new NamingVisitor(postResolverFactory);
        List<ResolvedExpression> namedExpressions = this.nameExpressions(namingVisitor, projectList);
        String[] fieldNames = this.validateAndGetUniqueNames(namedExpressions);
        List<ResolvedExpression> finalExpression = explicitAlias ? namedExpressions : namedExpressions.stream().map(expr -> expr.accept(this.stripAliases)).collect(Collectors.toList());
        DataType[] fieldTypes = (DataType[])namedExpressions.stream().map(ResolvedExpression::getOutputDataType).toArray(DataType[]::new);
        TableSchema tableSchema = TableSchema.builder().fields(fieldNames, fieldTypes).build();
        return new ProjectQueryOperation(finalExpression, child, tableSchema);
    }

    private String[] validateAndGetUniqueNames(List<ResolvedExpression> namedExpressions) {
        LinkedHashSet names = new LinkedHashSet();
        OperationExpressionsUtils.extractNames(namedExpressions).stream().map(name -> (String)name.orElseThrow(() -> new TableException("Could not name a field in a projection."))).forEach(name -> {
            if (!names.add(name)) {
                throw new ValidationException("Ambiguous column name: " + name);
            }
        });
        return names.toArray(new String[0]);
    }

    private List<ResolvedExpression> nameExpressions(NamingVisitor namingVisitor, List<ResolvedExpression> expression2) {
        return IntStream.range(0, expression2.size()).mapToObj(idx -> {
            this.currentFieldIndex = idx;
            return ((ResolvedExpression)expression2.get(idx)).accept(namingVisitor);
        }).collect(Collectors.toList());
    }

    private String getUniqueName() {
        return "_c" + this.currentFieldIndex++;
    }

    private class TransitiveExtractNameVisitor
    extends ResolvedExpressionDefaultVisitor<Optional<String>> {
        private TransitiveExtractNameVisitor() {
        }

        @Override
        public Optional<String> visit(CallExpression call) {
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.GET) {
                return this.extractNameFromGet(call);
            }
            return this.defaultMethod(call);
        }

        @Override
        protected Optional<String> defaultMethod(ResolvedExpression expression2) {
            return OperationExpressionsUtils.extractName(expression2);
        }

        private Optional<String> extractNameFromGet(CallExpression call) {
            Expression child = call.getChildren().get(0);
            ValueLiteralExpression key = (ValueLiteralExpression)call.getChildren().get(1);
            LogicalType keyType = key.getOutputDataType().getLogicalType();
            String keySuffix = LogicalTypeChecks.hasRoot(keyType, LogicalTypeRoot.INTEGER) ? "$_" + key.getValueAs(Integer.class).orElseThrow(() -> new TableException("Integer constant excepted.")) : "$" + key.getValueAs(String.class).orElseThrow(() -> new TableException("Integer constant excepted."));
            return child.accept(this).map(p -> p + keySuffix);
        }
    }

    private class StripAliases
    extends ResolvedExpressionDefaultVisitor<ResolvedExpression> {
        private StripAliases() {
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                return call.getResolvedChildren().get(0).accept(this);
            }
            return call;
        }

        @Override
        protected ResolvedExpression defaultMethod(ResolvedExpression expression2) {
            return expression2;
        }
    }

    private class NamingVisitor
    extends ResolvedExpressionDefaultVisitor<ResolvedExpression> {
        private ExpressionResolver.PostResolverFactory postResolverFactory;

        public NamingVisitor(ExpressionResolver.PostResolverFactory postResolverFactory) {
            this.postResolverFactory = postResolverFactory;
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            FunctionDefinition functionDefinition = call.getFunctionDefinition();
            Optional<Object> rename = functionDefinition == BuiltInFunctionDefinitions.CAST ? this.nameForCast(call) : (functionDefinition == BuiltInFunctionDefinitions.GET ? this.nameForGet(call) : (functionDefinition == BuiltInFunctionDefinitions.AS ? Optional.empty() : Optional.of(ProjectionOperationFactory.this.getUniqueName())));
            return rename.map(name -> this.postResolverFactory.as(call, (String)name)).orElse(call);
        }

        private Optional<String> nameForGet(CallExpression call) {
            return Optional.of(call.accept(ProjectionOperationFactory.this.extractTransitiveNameVisitor).orElseGet(() -> ProjectionOperationFactory.this.getUniqueName()));
        }

        private Optional<String> nameForCast(CallExpression call) {
            Optional<String> innerName = call.getChildren().get(0).accept(ProjectionOperationFactory.this.extractTransitiveNameVisitor);
            Expression type = call.getChildren().get(1);
            return Optional.of(innerName.map(n -> String.format("%s-%s", n, type)).orElseGet(() -> ProjectionOperationFactory.this.getUniqueName()));
        }

        @Override
        public ResolvedExpression visit(ValueLiteralExpression valueLiteral) {
            return this.postResolverFactory.as(valueLiteral, ProjectionOperationFactory.this.getUniqueName());
        }

        @Override
        protected ResolvedExpression defaultMethod(ResolvedExpression expression2) {
            return expression2;
        }
    }
}

