/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils.factories;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.expressions.utils.ResolvedExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.operations.CalculatedQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.typeutils.FieldInfoUtils;

@Internal
public class CalculatedTableFactory {
    public QueryOperation create(ResolvedExpression callExpr, String[] leftTableFieldNames) {
        FunctionTableCallVisitor calculatedTableCreator = new FunctionTableCallVisitor(leftTableFieldNames);
        return (QueryOperation)callExpr.accept(calculatedTableCreator);
    }

    private class FunctionTableCallVisitor
    extends ResolvedExpressionDefaultVisitor<CalculatedQueryOperation<?>> {
        private String[] leftTableFieldNames;

        public FunctionTableCallVisitor(String[] leftTableFieldNames) {
            this.leftTableFieldNames = leftTableFieldNames;
        }

        @Override
        public CalculatedQueryOperation<?> visit(CallExpression call) {
            FunctionDefinition definition = call.getFunctionDefinition();
            if (definition.equals(BuiltInFunctionDefinitions.AS)) {
                return this.unwrapFromAlias(call);
            }
            if (definition instanceof TableFunctionDefinition) {
                return this.createFunctionCall((TableFunctionDefinition)definition, Collections.emptyList(), call.getResolvedChildren());
            }
            return this.defaultMethod(call);
        }

        private CalculatedQueryOperation<?> unwrapFromAlias(CallExpression call) {
            List<Expression> children = call.getChildren();
            List<String> aliases = children.subList(1, children.size()).stream().map(alias2 -> ExpressionUtils.extractValue(alias2, String.class).orElseThrow(() -> new ValidationException("Unexpected alias: " + alias2))).collect(Collectors.toList());
            if (!ApiExpressionUtils.isFunctionOfKind(children.get(0), FunctionKind.TABLE)) {
                throw this.fail();
            }
            CallExpression tableCall = (CallExpression)children.get(0);
            TableFunctionDefinition tableFunctionDefinition = (TableFunctionDefinition)tableCall.getFunctionDefinition();
            return this.createFunctionCall(tableFunctionDefinition, aliases, tableCall.getResolvedChildren());
        }

        private CalculatedQueryOperation<?> createFunctionCall(TableFunctionDefinition tableFunctionDefinition, List<String> aliases, List<ResolvedExpression> parameters) {
            String[] fieldNames;
            TypeInformation<?> resultType2 = tableFunctionDefinition.getResultType();
            int callArity = resultType2.getTotalFields();
            int aliasesSize = aliases.size();
            if (aliasesSize == 0) {
                fieldNames = FieldInfoUtils.getFieldNames(resultType2, Arrays.asList(this.leftTableFieldNames));
            } else {
                if (aliasesSize != callArity) {
                    throw new ValidationException(String.format("List of column aliases must have same degree as table; the returned table of function '%s' has %d columns, whereas alias list has %d columns", tableFunctionDefinition.toString(), callArity, aliasesSize));
                }
                fieldNames = aliases.toArray(new String[aliasesSize]);
            }
            TypeInformation<?>[] fieldTypes = FieldInfoUtils.getFieldTypes(resultType2);
            return new CalculatedQueryOperation(tableFunctionDefinition.getTableFunction(), parameters, tableFunctionDefinition.getResultType(), new TableSchema(fieldNames, fieldTypes));
        }

        @Override
        protected CalculatedQueryOperation<?> defaultMethod(ResolvedExpression expression2) {
            throw this.fail();
        }

        private ValidationException fail() {
            return new ValidationException("A lateral join only accepts a string expression which defines a table function call that might be followed by some alias.");
        }
    }
}

