/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class CalculatedQueryOperation<T>
implements QueryOperation {
    private final TableFunction<T> tableFunction;
    private final List<ResolvedExpression> parameters;
    private final TypeInformation<T> resultType;
    private final TableSchema tableSchema;

    public CalculatedQueryOperation(TableFunction<T> tableFunction, List<ResolvedExpression> parameters, TypeInformation<T> resultType2, TableSchema tableSchema) {
        this.tableFunction = tableFunction;
        this.parameters = parameters;
        this.resultType = resultType2;
        this.tableSchema = tableSchema;
    }

    public TableFunction<T> getTableFunction() {
        return this.tableFunction;
    }

    public List<ResolvedExpression> getParameters() {
        return this.parameters;
    }

    public TypeInformation<T> getResultType() {
        return this.resultType;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("function", this.tableFunction);
        args.put("parameters", this.parameters);
        return OperationUtils.formatWithChildren("CalculatedTable", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <U> U accept(QueryOperationVisitor<U> visitor) {
        return visitor.visit(this);
    }
}

